/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.cjk;

import com.google.appengine.repackaged.org.apache.lucene.analysis.Analyzer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.StopFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.Tokenizer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.cjk.CJKTokenizer;
import com.google.appengine.repackaged.org.apache.lucene.util.Version;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;

public class CJKAnalyzer
extends Analyzer {
    public static final String[] STOP_WORDS = new String[]{"a", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "s", "such", "t", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with", "", "www"};
    private Set stopTable;
    private final Version matchVersion;

    public CJKAnalyzer() {
        this(Version.LUCENE_24);
    }

    public CJKAnalyzer(Version matchVersion) {
        this.stopTable = StopFilter.makeStopSet(STOP_WORDS);
        this.matchVersion = matchVersion;
    }

    public CJKAnalyzer(String[] stopWords) {
        this(Version.LUCENE_24, stopWords);
    }

    public CJKAnalyzer(Version matchVersion, String[] stopWords) {
        this.stopTable = StopFilter.makeStopSet(stopWords);
        this.matchVersion = matchVersion;
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        return new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), (TokenStream)new CJKTokenizer(reader), this.stopTable);
    }

    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new CJKTokenizer(reader);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), (TokenStream)streams.source, this.stopTable);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

