/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.datastore.core.rep.ListResponse;

final class AutoValue_ListResponse<T>
extends ListResponse<T> {
    private final ImmutableList<T> results;
    private final String nextPageToken;

    private AutoValue_ListResponse(ImmutableList<T> results, String nextPageToken) {
        this.results = results;
        this.nextPageToken = nextPageToken;
    }

    @Override
    public ImmutableList<T> results() {
        return this.results;
    }

    @Override
    public String nextPageToken() {
        return this.nextPageToken;
    }

    public String toString() {
        String string = String.valueOf(this.results);
        String string2 = this.nextPageToken;
        return new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("ListResponse{results=").append(string).append(", nextPageToken=").append(string2).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ListResponse) {
            ListResponse that = (ListResponse)o;
            return this.results.equals(that.results()) && this.nextPageToken.equals(that.nextPageToken());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.results.hashCode();
        h$ *= 1000003;
        return h$ ^= this.nextPageToken.hashCode();
    }

    @Override
    public ListResponse.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends ListResponse.Builder<T> {
        private ImmutableList<T> results;
        private String nextPageToken;

        Builder() {
        }

        private Builder(ListResponse<T> source) {
            this.results = source.results();
            this.nextPageToken = source.nextPageToken();
        }

        @Override
        public ListResponse.Builder<T> results(ImmutableList<T> results) {
            if (results == null) {
                throw new NullPointerException("Null results");
            }
            this.results = results;
            return this;
        }

        @Override
        public ListResponse.Builder<T> nextPageToken(String nextPageToken) {
            if (nextPageToken == null) {
                throw new NullPointerException("Null nextPageToken");
            }
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListResponse<T> build() {
            String missing = "";
            if (this.results == null) {
                missing = String.valueOf(missing).concat(" results");
            }
            if (this.nextPageToken == null) {
                missing = String.valueOf(missing).concat(" nextPageToken");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_ListResponse(this.results, this.nextPageToken);
        }
    }
}

