/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.MutationResult;
import com.google.cloud.datastore.core.rep.Value;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.Nullable;

final class AutoValue_MutationResult
extends MutationResult {
    private final OnestoreEntity.Reference key;
    private final Entity entity;
    private final ImmutableList<Value> transformedValues;
    private final boolean isDelete;
    private final boolean keyWasAllocated;
    private final boolean conflictDetected;
    private final long createVersion;
    private final long updateVersion;
    private final DatastoreException exception;

    private AutoValue_MutationResult(OnestoreEntity.Reference key, @Nullable Entity entity, @Nullable ImmutableList<Value> transformedValues, boolean isDelete, boolean keyWasAllocated, boolean conflictDetected, long createVersion, long updateVersion, @Nullable DatastoreException exception) {
        this.key = key;
        this.entity = entity;
        this.transformedValues = transformedValues;
        this.isDelete = isDelete;
        this.keyWasAllocated = keyWasAllocated;
        this.conflictDetected = conflictDetected;
        this.createVersion = createVersion;
        this.updateVersion = updateVersion;
        this.exception = exception;
    }

    @Override
    public OnestoreEntity.Reference key() {
        return this.key;
    }

    @Override
    @Nullable
    public Entity entity() {
        return this.entity;
    }

    @Override
    @Nullable
    public ImmutableList<Value> transformedValues() {
        return this.transformedValues;
    }

    @Override
    public boolean isDelete() {
        return this.isDelete;
    }

    @Override
    public boolean keyWasAllocated() {
        return this.keyWasAllocated;
    }

    @Override
    public boolean conflictDetected() {
        return this.conflictDetected;
    }

    @Override
    public long createVersion() {
        return this.createVersion;
    }

    @Override
    public long updateVersion() {
        return this.updateVersion;
    }

    @Override
    @Nullable
    public DatastoreException exception() {
        return this.exception;
    }

    public String toString() {
        String string = String.valueOf(this.key);
        String string2 = String.valueOf(this.entity);
        String string3 = String.valueOf(this.transformedValues);
        boolean bl = this.isDelete;
        boolean bl2 = this.keyWasAllocated;
        boolean bl3 = this.conflictDetected;
        long l = this.createVersion;
        long l2 = this.updateVersion;
        String string4 = String.valueOf(this.exception);
        return new StringBuilder(196 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("MutationResult{key=").append(string).append(", entity=").append(string2).append(", transformedValues=").append(string3).append(", isDelete=").append(bl).append(", keyWasAllocated=").append(bl2).append(", conflictDetected=").append(bl3).append(", createVersion=").append(l).append(", updateVersion=").append(l2).append(", exception=").append(string4).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MutationResult) {
            MutationResult that = (MutationResult)o;
            return this.key.equals(that.key()) && (this.entity == null ? that.entity() == null : this.entity.equals(that.entity())) && (this.transformedValues == null ? that.transformedValues() == null : this.transformedValues.equals(that.transformedValues())) && this.isDelete == that.isDelete() && this.keyWasAllocated == that.keyWasAllocated() && this.conflictDetected == that.conflictDetected() && this.createVersion == that.createVersion() && this.updateVersion == that.updateVersion() && (this.exception == null ? that.exception() == null : this.exception.equals(that.exception()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.key.hashCode();
        h$ *= 1000003;
        h$ ^= this.entity == null ? 0 : this.entity.hashCode();
        h$ *= 1000003;
        h$ ^= this.transformedValues == null ? 0 : this.transformedValues.hashCode();
        h$ *= 1000003;
        h$ ^= this.isDelete ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.keyWasAllocated ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.conflictDetected ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= (int)(this.createVersion >>> 32 ^ this.createVersion);
        h$ *= 1000003;
        h$ ^= (int)(this.updateVersion >>> 32 ^ this.updateVersion);
        h$ *= 1000003;
        return h$ ^= this.exception == null ? 0 : this.exception.hashCode();
    }

    @Override
    public MutationResult.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends MutationResult.Builder {
        private OnestoreEntity.Reference key;
        private Entity entity;
        private ImmutableList<Value> transformedValues;
        private Boolean isDelete;
        private Boolean keyWasAllocated;
        private Boolean conflictDetected;
        private Long createVersion;
        private Long updateVersion;
        private DatastoreException exception;

        Builder() {
        }

        private Builder(MutationResult source) {
            this.key = source.key();
            this.entity = source.entity();
            this.transformedValues = source.transformedValues();
            this.isDelete = source.isDelete();
            this.keyWasAllocated = source.keyWasAllocated();
            this.conflictDetected = source.conflictDetected();
            this.createVersion = source.createVersion();
            this.updateVersion = source.updateVersion();
            this.exception = source.exception();
        }

        @Override
        public MutationResult.Builder key(OnestoreEntity.Reference key) {
            if (key == null) {
                throw new NullPointerException("Null key");
            }
            this.key = key;
            return this;
        }

        @Override
        public MutationResult.Builder entity(@Nullable Entity entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public MutationResult.Builder transformedValues(@Nullable List<Value> transformedValues) {
            this.transformedValues = transformedValues == null ? null : ImmutableList.copyOf(transformedValues);
            return this;
        }

        @Override
        public MutationResult.Builder isDelete(boolean isDelete) {
            this.isDelete = isDelete;
            return this;
        }

        @Override
        public MutationResult.Builder keyWasAllocated(boolean keyWasAllocated) {
            this.keyWasAllocated = keyWasAllocated;
            return this;
        }

        @Override
        public MutationResult.Builder conflictDetected(boolean conflictDetected) {
            this.conflictDetected = conflictDetected;
            return this;
        }

        @Override
        public MutationResult.Builder createVersion(long createVersion) {
            this.createVersion = createVersion;
            return this;
        }

        @Override
        public MutationResult.Builder updateVersion(long updateVersion) {
            this.updateVersion = updateVersion;
            return this;
        }

        @Override
        public MutationResult.Builder exception(DatastoreException exception) {
            this.exception = exception;
            return this;
        }

        @Override
        public MutationResult build() {
            String missing = "";
            if (this.key == null) {
                missing = String.valueOf(missing).concat(" key");
            }
            if (this.isDelete == null) {
                missing = String.valueOf(missing).concat(" isDelete");
            }
            if (this.keyWasAllocated == null) {
                missing = String.valueOf(missing).concat(" keyWasAllocated");
            }
            if (this.conflictDetected == null) {
                missing = String.valueOf(missing).concat(" conflictDetected");
            }
            if (this.createVersion == null) {
                missing = String.valueOf(missing).concat(" createVersion");
            }
            if (this.updateVersion == null) {
                missing = String.valueOf(missing).concat(" updateVersion");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_MutationResult(this.key, this.entity, this.transformedValues, this.isDelete, this.keyWasAllocated, this.conflictDetected, this.createVersion, this.updateVersion, this.exception);
        }
    }
}

