/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.appengine.repackaged.org.apache.http.cookie.Cookie;
import com.google.appengine.repackaged.org.apache.http.cookie.CookieOrigin;
import com.google.appengine.repackaged.org.apache.http.cookie.MalformedCookieException;
import com.google.appengine.repackaged.org.apache.http.impl.cookie.DefaultCookieSpec;
import com.google.appengine.repackaged.org.apache.http.message.BasicHeader;
import com.google.appengine.tools.remoteapi.AppEngineClient;
import com.google.appengine.tools.remoteapi.ClientLogin;
import com.google.appengine.tools.remoteapi.HostedAppEngineClient;
import com.google.appengine.tools.remoteapi.LoginException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class HostedClientLogin
extends ClientLogin {
    private final URLFetchService fetchService = URLFetchServiceFactory.getURLFetchService();

    @Override
    ClientLogin.PostResponse executePost(String urlStr, List<String[]> postParams) throws IOException {
        URL url = new URL(urlStr);
        StringBuilder payload = new StringBuilder();
        for (String[] param : postParams) {
            payload.append(String.format("%s=%s&", param[0], param[1]));
        }
        payload.setLength(payload.length() - 1);
        HTTPRequest req = new HTTPRequest(url, HTTPMethod.POST);
        req.setPayload(payload.toString().getBytes());
        HTTPResponse resp = this.fetchService.fetch(req);
        AppEngineClient.Response response = HostedAppEngineClient.createResponse(resp);
        return new ClientLogin.PostResponse(resp.getResponseCode(), response.getBodyAsString());
    }

    @Override
    List<Cookie> getAppEngineLoginCookies(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        FetchOptions fetchOptions = FetchOptions.Builder.doNotFollowRedirects();
        HTTPRequest req = new HTTPRequest(url, HTTPMethod.GET, fetchOptions);
        HTTPResponse resp = this.fetchService.fetch(req);
        if (resp.getResponseCode() != 302) {
            int n = resp.getResponseCode();
            throw new LoginException(new StringBuilder(48).append("unexpected response from app engine: ").append(n).toString());
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (HTTPHeader header : resp.getHeaders()) {
            if (!header.getName().toLowerCase().equals("set-cookie")) continue;
            DefaultCookieSpec spec = new DefaultCookieSpec();
            CookieOrigin cookieOrigin = new CookieOrigin(url.getHost(), url.getPort() == -1 ? 0 : url.getPort(), url.getPath(), url.getProtocol().equals("https"));
            BasicHeader h = new BasicHeader(header.getName(), header.getValue());
            try {
                cookies.addAll(spec.parse(h, cookieOrigin));
            }
            catch (MalformedCookieException e) {
                throw new IOException(e);
            }
        }
        return cookies;
    }
}

