/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.tools.remoteapi.RemoteApiDelegate;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import com.google.appengine.tools.remoteapi.RemoteRpc;
import com.google.apphosting.api.ApiProxy;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

class StandaloneRemoteApiDelegate
extends RemoteApiDelegate {
    private static final Logger logger = Logger.getLogger(RemoteApiDelegate.class.getName());
    private final ExecutorService executor;
    private final String currentUserEmail;

    public StandaloneRemoteApiDelegate(RemoteRpc rpc, RemoteApiOptions options) {
        super(rpc, options);
        this.currentUserEmail = options.getUserEmail();
        this.executor = Executors.newFixedThreadPool(options.getMaxConcurrentRequests());
    }

    public byte[] makeSyncCall(ApiProxy.Environment env, String serviceName, String methodName, byte[] request) {
        if (this.currentUserEmail != null && !env.getEmail().equals(this.currentUserEmail)) {
            String message = String.format("remote API call: user '%s' can't use client that's logged in as '%s'", env.getEmail(), this.currentUserEmail);
            throw new ApiProxy.ApiProxyException(message);
        }
        return this.makeDefaultSyncCall(serviceName, methodName, request);
    }

    public Future<byte[]> makeAsyncCall(final ApiProxy.Environment env, final String serviceName, final String methodName, final byte[] request, ApiProxy.ApiConfig apiConfig) {
        return this.executor.submit(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return StandaloneRemoteApiDelegate.this.makeSyncCall(env, serviceName, methodName, request);
            }
        });
    }

    public void log(ApiProxy.Environment environment, ApiProxy.LogRecord record) {
        long l = record.getTimestamp();
        String string = record.getMessage();
        logger.logp(StandaloneRemoteApiDelegate.toJavaLevel(record.getLevel()), "com.google.appengine.tools.remoteapi.StandaloneRemoteApiDelegate", "log", new StringBuilder(23 + String.valueOf(string).length()).append("[").append(l).append("] ").append(string).toString());
    }

    public List<Thread> getRequestThreads(ApiProxy.Environment environment) {
        return Collections.emptyList();
    }

    public void flushLogs(ApiProxy.Environment environment) {
    }

    @Override
    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    private static Level toJavaLevel(ApiProxy.LogRecord.Level apiProxyLevel) {
        switch (apiProxyLevel) {
            case debug: {
                return Level.FINE;
            }
            case info: {
                return Level.INFO;
            }
            case warn: {
                return Level.WARNING;
            }
            case error: {
                return Level.SEVERE;
            }
            case fatal: {
                return Level.SEVERE;
            }
        }
        return Level.WARNING;
    }
}

