/**********************************************************************
Copyright (c) 2002 Mike Martin (TJDO) and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 
 

Contributors:
2003 Andy Jefferson - coding standards
2004 Andy Jefferson - renamed from SubquerySetExpression
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

import org.datanucleus.exceptions.NucleusUserException;

/**
 * An expression for collections whose contents are expressed as a SQL subquery.
 *
 * @version $Revision: 1.9 $
 */
public class CollectionSubqueryExpression extends ScalarExpression
{
    private final QueryExpression subquery;

    /**
     * Constructor.
     * @param qs The main Query Statement
     * @param subquery The subquery Query Statement.
     **/
    public CollectionSubqueryExpression(QueryExpression qs,
                                        QueryExpression subquery)
    {
        super(qs);

        this.subquery = subquery;

        if (subquery.getNumberOfScalarExpressions() != 1)
        {
            throw new NucleusUserException("Cannot use as set expression, # of selected columns != 1. Subqueries must have at most 1 column: " + 
                subquery.toStatementText(false));
        }

        st.append("(").append(subquery).append(')');
    }

    /**
     * Contains method
     * @param expr the searched value represented by the expression
     * @return boolean true expression if this Collection contains the element <code>expr</code>
     */
    public BooleanExpression containsMethod(ScalarExpression expr)
    {
        return expr.in(this);
    }

    /**
     * isEmpty method
     * @return boolean true expression if this Collection has no elements
     */
    public BooleanExpression isEmptyMethod()
    {
        return new ExistsExpression(qs, subquery, false);
    }
}