/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.DirParser;
import org.basex.build.DiskBuilder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.DropDB;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.data.MetaData;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.up.atomic.AtomicUpdateCache;
import org.basex.util.Performance;
import org.basex.util.Strings;
import org.basex.util.Util;

public final class Add
extends ACreate {
    Builder builder;
    Data tmpData;

    public Add(String path) {
        this(path, (String)null);
    }

    public Add(String path, String input) {
        super(Perm.WRITE, true, path == null ? "" : path, input);
    }

    @Override
    protected boolean run() {
        if (!this.build()) {
            return false;
        }
        try {
            Data data = this.context.data();
            boolean bl = this.update(data, () -> {
                if (this.tmpData.meta.size > 1) {
                    this.context.invalidate();
                    AtomicUpdateCache auc = new AtomicUpdateCache(data);
                    auc.addInsert(data.meta.size, -1, new DataClip(this.tmpData));
                    auc.execute(false);
                }
                return this.info(Text.RES_ADDED_X, this.jc().performance);
            });
            return bl;
        }
        finally {
            this.finish();
        }
    }

    boolean build() {
        IO source;
        Object path = MetaData.normPath(this.args[0]);
        if (path == null) {
            return this.error(Text.PATH_INVALID_X, this.args[0]);
        }
        try {
            source = this.sourceToIO((String)path);
        }
        catch (IOException ex) {
            return this.error(Util.message(ex), new Object[0]);
        }
        if (source == null) {
            return this.error(Text.RES_NOT_FOUND, new Object[0]);
        }
        if (!source.exists()) {
            return this.in != null ? this.error(Text.RES_NOT_FOUND, new Object[0]) : this.error(Text.RES_NOT_FOUND_X, this.context.user().has(Perm.CREATE) ? source : this.args[1]);
        }
        if (!Strings.endsWith((String)path, '/') && (source.isDir() || source.isArchive())) {
            path = (String)path + "/";
        }
        String target = "";
        int s = ((String)path).lastIndexOf(47);
        if (s != -1) {
            target = ((String)path).substring(0, s);
            path = ((String)path).substring(s + 1);
        }
        if (((String)path).isEmpty()) {
            path = source.name();
        } else {
            source.name((String)path);
        }
        if (((String)path).isEmpty()) {
            return this.error(Text.NAME_INVALID_X, path);
        }
        try {
            Data data = this.context.data();
            String name = data.meta.name;
            Parser parser = new DirParser(source, this.options).target(target);
            if (this.cache(parser)) {
                String tmpName = this.soptions.createTempDb(name);
                this.builder = new DiskBuilder(tmpName, parser, this.soptions, this.options);
            } else {
                this.builder = new MemBuilder((String)path, parser);
            }
            if (!data.inMemory()) {
                this.builder.binariesDir(this.soptions.dbPath(name));
            }
            this.tmpData = this.builder.build();
            return true;
        }
        catch (IOException ex) {
            return this.error(Util.message(ex), new Object[0]);
        }
    }

    void finish() {
        if (this.tmpData != null) {
            DropDB.drop(this.tmpData, this.soptions);
            this.tmpData = null;
        }
    }

    private boolean cache(Parser parser) {
        Runtime rt;
        long max;
        IOFile src;
        if (this.options.get(MainOptions.MAINMEM).booleanValue()) {
            return false;
        }
        if (this.options.get(MainOptions.ADDCACHE).booleanValue()) {
            return true;
        }
        IO source = parser.source();
        long fl = source.length();
        if (source instanceof IOFile && (src = (IOFile)source).isDir()) {
            for (String path : src.descendants()) {
                fl += new IOFile(src, path).length();
            }
        }
        if (fl < ((max = (rt = Runtime.getRuntime()).maxMemory()) - rt.freeMemory()) / 2L) {
            return false;
        }
        Performance.gc(2);
        return fl > (max - rt.freeMemory()) / 2L;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init().arg("TO", 0).add(1);
    }
}

