/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public final class ColumnLayout
implements LayoutManager {
    private final int gap;

    public ColumnLayout() {
        this(0);
    }

    public ColumnLayout(int gap) {
        this.gap = gap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container cont) {
        Object object = cont.getTreeLock();
        synchronized (object) {
            int w = 0;
            int h = 0;
            for (Component comp : cont.getComponents()) {
                Dimension d = comp.getPreferredSize();
                w += this.gap + d.width;
                h = Math.max(h, d.height);
            }
            Insets in = cont.getInsets();
            return new Dimension(in.left + Math.max(w - this.gap, 0) + in.right, in.top + h + in.bottom);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container cont) {
        Object object = cont.getTreeLock();
        synchronized (object) {
            int x = 0;
            Insets in = cont.getInsets();
            for (Component comp : cont.getComponents()) {
                Dimension d = comp.getPreferredSize();
                comp.setBounds(in.left + x, in.top, d.width, d.height);
                x += this.gap + d.width;
            }
        }
    }
}

