/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CRecord;
import org.basex.query.func.Function;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.RecordField;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;
import org.basex.util.hash.TokenObjectMap;

public final class CMap
extends Arr {
    public CMap(InputInfo info, Expr[] expr) {
        super(info, SeqType.MAP_O, expr);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el; e += 2) {
            this.exprs[e] = this.exprs[e].simplifyFor(CompileContext.Simplify.DATA, cc);
        }
        if (el == 0) {
            return XQMap.empty();
        }
        if (el == 2) {
            return cc.function(Function._MAP_ENTRY, this.info, this.exprs);
        }
        boolean record = el < 32;
        for (int e = 0; e < el && record; e += 2) {
            if (this.exprs[e] instanceof AStr && this.exprs[e].seqType().eq(SeqType.STRING_O)) continue;
            record = false;
        }
        if (record) {
            TokenObjectMap<RecordField> fields = new TokenObjectMap<RecordField>(el / 2);
            ExprList args = new ExprList(el / 2);
            for (int e = 0; e < el; e += 2) {
                Expr key = this.exprs[e];
                Expr value = this.exprs[e + 1];
                fields.put(((AStr)key).string(this.info), new RecordField(false, value.seqType()));
                args.add(value);
            }
            return new CRecord(this.info, cc.qc.shared.record(false, fields), (Expr[])args.finish()).optimize(cc);
        }
        AtomType kt = AtomType.ANY_ATOMIC_TYPE;
        SeqType vt = SeqType.ITEM_ZM;
        for (int e = 0; e < el; e += 2) {
            SeqType kst = this.exprs[e].seqType();
            SeqType dst = this.exprs[e + 1].seqType();
            AtomType akt = kst.type.atomic();
            kt = akt == null || !kst.one() || kst.mayBeArray() ? AtomType.ANY_ATOMIC_TYPE : (e == 0 ? akt : (AtomType)kt.union(akt));
            vt = e == 0 ? dst : vt.union(dst);
        }
        this.exprType.assign(MapType.get(kt, vt));
        return this.values(true, cc) ? cc.preEval(this) : this;
    }

    @Override
    public XQMap item(QueryContext qc, InputInfo ii) throws QueryException {
        int el = this.exprs.length;
        MapBuilder mb = new MapBuilder(el >>> 1);
        for (int e = 0; e < el; e += 2) {
            Item key = this.toAtomItem(this.exprs[e], qc);
            Value value = this.exprs[e + 1].value(qc);
            if (mb.contains(key)) {
                throw QueryError.MAPDUPLKEY_X.get(this.info, key);
            }
            mb.put(key, value);
        }
        return mb.map(this);
    }

    @Override
    public long structSize() {
        return this.exprs.length >> 1;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new CMap(this.info, CMap.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CMap && super.equals(obj);
    }

    @Override
    public String description() {
        return "map constructor";
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("{ ");
        int el = this.exprs.length;
        for (int e = 0; e < el; e += 2) {
            if (e != 0) {
                qs.token(',');
            }
            qs.token(this.exprs[e]).token(':').token(this.exprs[e + 1]);
        }
        qs.token(" }");
    }
}

