/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.xquery;

import java.io.IOException;
import org.basex.core.CommonOptions;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.scope.AModule;
import org.basex.query.scope.MainModule;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.util.InputInfo;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public final class XQueryParse
extends StandardFunc {
    private static final QNm Q_LIBRARY_MODULE = new QNm("LibraryModule");
    private static final QNm Q_MAIN_MODULE = new QNm("MainModule");
    private static final QNm Q_UPDATING = new QNm("updating");
    private static final QNm Q_PREFIX = new QNm("prefix");
    private static final QNm Q_URI = new QNm("uri");

    @Override
    public FNode item(QueryContext qc, InputInfo ii) throws QueryException {
        IOContent query = this.toContent(this.arg(0), qc);
        XQueryOptions options = this.toOptions(this.arg(1), new XQueryOptions(), qc);
        QueryContext qctx = new QueryContext(qc.context);
        try {
            FBuilder root;
            AModule module = qctx.parse(query.readString(), this.toBaseUri(query.path(), options, XQueryOptions.BASE_URI));
            if (options.get(XQueryOptions.COMPILE).booleanValue()) {
                qctx.compile();
            }
            if (module instanceof MainModule) {
                root = FElem.build(Q_MAIN_MODULE).add(Q_UPDATING, qctx.updating);
            } else {
                QNm name = module.sc.module;
                root = FElem.build(Q_LIBRARY_MODULE).add(Q_PREFIX, name.string()).add(Q_URI, name.uri());
            }
            if (options.get(XQueryOptions.PLAN).booleanValue()) {
                root.add(qctx.toXml(false));
            }
            FNode fNode = root.finish();
            qctx.close();
            return fNode;
        }
        catch (Throwable throwable) {
            try {
                try {
                    qctx.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (QueryException ex) {
                if (!options.get(XQueryOptions.PASS).booleanValue()) {
                    ex.info(this.info);
                }
                throw ex;
            }
            catch (IOException ex) {
                throw QueryError.IOERR_X.get(this.info, ex);
            }
        }
    }

    public static class XQueryOptions
    extends Options {
        public static final BooleanOption PLAN = new BooleanOption("plan", true);
        public static final BooleanOption COMPILE = new BooleanOption("compile", false);
        public static final BooleanOption PASS = new BooleanOption("pass", false);
        public static final StringOption BASE_URI = CommonOptions.BASE_URI;
    }
}

