/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.QueryResource;
import org.basex.query.func.java.JavaCall;
import org.basex.query.util.pkg.JarDesc;
import org.basex.query.util.pkg.JarParser;
import org.basex.query.util.pkg.Pkg;
import org.basex.query.util.pkg.PkgComponent;
import org.basex.query.util.pkg.PkgDep;
import org.basex.query.util.pkg.PkgParser;
import org.basex.query.util.pkg.PkgText;
import org.basex.query.util.pkg.PkgValidator;
import org.basex.util.InputInfo;
import org.basex.util.Reflect;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.Version;

public final class ModuleLoader {
    private static final ClassLoader LOADER = Thread.currentThread().getContextClassLoader();
    private static final Method CLOSE = Reflect.method(QueryResource.class, "close", new Class[0]);
    private final Context context;
    private final ArrayList<URL> urls = new ArrayList(0);
    private final HashSet<Object> javaModules = new HashSet();
    private ClassLoader loader = LOADER;

    public ModuleLoader(Context context) {
        this.context = context;
    }

    public void close() {
        if (this.loader != LOADER) {
            try {
                ((URLClassLoader)this.loader).close();
            }
            catch (IOException ex) {
                Util.stack(ex);
            }
        }
        for (Object jm : this.javaModules) {
            for (Class<?> c : jm.getClass().getInterfaces()) {
                if (c != QueryResource.class) continue;
                Reflect.invoke(CLOSE, jm, new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean addImport(String uri, QueryParser qp, InputInfo info) throws QueryException {
        Class<?> clz;
        String className;
        String repoPath = this.context.soptions.get(StaticOptions.REPOPATH);
        boolean java = uri.startsWith("java:");
        if (java) {
            className = uri.substring("java:".length());
        } else {
            HashSet<String> pkgs = this.context.repo.nsDict().get(uri);
            if (pkgs != null) {
                void var9_10;
                Version ver = null;
                Object var9_9 = null;
                for (String pkg : pkgs) {
                    Version v = new Version(Pkg.version(pkg));
                    if (ver != null && v.compareTo(ver) <= 0) continue;
                    ver = v;
                    String string = pkg;
                }
                if (var9_10 != null) {
                    this.addRepo((String)var9_10, new HashSet<String>(), new HashSet<String>(), qp, info);
                    return true;
                }
            }
            String path = Strings.uri2path(uri);
            for (String suffix : IO.XQSUFFIXES) {
                IOFile file = new IOFile(repoPath, path + suffix);
                if (!file.exists()) continue;
                qp.module(file.path(), uri, info);
                return true;
            }
            className = Strings.uriToClasspath(path);
        }
        className = JavaCall.classPath(className);
        IOFile jar = new IOFile(repoPath, Strings.uri2path(className) + ".jar");
        if (jar.exists()) {
            this.addURL(jar);
        }
        try {
            clz = this.findClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Util.debug(classNotFoundException);
            if (java) {
                throw QueryError.WHICHMODCLASS_X.get(info, className);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable t = Util.rootException(throwable);
            throw QueryError.MODINIT_X_X_X.get(info, className, t.getMessage(), Util.className(t));
        }
        try {
            this.javaModules.add(clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            return true;
        }
        catch (Throwable throwable) {
            throw QueryError.MODINST_X_X.get(info, className, throwable);
        }
    }

    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (!this.urls.isEmpty()) {
            this.loader = new URLClassLoader((URL[])this.urls.toArray(URL[]::new), this.loader);
            this.urls.clear();
        }
        return this.loader == LOADER ? Reflect.forName(name) : Class.forName(name, true, this.loader);
    }

    public Object findModule(String clz) {
        for (Object mod : this.javaModules) {
            if (!mod.getClass().getName().equals(clz)) continue;
            return mod;
        }
        return null;
    }

    private void addRepo(String id, HashSet<String> toLoad, HashSet<String> loaded, QueryParser qp, InputInfo info) throws QueryException {
        if (loaded.contains(id)) {
            return;
        }
        Pkg pkg = this.context.repo.pkgDict().get(id);
        if (pkg == null) {
            throw QueryError.REPO_NOTFOUND_X.get(info, id);
        }
        IOFile pkgPath = this.context.repo.path(pkg.path());
        IOFile pkgDesc = new IOFile(pkgPath, "expath-pkg.xml");
        if (!((IO)pkgDesc).exists()) {
            Util.debugln("Missing package descriptor for package '%'", id);
        }
        pkg = new PkgParser(info).parse(pkgDesc);
        IOFile jarDesc = new IOFile(pkgPath, PkgText.JARDESC);
        IOFile modDir = new IOFile(pkgPath, "content");
        if (!modDir.exists()) {
            modDir = new IOFile(pkgPath, pkg.abbrev());
        }
        if (jarDesc.exists()) {
            JarDesc desc = new JarParser(info).parse(jarDesc);
            for (byte[] u : desc.jars) {
                this.addURL(new IOFile(modDir, Token.string(u)));
            }
        }
        if (!pkg.dep.isEmpty()) {
            toLoad.add(id);
        }
        for (PkgDep dep : pkg.dep) {
            if (dep.name == null) continue;
            String depId = new PkgValidator(this.context.repo, info).depPkg(dep);
            if (depId == null) {
                throw QueryError.REPO_NOTFOUND_X.get(info, dep.name);
            }
            if (toLoad.contains(depId)) {
                throw QueryError.CIRCMODULE.get(info, new Object[0]);
            }
            this.addRepo(depId, toLoad, loaded, qp, info);
        }
        for (PkgComponent comp : pkg.comps) {
            qp.module(new IOFile(modDir, comp.file).path(), comp.uri, info);
        }
        toLoad.remove(id);
        loaded.add(id);
    }

    private void addURL(IOFile jar) {
        try {
            this.urls.add(new URL(jar.url()));
            IOFile extDir = new IOFile(jar.parent(), "." + jar.dbName());
            if (extDir.exists()) {
                for (IOFile file : extDir.children()) {
                    this.urls.add(new URL(file.url()));
                }
            }
        }
        catch (MalformedURLException ex) {
            Util.errln(ex, new Object[0]);
        }
    }
}

