/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqitem.xstream;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.xquery.XQException;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.xqitem.xstream.StAXDriver;
import net.xqj.core.xqitem.xstream.XStream2;
import net.xqj.core.xqitem.xstream.converters.DateConverter;
import net.xqj.core.xqitem.xstream.converters.GregorianCalendarConverter;
import net.xqj.core.xqitem.xstream.converters.QNameConverter;
import net.xqj.core.xqitem.xstream.converters.SqlTimestampConverter;
import net.xqj.core.xqitem.xstream.converters.XMLGregorianCalendarConverter;

public class XStreamHelper {
    private static ThreadLocal<XStream2> tlXStream = new ThreadLocal();

    private static XStream2 getXStreamInstance() {
        XStream2 xstream = tlXStream.get();
        if (xstream == null) {
            xstream = XStreamHelper.createXStreamInstance();
        }
        return xstream;
    }

    private static final XStream2 createXStreamInstance() {
        XStream2 xstream = new XStream2((HierarchicalStreamDriver)new StAXDriver());
        xstream.registerConverter(new XMLGregorianCalendarConverter());
        xstream.registerConverter(new QNameConverter());
        xstream.registerConverter(new DateConverter());
        xstream.registerConverter(new GregorianCalendarConverter());
        xstream.registerConverter(new SqlTimestampConverter());
        return xstream;
    }

    public static void returnXStreamInstance(XStream2 xstream) {
        tlXStream.set(xstream);
    }

    public static String toXML(Object obj) throws XQException {
        XStream2 xstream = null;
        try {
            xstream = XStreamHelper.getXStreamInstance();
            xstream.processAnnotations(obj.getClass());
            String string = xstream.toXML(obj);
            return string;
        }
        catch (Exception e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJXS001", e);
        }
        finally {
            XStreamHelper.returnXStreamInstance(xstream);
        }
    }

    public static void toXML(Object obj, Writer out) throws XQException {
        XStream2 xstream = null;
        try {
            xstream = XStreamHelper.getXStreamInstance();
            xstream.toXML(obj, out);
        }
        catch (Exception e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJXS002", e);
        }
        finally {
            XStreamHelper.returnXStreamInstance(xstream);
        }
    }

    public static void toXML(Object obj, OutputStream out) throws XQException {
        XStream2 xstream = null;
        try {
            xstream = XStreamHelper.getXStreamInstance();
            xstream.toXML(obj, out);
        }
        catch (Exception e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJXS003", e);
        }
        finally {
            XStreamHelper.returnXStreamInstance(xstream);
        }
    }

    public static Object fromXML(String xmlDocument) throws XQException {
        XStream2 xstream = null;
        try {
            xstream = XStreamHelper.getXStreamInstance();
            Object object = xstream.fromXML(xmlDocument);
            return object;
        }
        catch (Exception e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJXS004", e);
        }
        finally {
            XStreamHelper.returnXStreamInstance(xstream);
        }
    }

    public static void processAnnotations(Class clazz) throws XQException {
        XStream2 xstream = null;
        try {
            xstream = XStreamHelper.getXStreamInstance();
            xstream.processAnnotations(clazz);
        }
        catch (Exception e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJXS005", e);
        }
        finally {
            XStreamHelper.returnXStreamInstance(xstream);
        }
    }
}

