/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXScrollBar;
import org.basex.gui.text.ReplaceContext;
import org.basex.gui.text.SearchBar;
import org.basex.gui.text.SearchContext;
import org.basex.gui.text.Syntax;
import org.basex.gui.text.TextEditor;
import org.basex.gui.text.TextFont;
import org.basex.gui.text.TextIterator;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;

final class TextRenderer
extends BaseXBack {
    private final GUI gui;
    private static final int OFFSET = 5;
    private final TextEditor text;
    private final BaseXScrollBar scroll;
    private final boolean edit;
    private final IntList parentheses = new IntList();
    private TextFont font;
    private int fontHeight;
    private int stringWidth;
    private String currString;
    private boolean showInvisible;
    private boolean showNL;
    private int margin;
    private boolean showLines;
    private boolean markline;
    private String antiAlias;
    private int offset;
    private int width;
    private int height;
    private int x;
    private int y;
    private int lineY;
    private int line;
    private boolean lineC;
    private final int[] cursor = new int[2];
    private Syntax syntax = Syntax.SIMPLE;
    private boolean caret;
    private boolean markNext;
    private boolean link;

    TextRenderer(TextEditor text, BaseXScrollBar scroll, boolean edit, GUI gui) {
        this.setOpaque(false);
        this.text = text;
        this.scroll = scroll;
        this.edit = edit;
        this.gui = gui;
        this.setFont(GUIConstants.dmfont);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.gui == null) {
            return;
        }
        GUIOptions gopts = this.gui.gopts;
        this.margin = gopts.get(GUIOptions.SHOWMARGIN) != false ? Math.max(gopts.get(GUIOptions.MARGIN), 1) : -1;
        this.showInvisible = gopts.get(GUIOptions.SHOWINVISIBLE);
        this.showNL = gopts.get(GUIOptions.SHOWNL);
        this.showLines = gopts.get(GUIOptions.SHOWLINES);
        this.markline = gopts.get(GUIOptions.MARKLINE);
        this.antiAlias = gopts.get(GUIOptions.ANTIALIAS);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        BaseXLayout.antiAlias(g, this.antiAlias);
        this.parentheses.reset();
        int oldL = 0;
        TextIterator iter = this.init(g, false);
        while (this.more(iter, g) && this.y < this.height) {
            if (this.line != oldL && this.y >= 0) {
                this.drawLineNumber(g);
                oldL = this.line;
            }
            this.write(iter, g);
        }
        if (this.x == this.offset) {
            this.markLine(g);
        }
        if (this.line != oldL) {
            this.drawLineNumber(g);
        }
        this.stringWidth = 0;
        int s = iter.pos();
        if (this.caret && s == iter.caret()) {
            this.drawCaret(g, this.x);
        }
        if (s == iter.errorPos()) {
            this.drawError(g);
        }
        this.drawLinesSep(g);
    }

    private void drawLineNumber(Graphics g) {
        if (this.edit && this.showLines) {
            g.setColor(GUIConstants.gray);
            String string = Integer.toString(this.line);
            this.drawString(string, this.offset - this.font.stringWidth(string) - 10, this.y, g);
        }
    }

    private void drawLinesSep(Graphics g) {
        if (this.edit) {
            int lx;
            if (this.showLines) {
                lx = this.offset - 7;
                g.setColor(GUIConstants.lgray);
                g.drawLine(lx, 0, lx, this.height);
            }
            if (this.margin != -1) {
                lx = this.offset + this.font.charWidth(32) * this.margin;
                g.setColor(GUIConstants.lgray);
                g.drawLine(lx, 0, lx, this.height);
            }
        }
    }

    void search(SearchContext sc, boolean jump) {
        this.text.search(sc, jump);
    }

    int[] replace(ReplaceContext rc) {
        return this.text.replace(rc);
    }

    int[] cursor() {
        return this.cursor;
    }

    int jump(SearchBar.SearchDir dir, boolean select) {
        int pos = this.text.jump(dir, select);
        if (pos == -1) {
            return -1;
        }
        Graphics g = this.getGraphics();
        TextIterator iter = this.init(g, true);
        while (this.more(iter, g) && iter.pos() < pos) {
            this.next(iter);
        }
        return this.y;
    }

    int[] caretPos() {
        Graphics g = this.getGraphics();
        int col = 1;
        boolean more = true;
        TextIterator iter = this.init(g, true);
        while (this.more(iter, g)) {
            int p = iter.pos();
            while (iter.more()) {
                boolean bl = more = iter.pos() < iter.caret();
                if (!more) break;
                iter.next();
                ++col;
            }
            if (!more) break;
            iter.pos(p);
            if (!this.next(iter)) continue;
            col = 1;
        }
        return new int[]{this.line, col};
    }

    private void setStyle(int style) {
        this.font.style(style);
        this.fontHeight = this.font.size() * 5 / 4;
    }

    @Override
    public Dimension getPreferredSize() {
        Graphics g = this.getGraphics();
        this.width = Integer.MAX_VALUE;
        this.height = Integer.MAX_VALUE;
        int maxX = 0;
        TextIterator iter = this.init(g, true);
        while (this.more(iter, g)) {
            if (iter.curr() == 10) {
                maxX = Math.max(this.x, maxX);
            }
            this.next(iter);
        }
        return new Dimension(Math.max(this.x, maxX) + this.font.charWidth(32), this.y + this.fontHeight);
    }

    private TextIterator init(Graphics g, boolean start) {
        int indent = this.gui != null ? Math.max(1, this.gui.gopts.get(GUIOptions.INDENT)) : GUIOptions.INDENT.value();
        this.font = new TextFont(this.getFont(), indent, this);
        this.setStyle(0);
        this.syntax.init(GUIConstants.TEXT);
        this.offset = 5;
        if (g != null && this.edit && this.showLines) {
            this.offset += this.font.stringWidth(Integer.toString(this.text.lines())) + 10;
        }
        this.x = this.offset;
        this.y = this.fontHeight - (start ? 0 : this.scroll.pos()) - 2;
        this.lineY = this.y - (this.fontHeight << 2) / 5;
        this.line = 1;
        this.link = false;
        TextIterator iter = new TextIterator(this.text);
        this.lineC = this.edit && iter.caretLine(true);
        return iter;
    }

    void computeHeight() {
        this.width = this.getWidth() - (this.offset >> 1);
        Graphics g = this.getGraphics();
        TextIterator iter = this.init(g, true);
        while (this.more(iter, g)) {
            this.next(iter);
        }
        this.height = this.getHeight() + this.fontHeight;
        this.scroll.height(this.y + 5);
    }

    int cursorY() {
        Graphics g = this.getGraphics();
        TextIterator iter = this.init(g, true);
        while (this.more(iter, g) && !iter.edited()) {
            this.next(iter);
        }
        return this.y - this.fontHeight;
    }

    private boolean more(TextIterator iter, Graphics g) {
        int w = this.width;
        int maxWidth = w - this.offset;
        if (g == null || maxWidth <= 0 || !iter.moreStrings(w >> 2)) {
            return false;
        }
        String s = iter.currString();
        int sw = 0;
        if (s.isEmpty()) {
            return false;
        }
        int cp = s.codePointAt(0);
        if (cp == 63742) {
            this.setStyle(1);
        } else if (cp == 63741) {
            this.setStyle(0);
        } else if (cp == 63739) {
            this.link ^= true;
        } else {
            sw = this.font.stringWidth(s);
            if (sw > maxWidth) {
                if (this.x != this.offset) {
                    this.newline(true);
                }
                TokenBuilder tb = new TokenBuilder();
                sw = 0;
                for (int scp : s.codePoints().toArray()) {
                    if (sw >= maxWidth) break;
                    tb.add(scp);
                    if ((sw += this.font.charWidth(scp)) <= maxWidth) continue;
                    sw = this.font.stringWidth(tb.toString());
                }
                if ((s = tb.removeLast().toString()).isEmpty()) {
                    return false;
                }
                sw = this.font.stringWidth(s);
                iter.posEnd(iter.pos() + tb.size());
            }
        }
        if (sw < maxWidth && sw > w - this.x) {
            this.newline(true);
        }
        this.currString = s;
        this.stringWidth = sw;
        return true;
    }

    private void newline(boolean full) {
        int h = this.fontHeight >> (full ? 0 : 1);
        this.x = this.offset;
        this.y += h;
        this.lineY += h;
    }

    private void markLine(Graphics g) {
        if (this.lineC && this.markline) {
            g.setColor(GUIConstants.color3A);
            g.fillRect(0, this.lineY, this.width + this.offset, this.fontHeight);
        }
    }

    private void markErrorLine(Graphics g) {
        g.setColor(GUIConstants.colormark2A);
        g.fillRect(0, this.lineY, this.offset - 7, this.fontHeight);
    }

    private boolean next(TextIterator iter) {
        int ch = iter.curr();
        if (ch == 10 || ch == 63743) {
            this.newline(ch == 10);
            ++this.line;
            this.lineC = this.edit && iter.caretLine(false);
            return true;
        }
        this.x += this.stringWidth;
        return false;
    }

    private void write(TextIterator iter, Graphics g) {
        int yy;
        if (this.x == this.offset) {
            this.markLine(g);
        }
        Color color = this.isEnabled() ? (this.markNext ? GUIConstants.GREEN : (this.link ? GUIConstants.color4 : this.syntax.getColor(iter))) : GUIConstants.gray;
        int cp = iter.curr();
        this.markNext = cp == 63740;
        int pos = iter.pos();
        int cpos = iter.caret();
        if (cp == 40 || cp == 91 || cp == 123) {
            this.parentheses.add(this.x).add(this.y).add(pos).add(cp);
        } else if (!(cp != 41 && cp != 93 && cp != 125 || this.parentheses.isEmpty())) {
            int open;
            int n = cp == 41 ? 40 : (open = cp == 93 ? 91 : 123);
            if (this.parentheses.peek() == open) {
                this.parentheses.pop();
                int cr = this.parentheses.pop();
                yy = this.parentheses.pop();
                int xx = this.parentheses.pop();
                if (cpos == pos || cpos == cr) {
                    g.setColor(GUIConstants.color4);
                    g.drawRect(xx, yy - (this.fontHeight << 2) / 5, this.font.charWidth(open), this.fontHeight);
                    g.drawRect(this.x, this.lineY, this.font.charWidth(cp), this.fontHeight);
                }
            }
        }
        if (this.y > 0) {
            this.mark(iter.selection(), iter, g);
            for (int[] sr : iter.searchResults()) {
                this.mark(sr, iter, g);
            }
            if (iter.error()) {
                this.drawError(g);
            }
            if (this.showNL && cp == 10) {
                g.setColor(GUIConstants.gray);
                this.drawString("\u00b6", this.x, this.y, g);
            } else if (this.showInvisible && cp == 9) {
                int lh = 1 + this.fontHeight / 12;
                int xe = this.x + this.font.charWidth(9) - lh;
                yy = this.y - this.fontHeight * 3 / 10;
                int as = (lh << 1) - 1;
                g.setColor(GUIConstants.gray);
                g.drawLine(this.x + lh, yy, xe, yy);
                g.drawLine(xe - as, yy - as, xe, yy);
                g.drawLine(xe - as, yy + as, xe, yy);
            } else if (cp > 32 && cp < 57344 || cp > 63743) {
                if (this.showInvisible && Character.isSpaceChar(cp)) {
                    int s = this.fontHeight / 12 + 1;
                    g.setColor(GUIConstants.gray);
                    g.fillRect(this.x + (this.stringWidth >> 1), this.y - this.fontHeight * 3 / 10, s, s);
                } else {
                    g.setColor(color);
                    this.drawString(this.currString, this.x, this.y, g);
                }
            }
            if (this.link) {
                g.drawLine(this.x, this.y + 1, this.x + this.stringWidth, this.y + 1);
            }
            if (this.caret && iter.edited()) {
                this.drawCaret(g, this.x + this.font.stringWidth(iter.substring(pos, cpos)));
            }
        }
        this.next(iter);
    }

    private void mark(int[] range, TextIterator iter, Graphics g) {
        if (range != null) {
            int pos = iter.pos();
            int posEnd = iter.posEnd();
            int ss = Math.max(pos, range[0]);
            int se = Math.min(posEnd, range[1]);
            int xs = this.font.stringWidth(iter.substring(pos, ss));
            int cw = this.font.stringWidth(iter.substring(ss, se));
            g.setColor(GUIConstants.color2A);
            g.fillRect(this.x + xs, this.lineY, cw, this.fontHeight);
        }
    }

    private void drawCaret(Graphics g, int xx) {
        g.setColor(GUIConstants.dgray);
        g.fillRect(xx, this.lineY, 2, this.fontHeight);
        this.cursor[0] = xx;
        this.cursor[1] = this.lineY + this.fontHeight;
    }

    private void drawError(Graphics g) {
        int ww = this.stringWidth == 0 ? this.font.charWidth(32) : this.stringWidth;
        int s = Math.max(2, this.fontHeight / 6);
        g.setColor(GUIConstants.RED);
        for (int xp = this.x; xp < this.x + ww; xp += 2) {
            g.drawLine(xp - 1, this.y + 2, xp, this.y + s + 1);
        }
        if (this.edit) {
            this.markErrorLine(g);
        }
    }

    private void drawString(String string, int xx, int yy, Graphics g) {
        g.setFont(this.font.font(string));
        g.drawString(string, xx, yy);
    }

    TextIterator jump(Point pos) {
        Graphics g = this.getGraphics();
        TextIterator iter = this.init(g, false);
        int xPos = pos.x;
        int yPos = pos.y - this.fontHeight / 5;
        block0: while (yPos >= this.y - this.fontHeight && this.more(iter, g)) {
            if (yPos < this.y) {
                if (xPos < this.x) break;
                if (xPos < this.x + this.stringWidth) {
                    int p = iter.pos();
                    int sw = xPos - this.x;
                    int oldFsw = 0;
                    while (iter.more()) {
                        int caretP = iter.pos();
                        iter.next();
                        int fsw = this.font.stringWidth(iter.substring(p, iter.pos()));
                        if (sw < fsw) {
                            if (sw >= oldFsw + (fsw - oldFsw) / 2) break block0;
                            iter.pos(caretP);
                            break block0;
                        }
                        oldFsw = fsw;
                    }
                    break;
                }
            }
            this.next(iter);
        }
        iter.link(this.link);
        return iter;
    }

    int fontHeight() {
        return this.fontHeight;
    }

    void caret(boolean c) {
        this.caret = c;
        this.repaint();
    }

    boolean caret() {
        return this.caret;
    }

    void setSyntax(Syntax s) {
        this.syntax = s;
    }

    Syntax getSyntax() {
        return this.syntax;
    }
}

