/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.out;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.IOFile;
import org.basex.io.out.BufferOutput;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class DataOutput
extends OutputStream {
    private final OutputStream out;
    private long size;

    public DataOutput(OutputStream out) {
        this.out = out;
    }

    public DataOutput(IOFile input) throws IOException {
        this(input, 4096);
    }

    public DataOutput(IOFile input, int bufsize) throws IOException {
        this.out = new BufferOutput(input.outputStream(), bufsize);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.size;
    }

    public void writeBool(boolean b) throws IOException {
        this.write(b ? 1 : 0);
    }

    public int writeToken(byte[] tok) throws IOException {
        int s = this.writeNum(tok.length);
        this.writeBytes(tok);
        return s + tok.length;
    }

    public int writeDouble(double num) throws IOException {
        return this.writeToken(Token.token(num));
    }

    public void writeTokens(byte[][] array) throws IOException {
        this.writeNum(array.length);
        for (byte[] a : array) {
            this.writeToken(a != null ? a : Token.EMPTY);
        }
    }

    public void writeDiffs(IntList array) throws IOException {
        int al = array.size();
        this.writeNum(al);
        int c = 0;
        for (int a = 0; a < al; ++a) {
            int t = array.get(a);
            this.writeNum(t - c);
            c = t;
        }
    }

    public void writeNums(int[] array) throws IOException {
        this.writeNum(array.length);
        for (int a : array) {
            this.writeNum(a);
        }
    }

    public int writeNum(int v) throws IOException {
        if (v < 0 || v > 0x3FFFFFFF) {
            this.write(192);
            this.write(v >>> 24);
            this.write(v >>> 16);
            this.write(v >>> 8);
            this.write(v);
            return 5;
        }
        if (v > 16383) {
            this.write(v >>> 24 | 0x80);
            this.write(v >>> 16);
            this.write(v >>> 8);
            this.write(v);
            return 4;
        }
        if (v > 63) {
            this.write(v >>> 8 | 0x40);
            this.write(v);
            return 2;
        }
        this.write(v);
        return 1;
    }

    public void writeLong(long v) throws IOException {
        if (v < Integer.MIN_VALUE || v >= Integer.MAX_VALUE || v == 16383L) {
            this.writeNum(16383);
            this.write8(v);
        } else {
            this.writeNum((int)v);
        }
    }

    public void writeLongs(long[] array) throws IOException {
        this.writeNum(array.length);
        for (long a : array) {
            this.write8(a);
        }
    }

    public void write1(int v) throws IOException {
        this.write(v);
    }

    public void write2(int v) throws IOException {
        this.write(v >>> 8);
        this.write(v);
    }

    public void write4(int v) throws IOException {
        this.write(v >>> 24);
        this.write(v >>> 16);
        this.write(v >>> 8);
        this.write(v);
    }

    public void write5(long v) throws IOException {
        this.write((byte)(v >>> 32));
        this.write((byte)(v >>> 24));
        this.write((byte)(v >>> 16));
        this.write((byte)(v >>> 8));
        this.write((byte)v);
    }

    private void write8(long v) throws IOException {
        this.write((byte)(v >>> 56));
        this.write((byte)(v >>> 48));
        this.write((byte)(v >>> 40));
        this.write((byte)(v >>> 32));
        this.write((byte)(v >>> 24));
        this.write((byte)(v >>> 16));
        this.write((byte)(v >>> 8));
        this.write((byte)v);
    }

    public void writeBytes(byte[] bytes) throws IOException {
        for (byte b : bytes) {
            this.write(b);
        }
    }

    public long size() {
        return this.size;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

