/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.index.name.Names;
import org.basex.index.path.PathNode;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpPos;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Pos;
import org.basex.query.expr.Preds;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.CachedStep;
import org.basex.query.expr.path.IterLastStep;
import org.basex.query.expr.path.IterPosStep;
import org.basex.query.expr.path.IterStep;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.NodeTest;
import org.basex.query.expr.path.Test;
import org.basex.query.expr.path.UnionTest;
import org.basex.query.func.Function;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjectMap;

public abstract class Step
extends Preds {
    public Test test;
    public Axis axis;

    public static Expr self(CompileContext cc, Expr root, InputInfo info, Expr ... preds) throws QueryException {
        return Step.self(cc, root, info, NodeTest.NODE, preds);
    }

    public static Expr self(CompileContext cc, Expr root, InputInfo info, Test test, Expr ... preds) throws QueryException {
        return Step.get(cc, root, info, Axis.SELF, test, preds);
    }

    public static Expr get(CompileContext cc, Expr root, InputInfo info, Axis axis, Test test, Expr ... preds) throws QueryException {
        return new CachedStep(info, axis, test, preds).optimize(root, cc);
    }

    public static Step get(InputInfo info, Axis axis, Test test, Expr ... preds) {
        Expr[] exprArray;
        if (preds.length == 1 && (exprArray = preds[0]) instanceof Pos) {
            Pos pos = (Pos)exprArray;
            if (Function.LAST.is(pos.expr)) {
                return new IterLastStep(info, axis, test, preds);
            }
        }
        boolean pos = false;
        for (Expr pred : preds) {
            if (pred instanceof CmpPos) {
                pos = true;
                continue;
            }
            if (!Step.mayBePositional(pred)) continue;
            return new CachedStep(info, axis, test, preds);
        }
        return pos ? new IterPosStep(info, axis, test, preds) : new IterStep(info, axis, test, preds);
    }

    Step(InputInfo info, Axis axis, Test test, Expr ... preds) {
        super(info, Step.seqType(axis, test, preds), preds);
        this.axis = axis;
        this.test = test;
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        return this.optimize(null, cc);
    }

    final Expr optimize(Expr root, CompileContext cc) throws QueryException {
        Test t;
        Expr rt = this.type(root != null ? root : cc.qc.focus.value, true);
        Axis old = this.axis;
        Type type = this.seqType().type;
        if (this.axis == Axis.DESCENDANT_OR_SELF && type.instanceOf(NodeType.DOCUMENT_NODE) || this.axis == Axis.ANCESTOR_OR_SELF && type.oneOf(NodeType.LEAF_TYPES)) {
            this.axis = Axis.SELF;
        } else if (rt != null && rt.seqType().type.intersect(type) == null) {
            if (this.axis == Axis.DESCENDANT_OR_SELF) {
                this.axis = Axis.DESCENDANT;
            } else if (this.axis == Axis.ANCESTOR_OR_SELF) {
                this.axis = Axis.ANCESTOR;
            }
        }
        if (this.axis != old) {
            cc.info("rewrite %: %", new Object[]{old, this});
        }
        if ((t = this.test.optimize(this.data())) == null || this.noMatches()) {
            cc.info("remove step without results: %", this);
            return cc.emptySeq(this);
        }
        this.test = t;
        if (this.optimize(cc, this)) {
            return cc.emptySeq(this);
        }
        SeqType st = this.seqType();
        if (st.type.instanceOf(this.test.type) && !st.type.eq(this.test.type)) {
            this.test = st.test();
            if (this.test == null) {
                this.test = NodeTest.get((NodeType)st.type);
            }
        }
        return this.copyType(Step.get(this.info, this.axis, this.test, this.exprs));
    }

    @Override
    protected final Expr type(Expr expr, boolean optimize) {
        this.exprType.data(expr);
        if (!optimize && this.exprs.length != 0) {
            this.exprType.assign(this.test.type.seqType(Occ.ZERO_OR_MORE));
        } else if (expr != null && this.axis == Axis.SELF) {
            SeqType seqType = expr.seqType();
            if (this.test == NodeTest.NODE) {
                this.exprType.assign(seqType.type);
            }
            if (this.exprs.length == 0 && this.test.matches(seqType) == Boolean.TRUE) {
                this.exprType.assign(Occ.EXACTLY_ONE);
            }
        }
        return expr;
    }

    /*
     * Unable to fully structure code
     */
    public static SeqType seqType(Axis axis, Test test, Expr ... preds) {
        block3: {
            block4: {
                block2: {
                    v0 = type = axis == Axis.ATTRIBUTE ? NodeType.ATTRIBUTE : test.type;
                    if (axis != Axis.SELF || test != NodeTest.NODE || preds.length != 0) break block2;
                    v1 = Occ.EXACTLY_ONE;
                    break block3;
                }
                if (axis == Axis.SELF || axis == Axis.PARENT) ** GOTO lbl-1000
                if (axis != Axis.ATTRIBUTE || !(test instanceof NameTest)) break block4;
                nt = (NameTest)test;
                if (nt.scope == NameTest.Scope.FULL) ** GOTO lbl-1000
            }
            if (preds.length == 1 && (var7_5 = preds[0]) instanceof CmpPos && (cp = (CmpPos)var7_5).exact()) lbl-1000:
            // 3 sources

            {
                v1 = Occ.ZERO_OR_ONE;
            } else {
                v1 = Occ.ZERO_OR_MORE;
            }
        }
        occ = v1;
        t = test instanceof NodeTest != false ? null : test;
        return SeqType.get(type, occ, t);
    }

    @Override
    public final Expr inline(InlineContext ic) throws QueryException {
        return ic.var != null && ic.cc.ok(this, true, () -> ic.inline(this.exprs)) ? this.optimize(ic.cc) : null;
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        return this.iter(qc).value(qc, this);
    }

    @Override
    public abstract Step copy(CompileContext var1, IntObjectMap<Var> var2);

    final ArrayList<PathNode> nodes(ArrayList<PathNode> nodes, boolean stats) {
        Data data = this.data();
        if (stats && this.exprs.length != 0 || data == null || data.defaultNs() == null) {
            return null;
        }
        if (this.axis != Axis.ATTRIBUTE && this.axis != Axis.CHILD && this.axis != Axis.SELF && this.axis != Axis.DESCENDANT && this.axis != Axis.DESCENDANT_OR_SELF) {
            return null;
        }
        NodeType type = this.test.type;
        if (type == NodeType.PROCESSING_INSTRUCTION) {
            return null;
        }
        Names names = type == NodeType.ATTRIBUTE ? data.attrNames : data.elemNames;
        int kind = ANode.kind(this.test.type);
        ArrayList<PathNode> tmp = new ArrayList<PathNode>();
        Predicate<Test> addNodes = t -> {
            int name = 0;
            if (t instanceof NameTest) {
                NameTest nt = (NameTest)t;
                if (nt.local == null) {
                    return false;
                }
                name = names.index(nt.local);
            }
            for (PathNode pn : nodes) {
                if (!(this.axis != Axis.SELF && this.axis != Axis.DESCENDANT_OR_SELF || kind != -1 && (kind != pn.kind || name != 0 && name != pn.name) || tmp.contains(pn))) {
                    tmp.add(pn);
                }
                if (this.axis == Axis.SELF) continue;
                this.add(pn, tmp, name, kind);
            }
            return true;
        };
        Test[] testArray = this.test;
        if (testArray instanceof UnionTest) {
            UnionTest ut = (UnionTest)testArray;
            for (Test t2 : ut.tests) {
                if (addNodes.test(t2)) continue;
                return null;
            }
        } else if (!addNodes.test(this.test)) {
            return null;
        }
        return tmp;
    }

    private void add(PathNode node, ArrayList<PathNode> nodes, int name, int kind) {
        for (PathNode pn : node.children) {
            if (this.axis == Axis.DESCENDANT || this.axis == Axis.DESCENDANT_OR_SELF) {
                this.add(pn, nodes, name, kind);
            }
            if ((kind != -1 || !(pn.kind != 3 ^ this.axis == Axis.ATTRIBUTE)) && (kind != pn.kind || name != 0 && name != pn.name) || nodes.contains(pn)) continue;
            nodes.add(pn);
        }
    }

    private boolean noMatches() {
        NodeType type = this.test.type;
        if (type.oneOf(NodeType.NODE, NodeType.SCHEMA_ATTRIBUTE, NodeType.SCHEMA_ELEMENT)) {
            return false;
        }
        return switch (this.axis) {
            case Axis.ATTRIBUTE -> {
                if (type != NodeType.ATTRIBUTE) {
                    yield true;
                }
                yield false;
            }
            case Axis.ANCESTOR, Axis.PARENT -> type.oneOf(NodeType.LEAF_TYPES);
            case Axis.CHILD, Axis.DESCENDANT, Axis.FOLLOWING, Axis.FOLLOWING_OR_SELF, Axis.FOLLOWING_SIBLING, Axis.FOLLOWING_SIBLING_OR_SELF, Axis.PRECEDING, Axis.PRECEDING_OR_SELF, Axis.PRECEDING_SIBLING, Axis.PRECEDING_SIBLING_OR_SELF -> type.oneOf(NodeType.ATTRIBUTE, NodeType.DOCUMENT_NODE_ELEMENT, NodeType.DOCUMENT_NODE, NodeType.NAMESPACE_NODE);
            default -> false;
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    final boolean empty(SeqType seqType) {
        NodeType type;
        Type inputType;
        block14: {
            inputType = seqType.type;
            type = this.test.type;
            if (!inputType.instanceOf(NodeType.DOCUMENT_NODE)) break block14;
            switch (this.axis) {
                case FOLLOWING_OR_SELF: 
                case FOLLOWING_SIBLING_OR_SELF: 
                case PRECEDING_OR_SELF: 
                case PRECEDING_SIBLING_OR_SELF: 
                case SELF: 
                case ANCESTOR_OR_SELF: {
                    if (!type.oneOf(NodeType.NODE, NodeType.DOCUMENT_NODE)) {
                        break;
                    }
                    break block14;
                }
                case CHILD: 
                case DESCENDANT: {
                    if (type.oneOf(NodeType.DOCUMENT_NODE, NodeType.ATTRIBUTE)) {
                        break;
                    }
                    break block14;
                }
                case DESCENDANT_OR_SELF: {
                    if (type != NodeType.ATTRIBUTE) break block14;
                }
            }
            return true;
        }
        switch (this.axis) {
            case SELF: {
                if (this.test.matches(seqType) != Boolean.FALSE) return false;
                return true;
            }
            case ATTRIBUTE: 
            case CHILD: 
            case DESCENDANT: {
                boolean bl = inputType.oneOf(NodeType.LEAF_TYPES);
                return bl;
            }
            case DESCENDANT_OR_SELF: {
                if (!inputType.oneOf(NodeType.LEAF_TYPES)) return false;
                if (type == NodeType.NODE) return false;
                if (type.instanceOf(inputType)) return false;
                return true;
            }
            case FOLLOWING_SIBLING: 
            case PRECEDING_SIBLING: {
                if (inputType != NodeType.ATTRIBUTE) return false;
                return true;
            }
            case PARENT: {
                if (inputType != NodeType.ATTRIBUTE) return false;
                if (type != NodeType.DOCUMENT_NODE) return false;
                return true;
            }
        }
        return false;
    }

    final boolean remove(SeqType seqType) {
        Type prevType = seqType.type;
        return this.exprs.length == 0 && (this.axis == Axis.SELF || this.axis == Axis.DESCENDANT_OR_SELF && prevType.oneOf(NodeType.LEAF_TYPES) || this.axis == Axis.ANCESTOR_OR_SELF && prevType.instanceOf(NodeType.DOCUMENT_NODE)) && this.test.matches(seqType) == Boolean.TRUE;
    }

    final Step addPredicates(Expr ... preds) {
        this.exprType.assign(this.seqType().union(Occ.ZERO));
        return this.copyType(Step.get(this.info, this.axis, this.test, ExprList.concat(this.exprs, preds)));
    }

    final Step removePredicate() {
        return this.copyType(Step.get(this.info, this.axis, this.test, Arrays.copyOfRange(this.exprs, 0, this.exprs.length - 1)));
    }

    final ANode checkNode(QueryContext qc) throws QueryException {
        Value value = qc.focus.value;
        if (value instanceof ANode) {
            ANode node = (ANode)value;
            return node;
        }
        throw value == null ? QueryError.NOCTX_X.get(this.info, this) : QueryError.PATHNODE_X_X_X.get(this.info, this, value.type, value);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        for (Expr pred : this.exprs) {
            visitor.enterFocus();
            if (!pred.accept(visitor)) {
                return false;
            }
            visitor.exitFocus();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Step)) return false;
        Step st = (Step)obj;
        if (this.axis != st.axis) return false;
        if (!this.test.equals(st.test)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public final void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "axis", this.axis.name, "test", this.test.toString(false)), this.exprs);
    }

    @Override
    public void toString(QueryString qs) {
        TokenBuilder tb = new TokenBuilder();
        if (this.test == NodeTest.NODE) {
            if (this.axis == Axis.PARENT) {
                tb.add("..");
            }
            if (this.axis == Axis.SELF) {
                tb.add(46);
            }
        }
        if (tb.isEmpty()) {
            java.util.function.Function<Test, TokenBuilder> add = type -> {
                if (this.axis == Axis.ATTRIBUTE && type instanceof NameTest) {
                    return tb.add(64).add(type.toString(false));
                }
                if (this.axis != Axis.CHILD) {
                    tb.add((Object)this.axis).add("::");
                }
                return tb.add(type.toString(this.test.type == NodeType.ATTRIBUTE));
            };
            Test[] testArray = this.test;
            if (testArray instanceof UnionTest) {
                UnionTest ut = (UnionTest)testArray;
                tb.add(40);
                for (Test t : ut.tests) {
                    add.apply(t).add(" | ");
                }
                tb.delete(tb.size() - 3, tb.size()).add(41);
            } else {
                add.apply(this.test);
            }
        }
        qs.token(tb.finish());
        super.toString(qs);
    }
}

