/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Cast;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.func.Closure;
import org.basex.query.func.DynFuncCall;
import org.basex.query.func.FuncDefinition;
import org.basex.query.func.FuncLit;
import org.basex.query.func.Function;
import org.basex.query.func.PartFunc;
import org.basex.query.func.Records;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.func.XQFunctionExpr;
import org.basex.query.func.java.JavaCall;
import org.basex.query.util.Flag;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.list.AnnList;
import org.basex.query.util.list.ExprList;
import org.basex.query.util.parse.FuncBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.IntList;
import org.basex.util.similarity.Levenshtein;

public final class Functions {
    public static final QNmMap<FuncDefinition> BUILT_IN = new QNmMap();
    private static final TokenSet URIS = new TokenSet();
    private static final QNm[] CAST_PARAM = new QNm[]{new QNm("value")};

    private Functions() {
    }

    public static boolean staticURI(byte[] uri) {
        for (byte[] u : URIS) {
            if (!Token.eq(uri, u)) continue;
            return true;
        }
        return false;
    }

    public static Expr get(QNm qnm, FuncBuilder fb, QueryContext qc, boolean hasImport) throws QueryException {
        if (fb.placeholders > 0) {
            return Functions.dynamic(Functions.item(qnm, fb.arity, false, fb.info, qc, hasImport), fb);
        }
        QNm name = Functions.funcName(qnm, fb.arity, fb.info, qc);
        if (Token.eq(name.uri(), QueryText.XS_URI)) {
            return Functions.constructorCall(name, fb);
        }
        FuncDefinition fd = Functions.builtIn(name);
        if (fd != null) {
            int min = fd.minMax[0];
            int max = fd.minMax[1];
            Expr[] prepared = Functions.prepareArgs(fb, fd.params, min, max, fd);
            StandardFunc sf = fd.get(fb.info, prepared);
            if (sf.hasUPD()) {
                qc.updating();
            }
            return sf;
        }
        return Functions.staticCall(name, fb, qc, hasImport);
    }

    public static Expr dynamic(Expr expr, FuncBuilder fb) throws QueryException {
        Expr[] args;
        int ph = fb.placeholders;
        int[] phPerm = null;
        if (fb.keywords == null) {
            args = fb.args();
        } else {
            XQFunctionExpr fe = (XQFunctionExpr)((Object)expr);
            int arity = fe.arity();
            QNm[] names = new QNm[arity];
            for (int a = 0; a < arity; ++a) {
                names[a] = fe.paramName(a);
            }
            args = Functions.prepareArgs(fb, names, expr);
            if (ph > 0) {
                phPerm = Functions.preparePlaceholders(fb, names, args);
            }
        }
        return ph == 0 ? new DynFuncCall(fb.info, expr, args) : (ph == args.length && phPerm == null ? expr : new PartFunc(fb.info, ExprList.concat(args, expr), ph, phPerm));
    }

    public static Expr item(QNm qnm, int arity, boolean runtime, InputInfo info, QueryContext qc, boolean hasImport) throws QueryException {
        FuncBuilder fb = new FuncBuilder(info, arity, runtime);
        QNm name = Functions.funcName(qnm, arity, info, qc);
        if (Token.eq(name.uri(), QueryText.XS_URI)) {
            if (arity > 0) {
                fb.add(CAST_PARAM[0], Types.ANY_ATOMIC_TYPE_ZO, qc);
            }
            Cast expr = Functions.constructorCall(name, fb);
            FuncType ft = FuncType.get(fb.anns, expr.castType(), fb.params);
            return Functions.item(expr, fb, ft, name, false, arity == 0);
        }
        FuncDefinition fd = Functions.builtIn(name);
        if (fd != null) {
            IntList arts = Functions.checkArity(arity, fd.minMax[0], fd.minMax[1]);
            if (arts != null) {
                throw Functions.wrongArity(arity, arts, true, info, fd);
            }
            FuncType ft = fd.type(arity, fb.anns);
            QNm[] names = fd.paramNames(arity);
            for (int a = 0; a < arity; ++a) {
                fb.add(names[a], ft.argTypes[a], qc);
            }
            StandardFunc sf = fd.get(info, fb.args());
            boolean updating = sf.hasUPD();
            if (updating) {
                fb.anns = fb.anns.attach(new Ann(info, Annotation.UPDATING, (Value)Empty.VALUE));
                qc.updating();
            }
            return Functions.item(sf, fb, ft, name, updating, sf.has(Flag.CTX));
        }
        StaticFunc sf = qc.functions.get(name, arity);
        if (sf != null) {
            Expr func = Functions.item(sf, fb, qc, hasImport);
            if (sf.updating) {
                qc.updating();
            }
            return func;
        }
        for (int a = 0; a < arity; ++a) {
            fb.add(new QNm("arg" + (a + 1), ""), null, qc);
        }
        JavaCall java = JavaCall.get(name, fb.args(), qc, info);
        if (java != null) {
            Object[] sts = new SeqType[arity];
            Arrays.fill(sts, Types.ITEM_ZM);
            SeqType st = FuncType.get(fb.anns, null, (SeqType[])sts).seqType();
            return new FuncLit(info, java, fb.params, fb.anns, st, name, fb.vs);
        }
        if (runtime) {
            return null;
        }
        StaticFuncCall call = Functions.staticCall(name, fb, qc, hasImport);
        Closure closure = (Closure)Functions.item(call, fb, null, name, false, false);
        qc.functions.register(closure);
        return closure;
    }

    private static QNm funcName(QNm name, int arity, InputInfo info, QueryContext qc) {
        if (name.hasURI() || qc.functions.get(name, arity) != null) {
            return name;
        }
        StaticContext sc = info != null ? info.sc() : null;
        return new QNm(name.local(), sc != null && sc.funcNS != null ? sc.funcNS : QueryText.FN_URI);
    }

    public static QueryException wrongArity(int nargs, IntList arities, boolean literal, InputInfo info, Object function) {
        String arity = QueryError.arity((String)(literal ? "Arity " + nargs : QueryError.arguments(nargs)), arities);
        return QueryError.INVNARGS_X_X.get(info, function, arity);
    }

    public static FuncDefinition builtIn(QNm name) {
        return BUILT_IN.get(name);
    }

    static String similar(QNm qname) {
        byte[] local = Token.lc(qname.local());
        byte[] uri = qname.uri();
        Object similar = Levenshtein.similar(qname.local(), BUILT_IN.keys(), o -> Token.eq(uri, ((QNm)o).uri()) ? ((QNm)o).local() : null);
        for (QNm qnm : BUILT_IN) {
            if (similar != null || !Token.eq(Token.lc(qnm.local()), local)) continue;
            similar = qnm;
        }
        for (QNm qnm : BUILT_IN) {
            if (similar != null || !Token.eq(uri, qnm.uri()) || !Token.startsWith(Token.lc(qnm.local()), local)) continue;
            similar = qnm;
        }
        return QueryError.similar(qname.prefixString(), similar != null ? ((QNm)similar).prefixString() : null);
    }

    static Expr[] prepareArgs(FuncBuilder fb, QNm[] names, Object function) throws QueryException {
        ExprList list = new ExprList(fb.args());
        int nl = names.length;
        for (QNm qnm : fb.keywords) {
            int n = nl;
            while (--n >= 0 && !qnm.eq(names[n])) {
            }
            if (n == -1) {
                throw QueryError.KEYWORDUNKNOWN_X_X.get(fb.info, function, qnm);
            }
            if (list.get(n) != null) {
                throw QueryError.ARGTWICE_X_X.get(fb.info, function, qnm);
            }
            list.set(n, fb.keywords.get(qnm));
        }
        return (Expr[])list.finish();
    }

    private static Cast constructorCall(QNm name, FuncBuilder fb) throws QueryException {
        Enum type = ListType.find(name);
        if (type == null) {
            type = AtomType.find(name, false);
        }
        if (type == null) {
            throw QueryError.WHICHFUNC_X.get(fb.info, AtomType.similar(name));
        }
        if (type.oneOf(AtomType.NOTATION, AtomType.ANY_ATOMIC_TYPE)) {
            throw QueryError.ABSTRACTFUNC_X.get(fb.info, new Object[]{name.prefixId()});
        }
        Expr[] prepared = Functions.prepareArgs(fb, CAST_PARAM, 0, 1, name.string());
        return new Cast(fb.info, prepared.length != 0 ? prepared[0] : new ContextValue(fb.info), SeqType.get(type, Occ.ZERO_OR_ONE));
    }

    private static StaticFuncCall staticCall(QNm name, FuncBuilder fb, QueryContext qc, boolean hasImport) throws QueryException {
        if (NSGlobal.reserved(name.uri()) && !Records.BUILT_IN.contains(name)) {
            throw qc.functions.similarError(name, fb.info);
        }
        StaticFuncCall call = new StaticFuncCall(name, fb.args(), fb.keywords, fb.info, hasImport);
        qc.functions.register(call);
        return call;
    }

    public static Expr item(StaticFunc sf, FuncBuilder fb, QueryContext qc, boolean hasImport) throws QueryException {
        FuncType sft = sf.funcType();
        int arity = fb.params.length;
        for (int a = 0; a < arity; ++a) {
            fb.add(sf.paramName(a), sft.argTypes[a], qc);
        }
        FuncType ft = FuncType.get(fb.anns, sft.declType, Arrays.copyOf(sft.argTypes, arity));
        StaticFuncCall call = Functions.staticCall(sf.name, fb, qc, hasImport);
        if (call.func != null) {
            fb.anns = call.func.anns;
        }
        return Functions.item(call, fb, ft, sf.name, sf.updating, false);
    }

    public static IntList checkArity(long nargs, int min, int max) {
        if (nargs >= (long)min && nargs <= (long)max) {
            return null;
        }
        IntList arities = new IntList();
        if (max != Integer.MAX_VALUE) {
            for (int m = min; m <= max; ++m) {
                arities.add(m);
            }
        } else {
            arities.add(-min);
        }
        return arities;
    }

    private static Expr item(Expr expr, FuncBuilder fb, FuncType ft, QNm name, boolean updating, boolean context) {
        Var[] params = fb.params;
        AnnList anns = fb.anns;
        VarScope vs = fb.vs;
        if (context) {
            return new FuncLit(fb.info, expr, params, anns, ft.seqType(), name, vs);
        }
        if (fb.runtime) {
            return new FuncItem(fb.info, expr, params, anns, ft, vs.stackSize(), name);
        }
        SeqType declType = updating ? Types.EMPTY_SEQUENCE_Z : (ft != null ? ft.declType : null);
        return new Closure(fb.info, expr, params, anns, vs, null, declType, name);
    }

    private static Expr[] prepareArgs(FuncBuilder fb, QNm[] names, int min, int max, Object function) throws QueryException {
        Expr[] args = fb.keywords != null ? Functions.prepareArgs(fb, names, function) : fb.args();
        int arity = args.length;
        for (int a = arity - 1; a >= 0; --a) {
            if (args[a] != null) continue;
            if (a < min) {
                throw QueryError.ARGMISSING_X_X.get(fb.info, function, names[a].prefixString());
            }
            args[a] = Empty.UNDEFINED;
        }
        IntList arities = Functions.checkArity(arity, min, max);
        if (arities != null) {
            throw Functions.wrongArity(arity, arities, false, fb.info, function);
        }
        return args;
    }

    private static int[] preparePlaceholders(FuncBuilder fb, QNm[] names, Expr[] args) {
        int[] phPerm = new int[fb.placeholders];
        int posArgs = fb.arity - fb.keywords.size();
        int p = 0;
        for (int a = 0; a < posArgs; ++a) {
            if (!PartFunc.placeholder(args[a])) continue;
            phPerm[p] = p;
            ++p;
        }
        int nonKwPh = p;
        for (int a = posArgs; a < fb.arity; ++a) {
            if (!PartFunc.placeholder(args[a])) continue;
            QNm name = names[a];
            int i = nonKwPh;
            for (QNm qnm : fb.keywords) {
                if (qnm.eq(name)) break;
                if (!PartFunc.placeholder(fb.keywords.get(qnm))) continue;
                ++i;
            }
            phPerm[p++] = i;
        }
        return phPerm;
    }

    static {
        ArrayList<FuncDefinition> list = new ArrayList<FuncDefinition>();
        Function.init(list);
        Class<?> clz = Reflect.find("org.basex.query.func.ApiFunction");
        Method mth = Reflect.method(clz, "init", ArrayList.class);
        if (mth != null) {
            Reflect.invoke(mth, null, list);
        }
        Iterator<FuncDefinition> iterator = list.iterator();
        while (iterator.hasNext()) {
            FuncDefinition fd;
            QNm name = fd.name;
            fd = iterator.next();
            if (BUILT_IN.put(name, fd) != null) {
                throw Util.notExpected("Function % defined twice.", name);
            }
            URIS.add(name.uri());
        }
    }
}

