/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import java.util.Date;
import org.basex.data.Data;
import org.basex.index.resource.ResourceType;
import org.basex.index.resource.Resources;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.db.DbAccessFn;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.DateTime;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public class DbList
extends DbAccessFn {
    @Override
    public final Iter iter(QueryContext qc) throws QueryException {
        String name = this.toZeroString(this.arg(0), qc);
        return name.isEmpty() ? this.list(qc) : this.resources(name, qc);
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        return this.iter(qc).value(qc, this);
    }

    Iter list(QueryContext qc) {
        StringList dbs = qc.context.databases.list(qc.user, null);
        TokenList list = new TokenList(dbs.size());
        for (String name : dbs) {
            list.add(name);
        }
        return StrSeq.get(list).iter();
    }

    Iter resources(String name, QueryContext qc) throws QueryException {
        final Data data = this.toData(name, qc);
        String path = this.toZeroString(this.arg(1), qc);
        Resources resources = data.resources;
        final IntList docs = resources.docs(path);
        final StringList binaries = resources.paths(path, ResourceType.BINARY);
        final StringList values = resources.paths(path, ResourceType.VALUE);
        final int ds = docs.size();
        final int bs = ds + binaries.size();
        int size = bs + values.size();
        return new BasicIter<Str>((long)size){

            @Override
            public Str get(long i) {
                return i < this.size ? Str.get(this.path((int)i)) : null;
            }

            @Override
            public Value value(QueryContext q, Expr expr) throws QueryException {
                TokenList tl = new TokenList(Seq.initialCapacity(this.size));
                int t = 0;
                while ((long)t < this.size) {
                    tl.add(this.path(t));
                    ++t;
                }
                return StrSeq.get(tl);
            }

            private byte[] path(int i) {
                return i < ds ? data.text(docs.get(i), true) : Token.token(i < bs ? (String)binaries.get(i - ds) : (String)values.get(i - bs));
            }
        };
    }

    static FNode dir(String path, long mdate) {
        String date = DateTime.format(new Date(mdate));
        return FElem.build(Q_DIR).add(path).add(Q_MODIFIED_DATE, date).finish();
    }

    static FNode resource(String path, long mdate, long size, ResourceType type) {
        FBuilder elem = FElem.build(Q_RESOURCE).add(path);
        elem.add(Q_TYPE, (Object)type);
        elem.add(Q_CONTENT_TYPE, type.contentType(path));
        elem.add(Q_MODIFIED_DATE, DateTime.format(new Date(mdate)));
        elem.add(Q_SIZE, size);
        return elem.finish();
    }
}

