/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.inspect;

import java.util.Collections;
import java.util.HashSet;
import org.basex.io.IOContent;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Functions;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.StaticFunc;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.parse.FuncBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.FuncItem;

public final class InspectFunctions
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        String source = this.toStringOrNull(this.arg(0), qc);
        if (source == null) {
            ValueBuilder vb = new ValueBuilder(qc);
            for (StaticFunc sf : qc.functions.funcs()) {
                if (NSGlobal.reserved(sf.name.uri())) continue;
                InspectFunctions.addItems(vb, sf, qc);
            }
            return vb.value(this);
        }
        IOContent src = this.toContent(source, qc);
        Value funcs = qc.resources.functions(src.path());
        if (funcs != null) {
            return funcs;
        }
        HashSet old = new HashSet();
        Collections.addAll(old, qc.functions.funcs());
        try {
            qc.parse(src.toString(), src.path());
            qc.functions.compileAll(new CompileContext(qc, true));
        }
        catch (QueryException ex) {
            throw QueryError.INSPECT_PARSE_X.get(this.info, ex);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (StaticFunc sf : qc.functions.funcs()) {
            if (old.contains(sf)) continue;
            InspectFunctions.addItems(vb, sf, qc);
        }
        funcs = vb.value(this);
        qc.resources.addFunctions(src.path(), funcs);
        return funcs;
    }

    @Override
    protected Expr opt(CompileContext cc) {
        if (!this.defined(0)) {
            cc.qc.functions.compileAll(cc);
        }
        return this;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.lock((String)null) && super.accept(visitor);
    }

    private static void addItems(ValueBuilder vb, StaticFunc sf, QueryContext qc) throws QueryException {
        for (int a = sf.minArity(); a <= sf.arity(); ++a) {
            FuncBuilder fb = new FuncBuilder(sf.info, a, true);
            vb.add((FuncItem)Functions.item(sf, fb, qc, true));
        }
    }
}

