/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import org.basex.query.util.fingertree.FingerTreeBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.array.ArrBuilder;
import org.basex.query.value.array.BigArray;
import org.basex.query.value.array.LeafNode;
import org.basex.query.value.array.SmallArray;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Types;
import org.basex.util.Util;

final class TreeArrayBuilder
extends ArrBuilder {
    private static final int CAP = 38;
    private static final int NODE_SIZE = 12;
    private Value[] members = new Value[38];
    private FingerTreeBuilder<Value> tree = new FingerTreeBuilder();
    private int inLeft;
    private int mid = 19;
    private int inRight;

    TreeArrayBuilder() {
    }

    TreeArrayBuilder prepend(Value member) {
        if (this.inLeft < 19) {
            this.members[(this.mid - this.inLeft + 38 - 1) % 38] = member;
            ++this.inLeft;
        } else if (this.tree.isEmpty() && this.inRight < 19) {
            this.mid = (this.mid + 38 - 1) % 38;
            this.members[(this.mid - this.inLeft + 38) % 38] = member;
            ++this.inRight;
        } else {
            Value[] leaf = new Value[12];
            int start = (this.mid - 12 + 38) % 38;
            for (int i = 0; i < 12; ++i) {
                leaf[i] = this.members[(start + i) % 38];
            }
            this.tree.prepend(new LeafNode(leaf));
            int rest = this.inLeft - 12;
            int p0 = (this.mid - this.inLeft + 38) % 38;
            for (int i = 0; i < rest; ++i) {
                int from = (p0 + i) % 38;
                int to = (from + 12) % 38;
                this.members[to] = this.members[from];
            }
            this.members[(this.mid - rest + 38 - 1) % 38] = member;
            this.inLeft = rest + 1;
        }
        return this;
    }

    @Override
    public TreeArrayBuilder add(Value member) {
        if (this.inRight < 19) {
            this.members[(this.mid + this.inRight) % 38] = member;
            ++this.inRight;
        } else if (this.tree.isEmpty() && this.inLeft < 19) {
            this.mid = (this.mid + 1) % 38;
            this.members[(this.mid + this.inRight + 38 - 1) % 38] = member;
            ++this.inLeft;
        } else {
            Value[] leaf = new Value[12];
            int start = this.mid;
            for (int i = 0; i < 12; ++i) {
                leaf[i] = this.members[(start + i) % 38];
            }
            this.tree.append(new LeafNode(leaf));
            int rest = this.inRight - 12;
            for (int i = 0; i < rest; ++i) {
                int to = (this.mid + i) % 38;
                int from = (to + 12) % 38;
                this.members[to] = this.members[from];
            }
            this.members[(this.mid + rest) % 38] = member;
            this.inRight = rest + 1;
        }
        return this;
    }

    XQArray array() {
        return this.array(Types.ARRAY);
    }

    @Override
    public XQArray array(ArrayType type) {
        int i;
        FingerTreeBuilder<Value> builder = this.tree;
        Value[] values = this.members;
        this.members = null;
        this.tree = null;
        int n = this.inLeft + this.inRight;
        if (n == 0) {
            return XQArray.empty();
        }
        int start = (this.mid - this.inLeft + 38) % 38;
        if (n == 1) {
            return XQArray.get(values[start]);
        }
        if (n <= 7) {
            Value[] small = new Value[n];
            for (int i2 = 0; i2 < n; ++i2) {
                small[i2] = values[(start + i2) % 38];
            }
            return new SmallArray(small, type);
        }
        int a = builder.isEmpty() ? n / 2 : this.inLeft;
        int b = n - a;
        Value[] ls = new Value[a];
        Value[] rs = new Value[b];
        for (i = 0; i < a; ++i) {
            ls[i] = values[(start + i) % 38];
        }
        for (i = a; i < n; ++i) {
            rs[i - a] = values[(start + i) % 38];
        }
        return new BigArray(ls, builder.freeze(), rs, type);
    }

    public String toString() {
        StringBuilder sb;
        block5: {
            block4: {
                sb = new StringBuilder(Util.className(this)).append('[');
                if (!this.tree.isEmpty()) break block4;
                int n = this.inLeft + this.inRight;
                int first = (this.mid - this.inLeft + 38) % 38;
                if (n <= 0) break block5;
                sb.append(this.members[first]);
                for (int i = 1; i < n; ++i) {
                    sb.append(", ").append(this.members[(first + i) % 38]);
                }
                break block5;
            }
            int first = (this.mid - this.inLeft + 38) % 38;
            sb.append(this.members[first]);
            for (int i = 1; i < this.inLeft; ++i) {
                sb.append(", ").append(this.members[(first + i) % 38]);
            }
            for (Value value : this.tree) {
                sb.append(", ").append(value);
            }
            for (int i = 0; i < this.inRight; ++i) {
                sb.append(", ").append(this.members[(this.mid + i) % 38]);
            }
        }
        return sb.append(']').toString();
    }
}

