/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.Predicate;
import org.basex.core.Stores;
import org.basex.data.Data;
import org.basex.io.out.DataOutput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.iter.Iter;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.EmptyArray;
import org.basex.query.value.array.ItemArray;
import org.basex.query.value.array.SingletonArray;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.XQStruct;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.BoolList;
import org.basex.util.list.ByteList;
import org.basex.util.list.DoubleList;
import org.basex.util.list.ElementList;
import org.basex.util.list.FloatList;
import org.basex.util.list.IntList;
import org.basex.util.list.LongList;
import org.basex.util.list.ObjectList;
import org.basex.util.list.ShortList;
import org.basex.util.list.StringList;

public abstract class XQArray
extends XQStruct {
    private Iterable<Value> iterable;

    XQArray(Type type) {
        super(type);
    }

    public static XQArray empty() {
        return EmptyArray.EMPTY;
    }

    public static XQArray get(Value member) {
        return new SingletonArray(member);
    }

    public static XQArray items(Value members) {
        long size = members.size();
        return size == 0L ? XQArray.empty() : (size == 1L ? XQArray.get(members) : new ItemArray(members));
    }

    public abstract Value memberAt(long var1);

    @Override
    public Iter itemsIter() {
        return new Iter(){
            final Iterator<Value> values;
            Iter ir;
            {
                this.values = XQArray.this.iterator(0L);
            }

            @Override
            public Item next() throws QueryException {
                Item item;
                while (this.ir == null || (item = this.ir.next()) == null) {
                    if (!this.values.hasNext()) {
                        return null;
                    }
                    this.ir = this.values.next().iter();
                }
                return item;
            }
        };
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        ValueBuilder vb = new ValueBuilder(qc, this.structSize());
        for (Value value : this.iterable()) {
            vb.add(value.atomValue(qc, ii));
        }
        return vb.value(AtomType.ANY_ATOMIC_TYPE);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Value ex = this;
        if (mode.oneOf(CompileContext.Simplify.NUMBER, CompileContext.Simplify.DATA)) {
            ex = this.items(cc.qc);
        }
        return cc.simplify(this, ex, mode);
    }

    public final XQArray subArray(long pos, long length, QueryContext qc) {
        return length == 0L ? XQArray.empty() : (length == 1L ? XQArray.get(this.memberAt(pos)) : (length == this.structSize() ? this : this.subArr(pos, length, qc)));
    }

    protected abstract XQArray subArr(long var1, long var3, QueryContext var5);

    public abstract XQArray putMember(long var1, Value var3, QueryContext var4);

    public final XQArray appendMember(Value value, QueryContext qc) {
        return this.insertMember(this.structSize(), value, qc);
    }

    public abstract XQArray insertMember(long var1, Value var3, QueryContext var4);

    public abstract XQArray removeMember(long var1, QueryContext var3);

    public XQArray reverseArray(QueryContext qc) {
        qc.checkStop();
        long size = this.structSize();
        ArrayBuilder ab = new ArrayBuilder(qc, size);
        for (long i = size - 1L; i >= 0L; --i) {
            ab.add(this.memberAt(i));
        }
        return ab.array(this);
    }

    @Override
    public void cache(boolean lazy, InputInfo ii) throws QueryException {
        for (Value value : this.iterable()) {
            value.cache(lazy, ii);
        }
    }

    @Override
    public final void write(DataOutput out) throws IOException, QueryException {
        out.writeLong(this.structSize());
        for (Value value : this.iterable()) {
            Stores.write(out, value);
        }
    }

    public ListIterator<Value> iterator(final long start) {
        return new ListIterator<Value>(){
            private int index;
            {
                this.index = (int)start;
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public boolean hasNext() {
                return (long)this.index < XQArray.this.structSize();
            }

            @Override
            public Value next() {
                return XQArray.this.memberAt(this.index++);
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Value previous() {
                return XQArray.this.memberAt(--this.index);
            }

            @Override
            public void set(Value e) {
                throw Util.notExpected();
            }

            @Override
            public void add(Value e) {
                throw Util.notExpected();
            }

            @Override
            public void remove() {
                throw Util.notExpected();
            }
        };
    }

    public final Iterable<Value> iterable() {
        if (this.iterable == null) {
            this.iterable = () -> this.iterator(0L);
        }
        return this.iterable;
    }

    final ArrayType union(Value value) {
        return ((ArrayType)this.type).union(value.seqType());
    }

    @Override
    public final Value invokeInternal(QueryContext qc, InputInfo ii, Value[] args) throws QueryException {
        return this.get(XQArray.key(args[0], qc, ii), qc, ii);
    }

    public final Value get(Item key, QueryContext qc, InputInfo ii) throws QueryException {
        long i = XQArray.index(key, qc, ii);
        long size = this.structSize();
        if (i > 0L && i <= size) {
            return this.memberAt(i - 1L);
        }
        throw (size == 0L ? QueryError.ARRAYEMPTY : QueryError.ARRAYBOUNDS_X_X).get(ii, i, size);
    }

    public final Value getOrNull(Item key, QueryContext qc, InputInfo ii) throws QueryException {
        long i = XQArray.index(key, qc, ii);
        return i > 0L && i <= this.structSize() ? this.memberAt(i - 1L) : null;
    }

    private static long index(Item key, QueryContext qc, InputInfo ii) throws QueryException {
        return ((Itr)Types.INTEGER_O.coerce((Value)key, null, qc, null, ii)).itr();
    }

    @Override
    public final Item atomItem(QueryContext qc, InputInfo ii) throws QueryException {
        return this.atomValue(qc, ii).item(qc, ii);
    }

    @Override
    public final void string(boolean indent, TokenBuilder tb, int level, InputInfo ii) throws QueryException {
        tb.add(91);
        int c = 0;
        for (Value value : this.iterable()) {
            long vs;
            if (c++ > 0) {
                tb.add(44);
                if (indent) {
                    tb.add(32);
                }
            }
            if ((vs = value.size()) != 1L) {
                tb.add(40);
            }
            int cc = 0;
            int i = 0;
            while ((long)i < vs) {
                Item item;
                if (cc++ > 0) {
                    tb.add(44);
                    if (indent) {
                        tb.add(32);
                    }
                }
                if ((item = value.itemAt(i)) instanceof XQArray) {
                    XQArray array = (XQArray)item;
                    array.string(indent, tb, level, ii);
                } else if (item instanceof XQMap) {
                    XQMap map = (XQMap)item;
                    map.string(indent, tb, level + 1, ii);
                } else {
                    tb.add(item.toString());
                }
                ++i;
            }
            if (vs == 1L) continue;
            tb.add(41);
        }
        tb.add(93);
    }

    @Override
    public final Item materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) throws QueryException {
        if (this.materialized(test, ii)) {
            return this;
        }
        ArrayBuilder ab = new ArrayBuilder(qc, this.structSize());
        for (Value value : this.iterable()) {
            qc.checkStop();
            ab.add(value.materialize(test, ii, qc));
        }
        return ab.array(this);
    }

    @Override
    public final boolean materialized(Predicate<Data> test, InputInfo ii) throws QueryException {
        if (!this.funcType().declType.type.instanceOf(AtomType.ANY_ATOMIC_TYPE)) {
            for (Value value : this.iterable()) {
                if (value.materialized(test, ii)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean instanceOf(Type tp, boolean coerce) {
        SeqType mt;
        if (coerce && tp instanceof FuncType) {
            return this.type == tp;
        }
        if (this.type.instanceOf(tp)) {
            return true;
        }
        if (tp instanceof ArrayType) {
            ArrayType at = (ArrayType)tp;
            mt = at.valueType();
        } else if (tp instanceof FuncType) {
            FuncType ft = (FuncType)tp;
            if (ft.argTypes.length != 1 || !ft.argTypes[0].instanceOf(Types.INTEGER_O)) {
                return false;
            }
            mt = ft.declType;
        } else {
            return false;
        }
        if (!mt.eq(Types.ITEM_ZM)) {
            for (Value value : this.iterable()) {
                if (mt.instance(value)) continue;
                return false;
            }
        }
        return true;
    }

    public final XQArray coerceTo(ArrayType at, QueryContext qc, CompileContext cc, InputInfo ii) throws QueryException {
        ArrayBuilder ab = new ArrayBuilder(qc, this.structSize());
        for (Value value : this.iterable()) {
            qc.checkStop();
            ab.add(at.valueType().coerce(value, null, qc, cc, ii));
        }
        return ab.array(at);
    }

    @Override
    public final boolean refineType() {
        ArrayType refined = null;
        for (Value value : this.iterable()) {
            ArrayType at = ArrayType.get(value.seqType());
            if (!(refined = refined == null ? at : refined.union(at)).eq(this.type)) continue;
            return true;
        }
        this.type = refined;
        return true;
    }

    @Override
    public final boolean deepEqual(Item item, DeepEqual deep) throws QueryException {
        if (this == item) {
            return true;
        }
        if (item instanceof XQArray) {
            XQArray array = (XQArray)item;
            if (this.structSize() != array.structSize()) {
                return false;
            }
            ListIterator<Value> iter1 = this.iterator(0L);
            ListIterator<Value> iter2 = array.iterator(0L);
            while (iter1.hasNext()) {
                Value value1 = (Value)iter1.next();
                Value value2 = (Value)iter2.next();
                if (deep == null ? value1.equals(value2) : deep.equal(value1, value2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected final XQArray rebuild(QueryContext qc) throws QueryException {
        ArrayBuilder ab = new ArrayBuilder(qc, this.structSize());
        for (Value value : this.iterable()) {
            ab.add(value.shrink(qc));
        }
        return ab.array(this);
    }

    @Override
    public final Object toJava() throws QueryException {
        int sz = (int)this.structSize();
        Object dt = this.funcType().declType;
        if (sz > 0 && ((SeqType)dt).type == AtomType.ITEM) {
            dt = null;
            for (Value value : this.iterable()) {
                Iterator<Value> st = value.seqType();
                dt = dt == null ? st : ((SeqType)dt).union((SeqType)((Object)st));
            }
        }
        if (((SeqType)dt).one()) {
            ElementList list;
            Type tp = ((SeqType)dt).type;
            if (tp == AtomType.BOOLEAN) {
                list = new BoolList(sz);
                for (Value value : this.iterable()) {
                    ((BoolList)list).add(((Bln)value).bool(null));
                }
                return ((BoolList)list).finish();
            }
            if (tp == AtomType.BYTE) {
                list = new ByteList(sz);
                for (Value value : this.iterable()) {
                    ((ByteList)list).add((byte)((Itr)value).itr());
                }
                return ((ByteList)list).finish();
            }
            if (tp.oneOf(AtomType.SHORT, AtomType.UNSIGNED_BYTE)) {
                list = new ShortList(sz);
                for (Value value : this.iterable()) {
                    ((ShortList)list).add((short)((Itr)value).itr());
                }
                return ((ShortList)list).finish();
            }
            if (tp == AtomType.UNSIGNED_SHORT) {
                char[] chars = new char[sz];
                int c = 0;
                for (Value value : this.iterable()) {
                    chars[c++] = (char)((Itr)value).itr();
                }
                return chars;
            }
            if (tp == AtomType.INT) {
                list = new IntList(sz);
                for (Value value : this.iterable()) {
                    ((IntList)list).add((int)((Itr)value).itr());
                }
                return ((IntList)list).finish();
            }
            if (tp.instanceOf(AtomType.INTEGER) && tp != AtomType.UNSIGNED_LONG) {
                list = new LongList(sz);
                for (Value value : this.iterable()) {
                    ((LongList)list).add(((Itr)value).itr());
                }
                return ((LongList)list).finish();
            }
            if (tp == AtomType.FLOAT) {
                list = new FloatList(sz);
                for (Value value : this.iterable()) {
                    ((FloatList)list).add(((Flt)value).flt());
                }
                return ((FloatList)list).finish();
            }
            if (tp == AtomType.DOUBLE) {
                list = new DoubleList(sz);
                for (Value value : this.iterable()) {
                    ((DoubleList)list).add(((Dbl)value).dbl());
                }
                return ((DoubleList)list).finish();
            }
            if (tp.instanceOf(AtomType.STRING)) {
                list = new StringList(sz);
                for (Value value : this.iterable()) {
                    ((ObjectList)list).add((String)value.toJava());
                }
                return ((ObjectList)list).finish();
            }
        }
        ArrayList<Object> list = new ArrayList<Object>(sz);
        for (Value value : this.iterable()) {
            list.add(value.toJava());
        }
        return list.toArray();
    }

    @Override
    public String description() {
        return "array";
    }

    @Override
    public void toXml(QueryPlan plan) {
        ExprList list = new ExprList();
        long size = this.structSize();
        long max = Math.min(size, 5L);
        int m = 0;
        while ((long)m < max) {
            list.add(this.memberAt(m));
            ++m;
        }
        plan.add(plan.create(this, "entries", size), (ExprInfo[])list.finish());
    }

    @Override
    public void toString(QueryString qs) {
        if (this.structSize() == 0L) {
            qs.token("[]");
        } else {
            TokenBuilder tb = new TokenBuilder();
            for (Value value : this.iterable()) {
                if (!tb.moreInfo()) break;
                tb.add(tb.isEmpty() ? " " : ", ");
                long vs = value.size();
                if (vs != 1L) {
                    tb.add(40);
                }
                int m = 0;
                while ((long)m < vs) {
                    if (m != 0) {
                        tb.add(", ");
                    }
                    tb.add(value.itemAt(m));
                    ++m;
                }
                if (vs == 1L) continue;
                tb.add(41);
            }
            qs.braced("[ ", tb.add(32).finish(), " ]");
        }
    }
}

