/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.FnRound;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class ANum
extends Item {
    ANum(Type type) {
        super(type);
    }

    @Override
    public final byte[] string(InputInfo ii) {
        return this.string();
    }

    @Override
    public final double dbl(InputInfo ii) {
        return this.dbl();
    }

    @Override
    public final long itr(InputInfo ii) {
        return this.itr();
    }

    @Override
    public final float flt(InputInfo ii) {
        return this.flt();
    }

    @Override
    public final boolean atomicEqual(Item item) throws QueryException {
        if (this == item) {
            return true;
        }
        if (item instanceof ANum) {
            double d1 = this.dbl();
            double d2 = item.dbl(null);
            boolean n1 = Double.isNaN(d1);
            boolean n2 = Double.isNaN(d2);
            if (n1 || n2) {
                return n1 == n2;
            }
            if (Double.isInfinite(d1) || Double.isInfinite(d2)) {
                return d1 == d2;
            }
            return this.dec(null).compareTo(item.dec(null)) == 0;
        }
        return false;
    }

    protected abstract byte[] string();

    public abstract long itr();

    public abstract double dbl();

    protected abstract float flt();

    public abstract ANum abs();

    public abstract ANum ceiling();

    public abstract ANum floor();

    public abstract ANum round(int var1, FnRound.RoundMode var2);

    @Override
    public final boolean comparable(Item item) {
        return item instanceof ANum;
    }

    final int compare(Item item, boolean transitive, InputInfo ii) throws QueryException {
        double d;
        BigDecimal bd;
        byte[] string;
        long l;
        Item num2 = item.type.isUntyped() ? ((l = Token.toLong(string = item.string(ii))) != Long.MIN_VALUE ? Itr.get(l) : ((bd = Dec.parse(string, ii, false)) != null ? Dec.get(bd) : Dbl.get(Dbl.parse(string, ii)))) : item;
        if (num2 instanceof Itr) {
            Itr itr2 = (Itr)num2;
            if (this instanceof Itr) {
                return Long.compare(this.itr(), itr2.itr());
            }
        } else if ((num2 instanceof Dbl || num2 instanceof Flt) && !Double.isFinite(d = num2.dbl(ii))) {
            return d == Double.NEGATIVE_INFINITY ? 1 : (d == Double.POSITIVE_INFINITY ? -1 : (transitive ? 1 : Integer.MIN_VALUE));
        }
        return this.dec(ii).compareTo(num2.dec(ii));
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        return pos > 0L ? this.dbl() == (double)pos : this.bool(ii);
    }

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Item expr = this;
        double d = this.dbl();
        if (mode == CompileContext.Simplify.PREDICATE && (d != (double)this.itr() || d < 1.0) || mode == CompileContext.Simplify.EBV && d == 0.0) {
            expr = Bln.FALSE;
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public final Expr optimizePos(CmpV.OpV op, CompileContext cc) {
        long l;
        double d = this.dbl();
        boolean fractional = d != (double)(l = (long)d);
        switch (op) {
            case EQ: {
                if (!(d < 1.0) && !fractional) break;
                return Bln.FALSE;
            }
            case NE: {
                if (!(d < 1.0) && !fractional) break;
                return Bln.TRUE;
            }
            case LE: {
                if (!(d < 1.0)) break;
                return Bln.FALSE;
            }
            case GT: {
                if (!(d < 1.0)) break;
                return Bln.TRUE;
            }
            case LT: {
                if (!(d < Math.nextUp(1.0))) break;
                return Bln.FALSE;
            }
            case GE: {
                if (!(d < Math.nextUp(1.0))) break;
                return Bln.TRUE;
            }
        }
        return fractional || this instanceof Itr ? this : Itr.get(l);
    }

    public int hashCode() {
        long l = this.itr();
        float f = this.flt();
        int h = Float.floatToRawIntBits(f - (float)l) ^ Long.hashCode(l);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    @Override
    public final void toString(QueryString qs) {
        qs.token(this.string(null));
    }
}

