/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.file.NoSuchFileException;
import java.util.Scanner;
import java.util.function.BiConsumer;
import javax.net.ssl.SSLException;
import org.basex.core.Text;
import org.basex.core.jobs.JobException;
import org.basex.io.IOStream;
import org.basex.io.in.NewlineInput;
import org.basex.query.QueryException;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenObjectMap;
import org.basex.util.list.StringList;

public final class Util {
    private static final boolean NOCONSOLE = System.console() == null;

    private Util() {
    }

    public static String bug(Throwable throwable) {
        TokenBuilder tb = new TokenBuilder().add("Improper use? Potential bug? Your feedback is welcome:").add(Text.NL);
        tb.add("Contact: ").add(Text.MAILING_LIST).add(Text.NL);
        tb.add("Version: ").add(Text.TITLE).add(Text.NL);
        tb.add("Java: ").add(Prop.JAVA_VENDOR).add(", ").add(Prop.JAVA_VERSION).add(Text.NL);
        tb.add("OS: ").add(Prop.OS).add(", ").add(Prop.OS_ARCH).add(Text.NL);
        tb.add("Stack Trace:");
        for (String string : Util.toArray(throwable)) {
            tb.add(Text.NL).add(string);
        }
        return tb.toString();
    }

    public static RuntimeException notExpected() {
        return new RuntimeException("Not Expected.");
    }

    public static RuntimeException notExpected(Object message, Object ... ext) {
        return new RuntimeException(Util.info(message, ext));
    }

    public static String className(Object object) {
        return Util.className(object.getClass());
    }

    public static String className(Class<?> clazz) {
        return clazz.getSimpleName();
    }

    public static String input() {
        Scanner sc = new Scanner(System.in);
        return sc.hasNextLine() ? sc.nextLine().trim() : "";
    }

    public static String password() {
        if (NOCONSOLE) {
            return Util.input();
        }
        char[] pw = System.console().readPassword();
        return pw != null ? new String(pw) : "";
    }

    public static void println(Object string, Object ... ext) {
        Object object;
        if (string instanceof byte[]) {
            byte[] bytes = (byte[])string;
            object = Token.string(bytes);
        } else {
            object = string;
        }
        Util.print(String.valueOf(object) + Text.NL, ext);
    }

    public static void print(Object string, Object ... ext) {
        System.out.print(Util.info(string, ext));
    }

    public static Throwable rootException(Throwable throwable) {
        Throwable th = throwable;
        while (true) {
            Util.debug(th);
            Throwable ca = th.getCause();
            if (ca == null || th instanceof QueryException && !(ca instanceof QueryException)) {
                return th;
            }
            th = ca;
        }
    }

    public static void errln(Object object, Object ... ext) {
        Object object2;
        if (object instanceof Throwable) {
            Throwable th = (Throwable)object;
            object2 = Util.message(th);
        } else {
            object2 = object;
        }
        Util.err(String.valueOf(object2) + Text.NL, ext);
    }

    public static void err(String string, Object ... ext) {
        System.err.print(Util.info(string, ext));
    }

    public static String message(Throwable th) {
        Util.debug(th);
        if (th instanceof BindException) {
            return Text.SRV_RUNNING;
        }
        if (th instanceof ConnectException) {
            return Text.CONNECTION_ERROR;
        }
        if (th instanceof SocketTimeoutException) {
            return Text.TIMEOUT_EXCEEDED;
        }
        if (th instanceof SocketException) {
            return Text.CONNECTION_ERROR;
        }
        Object msg = th.getMessage();
        if (th instanceof JobException) {
            return msg;
        }
        if (msg == null || ((String)msg).isEmpty() || th instanceof RuntimeException || th instanceof Error) {
            msg = th.toString();
        }
        if (th instanceof ReflectiveOperationException && th.getCause() != null) {
            msg = (String)msg + "; " + String.valueOf(th.getCause());
        }
        if (th instanceof FileNotFoundException || th instanceof NoSuchFileException) {
            return Util.info(Text.RES_NOT_FOUND_X, msg);
        }
        if (th instanceof UnknownHostException) {
            return Util.info(Text.UNKNOWN_HOST_X, msg);
        }
        if (th instanceof SSLException) {
            return "SSL: " + (String)msg;
        }
        if (th.getClass() == IOException.class && ((String)msg).length() > 200) {
            msg = ((String)msg).substring(0, 200) + "...";
        }
        return msg;
    }

    public static void debug(Throwable throwable) {
        if (Prop.debug && throwable != null) {
            Util.stack(throwable);
        }
    }

    public static void debugln(Object string, Object ... ext) {
        if (Prop.debug) {
            Util.errln(string, ext);
        }
    }

    public static String info(Object string, Object ... ext) {
        return Token.string(Util.inf(string, ext));
    }

    public static byte[] inf(Object string, Object ... ext) {
        return new TokenBuilder().addExt(string, ext).finish();
    }

    public static void stack(String message) {
        Util.stack(message, Short.MAX_VALUE);
    }

    public static void stack(int depth) {
        Util.stack("You're here:", depth);
    }

    private static void stack(String message, int depth) {
        Util.errln(message, new Object[0]);
        String[] stack = Util.toArray(new Throwable());
        int l = Math.min(Math.max(2, depth + 2), stack.length);
        for (int s = 3; s < l; ++s) {
            Util.errln(stack[s], new Object[0]);
        }
    }

    public static void stack(Throwable throwable) {
        throwable.printStackTrace();
    }

    private static String[] toArray(Throwable throwable) {
        StringList sl = (StringList)((Object)new StringList().add(throwable.toString()));
        for (StackTraceElement st : throwable.getStackTrace()) {
            sl.add("\tat " + String.valueOf(st));
        }
        return (String[])sl.finish();
    }

    public static Process start(Class<?> clazz, String ... args) {
        String[] largs = new String[]{"java", "-Xmx" + Runtime.getRuntime().maxMemory(), "-cp", System.getProperty("java.class.path")};
        StringList sl = (StringList)new StringList().add(largs);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key.toString().startsWith("org.basex.")) {
                sl.add("-D" + String.valueOf(key) + "=" + String.valueOf(value));
            }
        }));
        ((StringList)((Object)((StringList)((Object)sl.add(clazz.getName()))).add("-D"))).add(args);
        try {
            return new ProcessBuilder((String[])sl.finish()).start();
        }
        catch (IOException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }

    public static String error(Process process, int timeout) {
        int wait = 200;
        int to = Math.max(timeout / 200, 1);
        for (int c = 0; c < to; ++c) {
            try {
                int exit = process.exitValue();
                if (exit == 1) {
                    return new IOStream(process.getErrorStream()).readString();
                }
                break;
            }
            catch (IllegalThreadStateException ex) {
                Util.debug(ex);
                Performance.sleep(200L);
                continue;
            }
            catch (IOException ex) {
                return ex.getLocalizedMessage();
            }
        }
        return null;
    }

    public static TokenObjectMap<byte[]> properties(String name) {
        InputStream is = Util.class.getResourceAsStream("/" + name);
        if (is == null) {
            throw Util.notExpected("%: Property resource missing.", name);
        }
        TokenObjectMap<byte[]> map = new TokenObjectMap<byte[]>();
        try (NewlineInput nli = new NewlineInput(is);){
            String line;
            while ((line = nli.readLine()) != null) {
                int s = line.indexOf(61);
                if (s == -1 || Strings.startsWith(line, '#')) continue;
                byte[] key = Token.token(line.substring(0, s).trim());
                if (map.contains(key)) {
                    throw Util.notExpected("%: '%' is declared twice.", name, key);
                }
                map.put(key, Token.token(line.substring(s + 1).trim().replace("\\t", "\t").replace("\\n", "\n")));
            }
        }
        catch (IOException ex) {
            throw Util.notExpected("%: %", name, ex);
        }
        return map;
    }

    public static boolean inBounds(long value1, long value2) {
        return value2 == 0L || value1 <= Long.MAX_VALUE / value2;
    }
}

