/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.expr.path.NameTest;
import org.basex.query.func.XQFunctionExpr;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ExprType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.RecordType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.Enums;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class ParseExpr
extends Expr {
    private static final ConcurrentHashMap<Class<? extends ParseExpr>, Boolean> ITERIMPLS = new ConcurrentHashMap();
    public final ExprType exprType;
    protected InputInfo info;
    private final boolean iterImpl;

    protected ParseExpr(InputInfo info, SeqType seqType) {
        this.info = info;
        this.exprType = new ExprType(seqType);
        this.iterImpl = ITERIMPLS.computeIfAbsent(this.getClass(), c -> {
            for (Class<?> clz = this.getClass(); clz != ParseExpr.class; clz = clz.getSuperclass()) {
                try {
                    if (clz.getMethod("iter", QueryContext.class).getDeclaringClass() != clz) continue;
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        });
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.iterImpl ? this.iter(qc).value(qc, this) : this.item(qc, this.info);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.iterImpl ? this.item(this.iter(qc), qc) : this.value(qc).item(qc, this.info);
    }

    @Override
    public Item atomItem(QueryContext qc, InputInfo ii) throws QueryException {
        return this.iterImpl ? this.item(this.atomIter(qc, this.info), qc) : super.atomItem(qc, this.info);
    }

    private Item item(Iter iter, QueryContext qc) throws QueryException {
        Item item1 = iter.next();
        if (item1 == null) {
            return Empty.VALUE;
        }
        Item item2 = iter.next();
        if (item2 == null) {
            return item1;
        }
        throw QueryError.typeError(item1.append(item2, qc), AtomType.ITEM, this.info);
    }

    @Override
    public final Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        return this.value(qc).atomValue(qc, this.info);
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        if (this.seqType().zeroOrOne()) {
            return this.item(qc, this.info).test(qc, this.info, pos);
        }
        Iter iter = this.iter(qc);
        Item item1 = iter.next();
        if (item1 == null) {
            return false;
        }
        if (item1 instanceof ANode) {
            return true;
        }
        Item item2 = iter.next();
        if (item2 == null) {
            return item1.test(qc, this.info, pos);
        }
        if (pos == 0L || !(item1 instanceof ANum)) {
            throw QueryError.testError(item1.append(item2, qc), false, this.info);
        }
        if (item1.test(qc, this.info, pos)) {
            return true;
        }
        do {
            if (!(item2 instanceof ANum)) {
                throw QueryError.testError(item1.append(item2, qc), true, this.info);
            }
            if (!item2.test(qc, this.info, pos)) continue;
            return true;
        } while ((item2 = iter.next()) != null);
        return false;
    }

    @Override
    public final SeqType seqType() {
        return this.exprType.seqType();
    }

    @Override
    public final long size() {
        return this.exprType.size();
    }

    @Override
    public Data data() {
        return this.exprType.data();
    }

    @Override
    public final void refineType(Expr expr) {
        this.exprType.refine(expr);
    }

    @Override
    public final InputInfo info() {
        return this.info;
    }

    public final StaticContext sc() {
        return this.info.sc();
    }

    public final <T extends Expr> T copyType(T expr) {
        if (expr instanceof ParseExpr) {
            ParseExpr pe = (ParseExpr)expr;
            pe.exprType.assign(this);
        }
        return expr;
    }

    public final ParseExpr adoptType(Expr expr) {
        this.exprType.assign(expr);
        return this;
    }

    protected final <T extends XQFunctionExpr> T checkUp(T expr, boolean updating) throws QueryException {
        if (updating != expr.annotations().contains(Annotation.UPDATING) && !this.sc().mixUpdates) {
            if (!updating) {
                throw QueryError.FUNCUP_X.get(this.info, expr);
            }
            if (!expr.vacuousBody()) {
                throw QueryError.FUNCNOTUP_X.get(this.info, expr);
            }
        }
        return expr;
    }

    protected final void checkNoUp(Expr expr) throws QueryException {
        if (expr == null) {
            return;
        }
        expr.checkUp();
        if (expr.has(Flag.UPD)) {
            throw QueryError.UPNOT_X.get(this.info, this.description());
        }
    }

    protected final void checkNoneUp(Expr ... exprs) throws QueryException {
        if (exprs == null) {
            return;
        }
        this.checkAllUp(exprs);
        for (Expr expr : exprs) {
            if (!expr.has(Flag.UPD)) continue;
            throw QueryError.UPNOT_X.get(this.info, this.description());
        }
    }

    protected final void checkAllUp(Expr ... exprs) throws QueryException {
        Boolean updating = null;
        for (Expr expr : exprs) {
            expr.checkUp();
            boolean upd = expr.has(Flag.UPD);
            boolean vacuous = expr.vacuous();
            if (upd ? updating == Boolean.FALSE : !vacuous && updating == Boolean.TRUE) {
                throw QueryError.UPALL.get(this.info, new Object[0]);
            }
            if (vacuous) continue;
            updating = upd;
        }
    }

    protected void checkPerm(QueryContext qc, Perm perm) throws QueryException {
        if (!qc.user.has(perm)) {
            throw QueryError.BASEX_PERMISSION_X_X.get(this.info, new Object[]{perm, this});
        }
    }

    protected void checkPerm(QueryContext qc, Perm perm, String name) throws QueryException {
        if (!qc.user.has(perm, name)) {
            throw QueryError.BASEX_PERMISSION_X_X.get(this.info(), new Object[]{perm, this});
        }
    }

    protected final Value ctxValue(QueryContext qc) throws QueryException {
        Value value = qc.focus.value;
        if (value != null) {
            return value;
        }
        throw QueryError.NOCTX_X.get(this.info, this);
    }

    protected final byte[] toToken(Expr expr, QueryContext qc) throws QueryException {
        return this.toToken(this.toAtomItem(expr, qc));
    }

    protected final byte[] toZeroToken(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item.isEmpty() ? Token.EMPTY : this.toToken(item);
    }

    protected final byte[] toTokenOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item.isEmpty() ? null : this.toToken(item);
    }

    protected final byte[] toToken(Item item) throws QueryException {
        Type type = item.type;
        if (type.isStringOrUntyped()) {
            return item.string(this.info);
        }
        throw item instanceof FItem ? QueryError.FIATOMIZE_X.get(this.info, item) : QueryError.typeError(item, AtomType.STRING, this.info);
    }

    protected final String toString(Expr expr, QueryContext qc) throws QueryException {
        return Token.string(this.toToken(expr, qc));
    }

    protected final String toString(Item item) throws QueryException {
        return Token.string(this.toToken(item));
    }

    protected final String toZeroString(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item.isEmpty() ? "" : this.toString(item);
    }

    protected final String toStringOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item.isEmpty() ? null : this.toString(item);
    }

    protected final boolean toBoolean(Expr expr, QueryContext qc) throws QueryException {
        return this.toBoolean(expr.atomItem(qc, this.info));
    }

    protected final boolean toBooleanOrFalse(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return !item.isEmpty() && this.toBoolean(item);
    }

    protected final boolean toBoolean(Item item) throws QueryException {
        Type type = item.type;
        if (type == AtomType.BOOLEAN) {
            return item.bool(this.info);
        }
        if (type.isUntyped()) {
            return Bln.parse(item, this.info);
        }
        throw QueryError.typeError(item, AtomType.BOOLEAN, this.info);
    }

    protected final double toDouble(Expr expr, QueryContext qc) throws QueryException {
        return this.toDouble(expr.atomItem(qc, this.info));
    }

    protected final double toDouble(Item item) throws QueryException {
        if (item.type.isNumberOrUntyped()) {
            return item.dbl(this.info);
        }
        throw QueryError.numberError(this, item);
    }

    protected final ANum toNumberOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item.isEmpty() ? null : this.toNumber(item);
    }

    protected final ANum toNumber(Item item) throws QueryException {
        if (item.type.isUntyped()) {
            return Dbl.get(item.dbl(this.info));
        }
        if (item instanceof ANum) {
            ANum num = (ANum)item;
            return num;
        }
        throw QueryError.numberError(this, item);
    }

    protected final float toFloat(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        if (item.type.isNumberOrUntyped()) {
            return item.flt(this.info);
        }
        throw QueryError.numberError(this, item);
    }

    protected final long toLong(Expr expr, QueryContext qc) throws QueryException {
        return this.toLong(expr.atomItem(qc, this.info));
    }

    protected final Long toLongOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item.isEmpty() ? null : Long.valueOf(this.toLong(item));
    }

    protected final long toLong(Item item) throws QueryException {
        Type type = item.type;
        if (type.instanceOf(AtomType.INTEGER) || type.isUntyped()) {
            return item.itr(this.info);
        }
        if (type == AtomType.DECIMAL) {
            long l = item.itr(this.info);
            if (item.dbl(this.info) == (double)l) {
                return l;
            }
        }
        throw QueryError.typeError(item, AtomType.INTEGER, this.info);
    }

    protected final long toLong(Item item, long min) throws QueryException {
        long v = this.toLong(item);
        if (v >= min) {
            return v;
        }
        throw QueryError.typeError(item, AtomType.INTEGER, this.info);
    }

    protected final ANode toNode(Expr expr, QueryContext qc) throws QueryException {
        return this.toNode(expr.item(qc, this.info));
    }

    protected final ANode toNodeOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.item(qc, this.info);
        return item.isEmpty() ? null : this.toNode(item);
    }

    protected final ANode toNode(Item item) throws QueryException {
        if (item instanceof ANode) {
            ANode node = (ANode)item;
            return node;
        }
        throw QueryError.typeError(item, NodeType.NODE, this.info);
    }

    protected final Item toAtomItem(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        if (item == Empty.VALUE) {
            throw QueryError.typeError(item, AtomType.ITEM, this.info);
        }
        return item;
    }

    protected final ANode toElem(Expr expr, QueryContext qc) throws QueryException {
        return (ANode)this.checkType(expr.item(qc, this.info), NodeType.ELEMENT);
    }

    protected final ANode toElem(Expr expr, QNm name, QueryContext qc, QueryError error) throws QueryException {
        ANode node = this.toElem(expr, qc);
        if (NameTest.get(name).matches(node)) {
            return node;
        }
        throw error.get(this.info, name.prefixId(), node.type, node);
    }

    protected final Bin toBin(Expr expr, QueryContext qc) throws QueryException {
        return this.toBin(expr.atomItem(qc, this.info));
    }

    protected final Bin toBin(Item item) throws QueryException {
        if (item instanceof Bin) {
            Bin bin = (Bin)item;
            return bin;
        }
        throw QueryError.BINARY_X.get(this.info, item.seqType());
    }

    protected final Bin toBinOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item.isEmpty() ? null : this.toBin(item);
    }

    protected final byte[] toBytes(Expr expr, QueryContext qc) throws QueryException {
        return this.toBytes(expr.atomItem(qc, this.info));
    }

    protected final byte[] toBytes(Item item) throws QueryException {
        if (item.type.isStringOrUntyped()) {
            return item.string(this.info);
        }
        if (item instanceof Bin) {
            Bin bin = (Bin)item;
            return bin.binary(this.info);
        }
        throw QueryError.STRBIN_X_X.get(this.info, item.seqType(), item);
    }

    protected final QNm toQNmOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item.isEmpty() ? null : this.toQNm(item);
    }

    protected final QNm toQNm(Item item) throws QueryException {
        Type type = item.type;
        if (type == AtomType.QNAME) {
            return (QNm)item;
        }
        if (type.isUntyped()) {
            throw QueryError.NSSENS_X_X.get(this.info, type, AtomType.QNAME);
        }
        throw QueryError.typeError(item, AtomType.QNAME, this.info);
    }

    protected final FItem toFunction(Expr expr, QueryContext qc) throws QueryException {
        return (FItem)this.checkType(expr.item(qc, this.info), Types.FUNCTION);
    }

    protected final XQMap toMap(Expr expr, QueryContext qc) throws QueryException {
        return this.toMap(expr.item(qc, this.info));
    }

    protected final XQMap toMap(Item item) throws QueryException {
        if (item instanceof XQMap) {
            XQMap map = (XQMap)item;
            return map;
        }
        throw QueryError.typeError(item, Types.MAP, this.info);
    }

    protected final XQMap toRecord(Item item, RecordType type, QueryContext qc) throws QueryException {
        return (XQMap)type.seqType().coerce((Value)item, null, qc, null, this.info);
    }

    protected final <T extends Enum<T>> T toEnum(Item item, Class<T> keys) throws QueryException {
        T key = Enums.get(keys, this.toString(item));
        if (key != null) {
            return key;
        }
        throw QueryError.EXP_FOUND_X_X.get(this.info, Arrays.toString(keys.getEnumConstants()), item);
    }

    protected final XQArray toArray(Expr expr, QueryContext qc) throws QueryException {
        return this.toArray(expr.item(qc, this.info));
    }

    protected final XQArray toArray(Item item) throws QueryException {
        if (item instanceof XQArray) {
            XQArray array = (XQArray)item;
            return array;
        }
        throw QueryError.typeError(item, Types.ARRAY, this.info);
    }

    protected final Item checkType(Expr expr, AtomType type, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item.type.isUntyped() ? type.cast(item, qc, this.info) : this.checkType(item, type);
    }

    protected final Item checkType(Item item, Type type) throws QueryException {
        if (item.type.instanceOf(type)) {
            return item;
        }
        throw QueryError.typeError(item, type, this.info);
    }
}

