/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.Intersect;
import org.basex.query.expr.Logical;
import org.basex.query.expr.Union;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.Step;
import org.basex.query.expr.path.Test;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Types;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.Util;

abstract class Set
extends Arr {
    boolean iterative;

    Set(InputInfo info, Expr[] exprs) {
        super(info, Types.NODE_ZM, exprs);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        Expr expr = this.opt(cc);
        if (expr == null) {
            int el = this.exprs.length;
            if (el == 0) {
                return Empty.VALUE;
            }
            if (el == 1) {
                return cc.function(Function.DISTINCT_ORDERED_NODES, this.info, this.exprs[0]);
            }
            expr = this.mergePaths(cc);
            if (expr == null) {
                expr = this.mergeFilters(cc);
            }
        }
        if (expr != null) {
            return cc.replaceWith(this, expr);
        }
        this.iterative = ((Checks<Expr>)Expr::ddo).all((Expr[])this.exprs);
        return this;
    }

    abstract Expr opt(CompileContext var1) throws QueryException;

    @Override
    public final Iter iter(QueryContext qc) throws QueryException {
        return this.iterative ? this.iterate(qc) : this.nodes(qc).iter();
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        return this.iterative ? this.iterate(qc).value(qc, this) : this.nodes(qc);
    }

    final Iter[] iters(QueryContext qc) throws QueryException {
        int el = this.exprs.length;
        Iter[] iters = new Iter[el];
        for (int e = 0; e < el; ++e) {
            iters[e] = this.exprs[e].iter(qc);
        }
        return iters;
    }

    abstract Value nodes(QueryContext var1) throws QueryException;

    abstract Iter iterate(QueryContext var1) throws QueryException;

    private Expr mergePaths(CompileContext cc) throws QueryException {
        Object step;
        Expr root = null;
        Axis axis = null;
        int sl = this.exprs.length;
        ArrayList<Step> steps = new ArrayList<Step>(sl);
        for (Expr expr : this.exprs) {
            Expr expr2;
            if (!(expr instanceof Path)) {
                return null;
            }
            Path path = (Path)expr;
            if (path.steps.length != 1 || !((expr2 = path.steps[0]) instanceof Step)) {
                return null;
            }
            Step step2 = (Step)expr2;
            if (steps.isEmpty()) {
                root = path.root;
                axis = step2.axis;
                if (root != null && root.has(Flag.CNS, Flag.NDT)) {
                    return null;
                }
            } else if (!Objects.equals(root, path.root) || axis != step2.axis) {
                return null;
            }
            if (step2.mayBePositional()) {
                return null;
            }
            steps.add(step2);
        }
        Object[] preds = null;
        ArrayList<Test> tests = new ArrayList<Test>(sl);
        for (int s = 0; s < sl; ++s) {
            Iterator<Test> step3 = (Step)steps.get(s);
            if (preds == null) {
                preds = ((Step)((Object)step3)).exprs;
            } else if (!Arrays.equals(preds, ((Step)((Object)step3)).exprs)) {
                preds = null;
                break;
            }
            tests.add(((Step)((Object)step3)).test);
        }
        Test test = null;
        if (preds != null) {
            if (this instanceof Union) {
                test = Test.get(tests);
            } else if (this instanceof Intersect) {
                for (Test t : tests) {
                    if (test == null || t.instanceOf(test)) {
                        test = t;
                        continue;
                    }
                    if (test.instanceOf(t)) continue;
                    return Empty.VALUE;
                }
            } else {
                for (Test t : tests) {
                    if (test == null) {
                        test = t;
                        continue;
                    }
                    if (!test.instanceOf(t)) continue;
                    return Empty.VALUE;
                }
                test = null;
            }
        }
        if (test == null) {
            for (int s = 0; s < sl; ++s) {
                step = (Step)steps.get(s);
                if (test == null) {
                    test = ((Step)step).test;
                    continue;
                }
                if (test.equals(((Step)step).test)) continue;
                test = null;
                break;
            }
        }
        if (test == null) {
            return null;
        }
        ExprList list = new ExprList(sl);
        for (Step step2 : steps) {
            list.add(this.newPredicate(step2.exprs, cc));
        }
        preds = new Expr[]{cc.get(root, true, () -> this.mergePredicates((Expr[])list.finish(), cc).optimize(cc))};
        step = Step.get(cc, root, this.info, axis, test, (Expr[])preds);
        return Path.get(cc, this.info, root, new Expr[]{step});
    }

    private Expr mergeFilters(CompileContext cc) throws QueryException {
        Expr root = null;
        ExprList list = new ExprList();
        Expr[] exprArray = this.exprs;
        int n = exprArray.length;
        for (int i = 0; i < n; ++i) {
            Expr expr;
            Expr rt = expr = exprArray[i];
            Expr[] preds = new Expr[]{};
            if (expr instanceof Filter) {
                Filter filter = (Filter)expr;
                if (filter.mayBePositional()) {
                    return null;
                }
                rt = filter.root;
                preds = filter.exprs;
            }
            if (root == null ? (root = rt).has(Flag.CNS, Flag.NDT) || !(root.seqType().type instanceof NodeType) : !root.equals(rt)) {
                return null;
            }
            list.add(this.newPredicate(preds, cc));
        }
        Expr pred = this.mergePredicates((Expr[])list.finish(), cc).optimize(cc);
        return Filter.get(cc, this.info, root, pred);
    }

    private Expr newPredicate(Expr[] preds, CompileContext cc) throws QueryException {
        int el = preds.length;
        if (el == 0) {
            return Bln.TRUE;
        }
        if (el == 1) {
            return preds[0];
        }
        return new And(this.info, preds).optimize(cc);
    }

    abstract Logical mergePredicates(Expr[] var1, CompileContext var2) throws QueryException;

    @Override
    public final boolean ddo() {
        return true;
    }

    @Override
    public final void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "iterative", this.iterative), this.exprs);
    }

    @Override
    public final void toString(QueryString qs) {
        qs.tokens(this.exprs, " " + Util.className(this).toLowerCase(Locale.ENGLISH) + " ", true);
    }

    abstract class SetIter
    extends NodeIter {
        private final QueryContext qc;
        final Iter[] iter;
        ANode[] nodes;

        SetIter(QueryContext qc, Iter[] iter) {
            this.qc = qc;
            this.iter = iter;
        }

        final boolean next(int i) throws QueryException {
            Item item = this.qc.next(this.iter[i]);
            if (item == null) {
                this.nodes[i] = null;
                return false;
            }
            this.nodes[i] = Set.this.toNode(item);
            return true;
        }
    }
}

