/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.RuleBasedNumberFormat;
import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.basex.query.util.format.DecFormatOptions;
import org.basex.query.util.format.FormatParser;
import org.basex.query.util.format.Formatter;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjectMap;

public final class IcuFormatter
extends Formatter {
    private static final String ICU_SPELLOUT_PREFIX = "%spellout-";
    private static final String ICU_SPELLOUT_ORDINAL = "%spellout-ordinal";
    private static final String ICU_SPELLOUT_ORDINAL_NEUTER = "%spellout-ordinal-neuter";
    private static final String ICU_SPELLOUT_CARDINAL = "%spellout-cardinal";
    private static final String ICU_SPELLOUT_CARDINAL_NEUTER = "%spellout-cardinal-neuter";
    private static final ThreadLocal<TokenObjectMap<IcuFormatter>> MAP = ThreadLocal.withInitial(() -> {
        TokenObjectMap<IcuFormatter> map = new TokenObjectMap<IcuFormatter>();
        map.put(EN, IcuFormatter.forLanguage(EN));
        return map;
    });
    private final RuleBasedNumberFormat spelloutFormat;
    private final RuleBasedNumberFormat ordinalFormat;
    private final Set<String> ruleSetNames;
    private final TokenObjectMap[] ruleSetByModifierForNumType = new TokenObjectMap[]{new TokenObjectMap(), new TokenObjectMap(), new TokenObjectMap()};
    private final byte[][] months;
    private final byte[][] days;
    private final byte[][] ampm;
    private final byte[][] eras;
    private final Formatter internal;

    private IcuFormatter(RuleBasedNumberFormat s, RuleBasedNumberFormat o, DateFormatSymbols d, Formatter internal) {
        this.spelloutFormat = s;
        this.ordinalFormat = o;
        this.ruleSetNames = new LinkedHashSet<String>(Arrays.asList(this.spelloutFormat.getRuleSetNames()));
        this.internal = internal;
        String[] weekdays = d.getWeekdays();
        this.days = (byte[][])Stream.concat(Arrays.stream(weekdays).skip(2L), Stream.of(weekdays[1])).map(Token::token).toArray(x$0 -> new byte[x$0][]);
        this.months = (byte[][])Arrays.stream(d.getMonths()).map(Token::token).toArray(x$0 -> new byte[x$0][]);
        this.ampm = (byte[][])Arrays.stream(d.getAmPmStrings()).map(Token::token).toArray(x$0 -> new byte[x$0][]);
        this.eras = (byte[][])Arrays.stream(d.getEras()).map(Token::token).toArray(x$0 -> new byte[x$0][]);
    }

    public static IcuFormatter get(byte[] languageTag) {
        IcuFormatter form;
        TokenObjectMap<IcuFormatter> map = MAP.get();
        if (map.contains(languageTag)) {
            form = map.get(languageTag);
        } else {
            form = IcuFormatter.forLanguage(languageTag);
            map.put(languageTag, form);
        }
        return form != null ? form : IcuFormatter.get(EN);
    }

    private static IcuFormatter forLanguage(byte[] languageTag) {
        String tag = Token.string(languageTag);
        if (tag.isBlank()) {
            return null;
        }
        ULocale l = ULocale.forLanguageTag((String)tag);
        String lang = l.getLanguage();
        if (lang.isBlank()) {
            return null;
        }
        RuleBasedNumberFormat s = new RuleBasedNumberFormat(l, 1);
        RuleBasedNumberFormat o = new RuleBasedNumberFormat(l, 2);
        DateFormatSymbols d = new DateFormatSymbols(l);
        return s.getLocale(ULocale.ACTUAL_LOCALE).getLanguage().equals(lang) && o.getLocale(ULocale.ACTUAL_LOCALE).getLanguage().equals(lang) && d.getLocale(ULocale.ACTUAL_LOCALE).getLanguage().equals(lang) ? new IcuFormatter(s, o, d, IcuFormatter.getInternal(languageTag)) : null;
    }

    public static boolean available(byte[] languageTag) {
        IcuFormatter.get(languageTag);
        return MAP.get().get(languageTag) != null;
    }

    @Override
    protected byte[] word(long n, FormatParser.NumeralType numType, byte[] modifier) {
        String formatted = this.spelloutFormat.format(n, this.ruleSet(numType, modifier));
        byte[] result = Token.token(formatted.replace("\u00ad", ""));
        if (!Token.eq(Token.token(this.spelloutFormat.getLocale(ULocale.ACTUAL_LOCALE).getLanguage()), EN)) {
            result[0] = (byte)Token.uc(result[0]);
        } else {
            for (int i = 0; i < result.length; ++i) {
                if (i != 0 && result[i - 1] != 32 && result[i - 1] != 45) continue;
                result[i] = (byte)Token.uc(result[i]);
            }
        }
        return result;
    }

    @Override
    protected byte[] suffix(long n, FormatParser.NumeralType numType) {
        if (numType != FormatParser.NumeralType.ORDINAL) {
            return Token.EMPTY;
        }
        byte[] f = Token.token(this.ordinalFormat.format(n));
        int offset = f.length;
        for (int i = offset - 1; i >= 0; --i) {
            if (f[i] < 48 || f[i] > 57) continue;
            offset = i + 1;
            break;
        }
        return Token.substring(f, offset);
    }

    @Override
    protected byte[] month(int n, int min, int max) {
        return IcuFormatter.format(this.months[n], min, max);
    }

    @Override
    protected byte[] day(int n, int min, int max) {
        if (this.internal != null) {
            return this.internal.day(n, min, max);
        }
        return IcuFormatter.format(this.days[n], min, max);
    }

    @Override
    protected byte[] ampm(boolean am) {
        return this.ampm[am ? 0 : 1];
    }

    @Override
    protected byte[] calendar() {
        return this.eras[1];
    }

    @Override
    protected byte[] era(long year) {
        return this.eras[year <= 0L ? 0 : 1];
    }

    private String ruleSet(FormatParser.NumeralType numType, byte[] modifier) {
        byte[] key;
        TokenObjectMap map = this.ruleSetByModifierForNumType[numType.ordinal()];
        String ruleSet = (String)map.get(key = modifier == null ? Token.EMPTY : modifier);
        if (ruleSet == null) {
            if (modifier != null) {
                if (Token.startsWith(modifier, Token.token(ICU_SPELLOUT_PREFIX))) {
                    ruleSet = this.ruleSet(Token.string(modifier));
                } else {
                    String suffix = Token.string(Token.delete(modifier, 45));
                    for (String r : this.ruleSetNames) {
                        if (!this.spelloutFormat.format(1L, r).endsWith(suffix)) continue;
                        ruleSet = r;
                        break;
                    }
                }
            }
            if (ruleSet == null) {
                ruleSet = this.ruleSet(numType);
            }
            if (ruleSet == null) {
                ruleSet = this.spelloutFormat.getDefaultRuleSetName();
            }
            map.put(key, ruleSet);
        }
        return ruleSet;
    }

    private String ruleSet(String name) {
        if (this.ruleSetNames.contains(name)) {
            return name;
        }
        String ruleSet = null;
        for (String r : this.ruleSetNames) {
            if (!name.startsWith(r) || ruleSet != null && r.length() <= ruleSet.length()) continue;
            ruleSet = r;
        }
        if (ruleSet == null) {
            if (name.startsWith(ICU_SPELLOUT_ORDINAL)) {
                ruleSet = this.ruleSet(FormatParser.NumeralType.ORDINAL);
            } else if (name.startsWith(ICU_SPELLOUT_CARDINAL)) {
                ruleSet = this.ruleSet(FormatParser.NumeralType.CARDINAL);
            }
        }
        return ruleSet;
    }

    private String ruleSet(FormatParser.NumeralType numType) {
        switch (numType) {
            case ORDINAL: {
                if (this.ruleSetNames.contains(ICU_SPELLOUT_ORDINAL)) {
                    return ICU_SPELLOUT_ORDINAL;
                }
                if (this.ruleSetNames.contains(ICU_SPELLOUT_ORDINAL_NEUTER)) {
                    return ICU_SPELLOUT_ORDINAL_NEUTER;
                }
                for (String r : this.ruleSetNames) {
                    if (!r.startsWith(ICU_SPELLOUT_ORDINAL)) continue;
                    return r;
                }
                break;
            }
            case CARDINAL: {
                if (this.ruleSetNames.contains(ICU_SPELLOUT_CARDINAL)) {
                    return ICU_SPELLOUT_CARDINAL;
                }
                if (this.ruleSetNames.contains(ICU_SPELLOUT_CARDINAL_NEUTER)) {
                    return ICU_SPELLOUT_CARDINAL_NEUTER;
                }
                for (String r : this.ruleSetNames) {
                    if (!r.startsWith(ICU_SPELLOUT_CARDINAL)) continue;
                    return r;
                }
                break;
            }
        }
        return null;
    }

    static DecFormatOptions decFormat(String languageTag) {
        ULocale locale = ULocale.forLanguageTag((String)languageTag);
        DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance((ULocale)locale);
        if (dfs.getLocale(ULocale.ACTUAL_LOCALE).toLanguageTag().equals(languageTag)) {
            DecFormatOptions dfo = new DecFormatOptions();
            dfo.put(DecFormatOptions.DECIMAL_SEPARATOR, dfs.getDecimalSeparatorString());
            dfo.put(DecFormatOptions.DIGIT, String.valueOf(dfs.getDigit()));
            dfo.put(DecFormatOptions.GROUPING_SEPARATOR, dfs.getGroupingSeparatorString());
            dfo.put(DecFormatOptions.EXPONENT_SEPARATOR, dfs.getExponentSeparator());
            dfo.put(DecFormatOptions.INFINITY, dfs.getInfinity());
            dfo.put(DecFormatOptions.MINUS_SIGN, dfs.getMinusSignString());
            dfo.put(DecFormatOptions.NAN, dfs.getNaN());
            dfo.put(DecFormatOptions.PATTERN_SEPARATOR, String.valueOf(dfs.getPatternSeparator()));
            dfo.put(DecFormatOptions.PERCENT, dfs.getPercentString());
            dfo.put(DecFormatOptions.PER_MILLE, dfs.getPerMillString());
            dfo.put(DecFormatOptions.ZERO_DIGIT, String.valueOf(dfs.getZeroDigit()));
            return dfo;
        }
        return null;
    }
}

