/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.basex;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQStackTraceElement;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.exception.XQQueryExceptionImpl;

public class BaseXClient {
    static final Charset UTF8 = Charset.forName("UTF-8");
    final Map<String, EventNotifier> notifiers = Collections.synchronizedMap(new HashMap());
    final OutputStream out;
    final Socket socket = new Socket();
    final BufferedInputStream in;
    String info;
    Socket esocket;
    String ehost;
    boolean isClosed = false;
    boolean isReadOnly = false;
    private static final int _document_node = 12;
    private static final int _document_node_element = 13;
    private static final int _attribute = 14;
    private static final int _qname = 82;
    static final Pattern xqePattern = Pattern.compile("^Stopped\\s+at\\s+line\\s+([0-9]*)\\s*,\\s*column\\s+([0-9]*)(\\s+in\\s+([^:]*))?:.+\\[([^]]+)]\\s+(.*)$", 42);
    static final Pattern xqePattern2 = Pattern.compile("^\\[(.+)\\]\\s*(.*)", 42);

    public BaseXClient(String host, int port, String username, String password) throws IOException {
        String nonce;
        Object code;
        this.socket.connect(new InetSocketAddress(host, port), 5000);
        this.in = new BufferedInputStream(this.socket.getInputStream());
        this.out = this.socket.getOutputStream();
        this.ehost = host;
        String[] response = this.receive().split(":");
        if (response.length > 1) {
            code = username + ":" + response[0] + ":" + password;
            nonce = response[1];
        } else {
            code = password;
            nonce = response[0];
        }
        this.send(username);
        this.send(BaseXClient.md5(BaseXClient.md5((String)code) + nonce));
        if (!this.ok()) {
            throw new IOException("Access denied.");
        }
    }

    public void execute(String command, OutputStream output) throws IOException {
        this.send(command);
        BaseXClient.receive(this.in, output);
        this.info = this.receive();
        if (!this.ok()) {
            throw new IOException(this.info);
        }
    }

    public String execute(String command) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.execute(command, os);
        return new String(os.toByteArray(), UTF8);
    }

    public Query query(String query, boolean readOnly) throws IOException, XQException {
        return new Query(query, readOnly);
    }

    public void create(String name, InputStream input) throws IOException {
        this.send(8, name, input);
    }

    public void add(String path, InputStream input) throws IOException {
        this.send(9, path, input);
    }

    public void replace(String path, InputStream input) throws IOException {
        this.send(12, path, input);
    }

    public void store(String path, InputStream input) throws IOException {
        this.send(13, path, input);
    }

    public void watch(String name, EventNotifier notifier) throws IOException {
        this.out.write(10);
        if (this.esocket == null) {
            int eport = Integer.parseInt(this.receive());
            this.esocket = new Socket();
            this.esocket.connect(new InetSocketAddress(this.ehost, eport), 5000);
            OutputStream os = this.esocket.getOutputStream();
            BaseXClient.receive(this.in, os);
            os.write(0);
            os.flush();
            InputStream is = this.esocket.getInputStream();
            is.read();
            this.listen(is);
        }
        this.send(name);
        this.info = this.receive();
        if (!this.ok()) {
            throw new IOException(this.info);
        }
        this.notifiers.put(name, notifier);
    }

    public void unwatch(String name) throws IOException {
        this.out.write(11);
        this.send(name);
        this.info = this.receive();
        if (!this.ok()) {
            throw new IOException(this.info);
        }
        this.notifiers.remove(name);
    }

    public String info() {
        return this.info;
    }

    public void close() throws IOException {
        this.send("exit");
        this.out.flush();
        if (this.esocket != null) {
            this.esocket.close();
        }
        this.socket.close();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private boolean ok() throws IOException {
        this.out.flush();
        return this.in.read() == 0;
    }

    private String receive() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BaseXClient.receive(this.in, os);
        return new String(os.toByteArray(), UTF8);
    }

    private void send(String string) throws IOException {
        this.out.write((string + "\u0000").getBytes(UTF8));
    }

    private static void receive(InputStream input, OutputStream output) throws IOException {
        int b;
        while ((b = input.read()) > 0) {
            output.write(b == 255 ? input.read() : b);
        }
    }

    private void send(int code, String path, InputStream input) throws IOException {
        this.out.write(code);
        this.send(path);
        this.send(input);
    }

    private void listen(InputStream input) {
        final BufferedInputStream bis = new BufferedInputStream(input);
        new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        BaseXClient.receive(bis, baos);
                        String name = new String(baos.toByteArray(), UTF8);
                        baos = new ByteArrayOutputStream();
                        BaseXClient.receive(bis, baos);
                        String data = new String(baos.toByteArray(), UTF8);
                        BaseXClient.this.notifiers.get(name).notify(data);
                    }
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }.start();
    }

    private void send(InputStream input) throws IOException {
        int b;
        BufferedInputStream bis = new BufferedInputStream(input);
        BufferedOutputStream bos = new BufferedOutputStream(this.out);
        while ((b = bis.read()) != -1) {
            if (b == 0 || b == 255) {
                bos.write(255);
            }
            bos.write(b);
        }
        bos.write(0);
        bos.flush();
        this.info = this.receive();
        if (!this.ok()) {
            throw new IOException(this.info);
        }
    }

    private static String md5(String pw) {
        StringBuilder sb = new StringBuilder();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(pw.getBytes());
            byte[] byArray = md.digest();
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                String s = Integer.toHexString(b & 0xFF);
                if (s.length() == 1) {
                    sb.append('0');
                }
                sb.append(s);
                ++n2;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    public static interface EventNotifier {
        public void notify(String var1);
    }

    public class Query {
        private final String id;
        private ArrayList<byte[]> cache;
        private int pos;
        private ArrayList<Byte> xdmtype;
        public static final String _EMPTY_URI = "";
        private String currentUri = "";
        private byte currentXdmType;

        Query(String query, boolean readOnly) throws IOException, XQException {
            this.id = this.exec(0, query);
            if (readOnly && this.updating()) {
                this.close();
                throw new XQExceptionImpl("Can not execute an updating query whilst in read-only mode.", "XQJBX019");
            }
            try {
                this.more();
            }
            catch (IOException e) {
                Matcher matcher = xqePattern.matcher(e.getMessage());
                if (matcher.matches()) {
                    String line = matcher.group(1);
                    String column = matcher.group(2);
                    String module = matcher.group(4);
                    String errCode = matcher.group(5);
                    String errMessage = matcher.group(6);
                    int iLine = Integer.parseInt(line);
                    int iColumn = Integer.parseInt(column);
                    XQStackTraceElement[] xqStackTrace = new XQStackTraceElement[]{new XQStackTraceElement(null, iLine, iColumn, -1, null, null)};
                    XQQueryExceptionImpl xqe = new XQQueryExceptionImpl(errMessage, null, new QName(errCode), iLine, iColumn, -1, module, null, xqStackTrace);
                    throw xqe;
                }
                matcher = xqePattern2.matcher(e.getMessage());
                if (matcher.matches()) {
                    String errCode = matcher.group(1);
                    String message = matcher.group(2);
                    XQExceptionImpl xqe = new XQExceptionImpl(message, errCode);
                    throw xqe;
                }
                XQExceptionImpl xqe = new XQExceptionImpl(e.getMessage(), "BXCE001");
                throw xqe;
            }
        }

        public void bind(String name, String value) throws IOException {
            this.bind(name, value, _EMPTY_URI);
        }

        public void bind(String name, String value, String type) throws IOException {
            this.exec(3, this.id + "\u0000" + name + "\u0000" + value + "\u0000" + type);
        }

        public void context(String value) throws IOException {
            this.context(value, _EMPTY_URI);
        }

        public void context(String value, String type) throws IOException {
            this.exec(14, this.id + "\u0000" + value + "\u0000" + type);
        }

        public boolean more() throws IOException {
            if (this.cache == null) {
                int firstByte;
                BaseXClient.this.out.write(31);
                BaseXClient.this.send(this.id);
                this.cache = new ArrayList();
                this.xdmtype = new ArrayList();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                while ((firstByte = BaseXClient.this.in.read()) > 0) {
                    this.xdmtype.add((byte)firstByte);
                    BaseXClient.receive(BaseXClient.this.in, os);
                    this.cache.add(os.toByteArray());
                    os.reset();
                }
                if (!BaseXClient.this.ok()) {
                    throw new IOException(BaseXClient.this.receive());
                }
            }
            return this.pos < this.cache.size();
        }

        public String next() throws IOException {
            boolean hasURI = false;
            if (this.more()) {
                this.currentXdmType = this.xdmtype.set(this.pos, null);
                switch (this.currentXdmType) {
                    case 12: 
                    case 13: 
                    case 14: 
                    case 82: {
                        hasURI = true;
                    }
                }
                if (hasURI) {
                    byte[] buffer = this.cache.set(this.pos++, null);
                    int i = 0;
                    while (i < buffer.length) {
                        if (buffer[i] == 0) {
                            this.currentUri = i == 0 ? _EMPTY_URI : new String(buffer, 0, i, UTF8);
                            return new String(buffer, i + 1, buffer.length - i - 1, UTF8);
                        }
                        ++i;
                    }
                    throw new IOException("unexpected response from server. XDM type " + this.currentXdmType + " does not include a URI.");
                }
                this.currentUri = _EMPTY_URI;
                return new String((byte[])this.cache.set(this.pos++, null), UTF8);
            }
            return null;
        }

        public String execute() throws IOException {
            return this.exec(5, this.id);
        }

        public String info() throws IOException {
            return this.exec(6, this.id);
        }

        public String options() throws IOException {
            return this.exec(7, this.id);
        }

        public boolean updating() throws IOException {
            return Boolean.parseBoolean(this.exec(30, this.id));
        }

        public void close() throws IOException {
            this.exec(2, this.id);
        }

        private String exec(int code, String arg) throws IOException {
            BaseXClient.this.out.write(code);
            BaseXClient.this.send(arg);
            String s = BaseXClient.this.receive();
            if (!BaseXClient.this.ok()) {
                throw new IOException(BaseXClient.this.receive());
            }
            return s;
        }

        public int xdmType() {
            return this.currentXdmType;
        }

        public String uri() {
            return this.currentUri;
        }
    }
}

