/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.saxtree;

import java.util.LinkedList;
import java.util.List;
import nu.validator.saxtree.CDATA;
import nu.validator.saxtree.Characters;
import nu.validator.saxtree.Comment;
import nu.validator.saxtree.DTD;
import nu.validator.saxtree.Document;
import nu.validator.saxtree.DocumentFragment;
import nu.validator.saxtree.Element;
import nu.validator.saxtree.Entity;
import nu.validator.saxtree.IgnorableWhitespace;
import nu.validator.saxtree.ParentNode;
import nu.validator.saxtree.PrefixMapping;
import nu.validator.saxtree.ProcessingInstruction;
import nu.validator.saxtree.SkippedEntity;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class TreeBuilder
implements ContentHandler,
LexicalHandler {
    private Locator locator;
    private ParentNode current;
    private final boolean retainAttributes;
    private List<PrefixMapping> prefixMappings;

    public TreeBuilder() {
        this(false, false);
    }

    public TreeBuilder(boolean fragment, boolean retainAttributes) {
        if (fragment) {
            this.current = new DocumentFragment();
        }
        this.retainAttributes = retainAttributes;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.current.appendChild(new Characters(this.locator, ch, start, length));
    }

    @Override
    public void endDocument() throws SAXException {
        this.current.setEndLocator(this.locator);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.current.setEndLocator(this.locator);
        this.current = this.current.getParentNode();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.current.appendChild(new IgnorableWhitespace(this.locator, ch, start, length));
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.current.appendChild(new ProcessingInstruction(this.locator, target, data));
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.current.appendChild(new SkippedEntity(this.locator, name));
    }

    @Override
    public void startDocument() throws SAXException {
        this.current = new Document(this.locator);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.current = (ParentNode)this.current.appendChild(new Element(this.locator, uri, localName, qName, atts, this.retainAttributes, this.prefixMappings));
        this.prefixMappings = null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.prefixMappings == null) {
            this.prefixMappings = new LinkedList<PrefixMapping>();
        }
        this.prefixMappings.add(new PrefixMapping(prefix, uri));
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.current.appendChild(new Comment(this.locator, ch, start, length));
    }

    @Override
    public void endCDATA() throws SAXException {
        this.current.setEndLocator(this.locator);
        this.current = this.current.getParentNode();
    }

    @Override
    public void endDTD() throws SAXException {
        this.current.setEndLocator(this.locator);
        this.current = this.current.getParentNode();
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.current.setEndLocator(this.locator);
        this.current = this.current.getParentNode();
    }

    @Override
    public void startCDATA() throws SAXException {
        this.current = (ParentNode)this.current.appendChild(new CDATA(this.locator));
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.current = (ParentNode)this.current.appendChild(new DTD(this.locator, name, publicId, systemId));
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.current = (ParentNode)this.current.appendChild(new Entity(this.locator, name));
    }

    public ParentNode getRoot() {
        return this.current;
    }
}

