/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.jdom;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.compiler.ProcessingInstructionTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.jdom.JDOMAttributeIterator;
import org.apache.commons.jxpath.ri.model.jdom.JDOMNamespaceIterator;
import org.apache.commons.jxpath.ri.model.jdom.JDOMNamespacePointer;
import org.apache.commons.jxpath.ri.model.jdom.JDOMNodeIterator;
import org.apache.commons.jxpath.util.TypeUtils;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class JDOMNodePointer
extends NodePointer {
    private Object node;
    private Map namespaces;
    private String defaultNamespace;
    private String id;
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    static /* synthetic */ Class class$java$lang$String;

    public JDOMNodePointer(Object node, Locale locale) {
        super(null, locale);
        this.node = node;
    }

    public JDOMNodePointer(Object node, Locale locale, String id) {
        super(null, locale);
        this.node = node;
        this.id = id;
    }

    public JDOMNodePointer(NodePointer parent, Object node) {
        super(parent);
        this.node = node;
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        return new JDOMNodeIterator(this, test, reverse, startWith);
    }

    public NodeIterator attributeIterator(QName name) {
        return new JDOMAttributeIterator(this, name);
    }

    public NodeIterator namespaceIterator() {
        return new JDOMNamespaceIterator(this);
    }

    public NodePointer namespacePointer(String prefix) {
        return new JDOMNamespacePointer((NodePointer)this, prefix);
    }

    public String getNamespaceURI() {
        if (this.node instanceof Element) {
            Element element = (Element)this.node;
            String ns = element.getNamespaceURI();
            if (ns != null && ns.equals("")) {
                ns = null;
            }
            return ns;
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        if (this.node instanceof Element) {
            Element element = (Element)this.node;
            Namespace ns = element.getNamespace(prefix);
            if (ns == null) {
                return null;
            }
            return ns.getURI();
        }
        return null;
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        Object node2;
        Object node1 = pointer1.getBaseValue();
        if (node1 == (node2 = pointer2.getBaseValue())) {
            return 0;
        }
        if (node1 instanceof Attribute && !(node2 instanceof Attribute)) {
            return -1;
        }
        if (!(node1 instanceof Attribute) && node2 instanceof Attribute) {
            return 1;
        }
        if (node1 instanceof Attribute && node2 instanceof Attribute) {
            List list = ((Element)this.getNode()).getAttributes();
            int length = list.size();
            int i = 0;
            while (i < length) {
                Object n = list.get(i);
                if (n == node1) {
                    return -1;
                }
                if (n == node2) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
        if (!(this.node instanceof Element)) {
            throw new RuntimeException("JXPath internal error: compareChildNodes called for " + this.node);
        }
        List children = ((Element)this.node).getContent();
        int length = children.size();
        int i = 0;
        while (i < length) {
            Object n = children.get(i);
            if (n == node1) {
                return -1;
            }
            if (n == node2) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public Object getBaseValue() {
        return this.node;
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public boolean isLeaf() {
        if (this.node instanceof Element) {
            return ((Element)this.node).getContent().size() == 0;
        }
        if (this.node instanceof Document) {
            return ((Document)this.node).getContent().size() == 0;
        }
        return true;
    }

    public QName getName() {
        String ns = null;
        String ln = null;
        if (this.node instanceof Element) {
            ns = ((Element)this.node).getNamespacePrefix();
            if (ns != null && ns.equals("")) {
                ns = null;
            }
            ln = ((Element)this.node).getName();
        } else if (this.node instanceof ProcessingInstruction) {
            ln = ((ProcessingInstruction)this.node).getTarget();
        }
        return new QName(ns, ln);
    }

    public QName getExpandedName() {
        return new QName(this.getNamespaceURI(), this.getName().getName());
    }

    public Object getImmediateNode() {
        return this.node;
    }

    public Object getValue() {
        if (this.node instanceof Element) {
            return ((Element)this.node).getTextTrim();
        }
        if (this.node instanceof Comment) {
            String text = ((Comment)this.node).getText();
            if (text != null) {
                text = text.trim();
            }
            return text;
        }
        if (this.node instanceof Text) {
            return ((Text)this.node).getTextTrim();
        }
        if (this.node instanceof CDATA) {
            return ((CDATA)this.node).getTextTrim();
        }
        if (this.node instanceof ProcessingInstruction) {
            String text = ((ProcessingInstruction)this.node).getData();
            if (text != null) {
                text = text.trim();
            }
            return text;
        }
        return null;
    }

    public void setValue(Object value) {
        if (this.node instanceof Text) {
            String string = (String)TypeUtils.convert(value, class$java$lang$String == null ? (class$java$lang$String = JDOMNodePointer.class$("java.lang.String")) : class$java$lang$String);
            if (string != null && !string.equals("")) {
                ((Text)this.node).setText(string);
            } else {
                this.nodeParent(this.node).removeContent((Text)this.node);
            }
        } else {
            Element element = (Element)this.node;
            element.getContent().clear();
            if (value instanceof Element) {
                Element valueElement = (Element)value;
                this.addContent(valueElement.getContent());
            } else if (value instanceof Document) {
                Document valueDocument = (Document)value;
                this.addContent(valueDocument.getContent());
            } else if (value instanceof Text || value instanceof CDATA) {
                String string = ((Text)value).getText();
                element.addContent(new Text(string));
            } else if (value instanceof ProcessingInstruction) {
                ProcessingInstruction pi = (ProcessingInstruction)((ProcessingInstruction)value).clone();
                element.addContent(pi);
            } else if (value instanceof Comment) {
                Comment comment = (Comment)((Comment)value).clone();
                element.addContent(comment);
            } else {
                String string = (String)TypeUtils.convert(value, class$java$lang$String == null ? (class$java$lang$String = JDOMNodePointer.class$("java.lang.String")) : class$java$lang$String);
                if (string != null && !string.equals("")) {
                    element.addContent(new Text(string));
                }
            }
        }
    }

    private void addContent(List content) {
        Element element = (Element)this.node;
        int count = content.size();
        int i = 0;
        while (i < count) {
            Object child = content.get(i);
            if (child instanceof Element) {
                child = ((Element)child).clone();
                element.addContent((Element)child);
            } else if (child instanceof Text) {
                child = ((Text)child).clone();
                element.addContent((Text)child);
            } else if (this.node instanceof CDATA) {
                child = ((CDATA)child).clone();
                element.addContent((CDATA)child);
            } else if (this.node instanceof ProcessingInstruction) {
                child = ((ProcessingInstruction)child).clone();
                element.addContent((ProcessingInstruction)child);
            } else if (this.node instanceof Comment) {
                child = ((Comment)child).clone();
                element.addContent((Comment)child);
            }
            ++i;
        }
    }

    public boolean testNode(NodeTest test) {
        return JDOMNodePointer.testNode(this, this.node, test);
    }

    public static boolean testNode(NodePointer pointer, Object node, NodeTest test) {
        if (test == null) {
            return true;
        }
        if (test instanceof NodeNameTest) {
            if (!(node instanceof Element)) {
                return false;
            }
            QName testName = ((NodeNameTest)test).getNodeName();
            String testLocalName = testName.getName();
            boolean wildcard = testLocalName.equals("*");
            if (wildcard && testName.getPrefix() == null) {
                return true;
            }
            if (wildcard || testLocalName.equals(JDOMNodePointer.getLocalName((Element)node))) {
                String nodePrefix;
                String testPrefix = testName.getPrefix();
                if (JDOMNodePointer.equalStrings(testPrefix, nodePrefix = JDOMNodePointer.getPrefix((Element)node))) {
                    return true;
                }
                String testNS = pointer.getNamespaceURI(testPrefix);
                if (testNS == null) {
                    return false;
                }
                String nodeNS = pointer.getNamespaceURI(nodePrefix);
                return JDOMNodePointer.equalStrings(testNS, nodeNS);
            }
        } else {
            if (test instanceof NodeTypeTest) {
                switch (((NodeTypeTest)test).getNodeType()) {
                    case 1: {
                        return node instanceof Element;
                    }
                    case 2: {
                        return node instanceof Text || node instanceof CDATA;
                    }
                    case 3: {
                        return node instanceof Comment;
                    }
                    case 4: {
                        return node instanceof ProcessingInstruction;
                    }
                }
                return false;
            }
            if (test instanceof ProcessingInstructionTest && node instanceof ProcessingInstruction) {
                String testPI = ((ProcessingInstructionTest)test).getTarget();
                String nodePI = ((ProcessingInstruction)node).getTarget();
                return testPI.equals(nodePI);
            }
        }
        return false;
    }

    private static boolean equalStrings(String s1, String s2) {
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s1 != null && s2 == null) {
            return false;
        }
        return s1 == null || s1.trim().equals(s2.trim());
    }

    public static String getPrefix(Object node) {
        if (node instanceof Element) {
            String prefix = ((Element)node).getNamespacePrefix();
            return prefix == null || prefix.equals("") ? null : prefix;
        }
        if (node instanceof Attribute) {
            String prefix = ((Attribute)node).getNamespacePrefix();
            return prefix == null || prefix.equals("") ? null : prefix;
        }
        return null;
    }

    public static String getLocalName(Object node) {
        if (node instanceof Element) {
            return ((Element)node).getName();
        }
        if (node instanceof Attribute) {
            return ((Attribute)node).getName();
        }
        return null;
    }

    public boolean isLanguage(String lang) {
        String current = this.getLanguage();
        if (current == null) {
            return super.isLanguage(lang);
        }
        return current.toUpperCase().startsWith(lang.toUpperCase());
    }

    protected String getLanguage() {
        Object n = this.node;
        while (n != null) {
            Element e;
            String attr;
            if (n instanceof Element && (attr = (e = (Element)n).getAttributeValue("lang", Namespace.XML_NAMESPACE)) != null && !attr.equals("")) {
                return attr;
            }
            n = this.nodeParent(n);
        }
        return null;
    }

    private Element nodeParent(Object node) {
        if (node instanceof Element) {
            return ((Element)node).getParent();
        }
        if (node instanceof Text) {
            return ((Text)node).getParent();
        }
        if (node instanceof CDATA) {
            return ((CDATA)node).getParent();
        }
        if (node instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)node).getParent();
        }
        if (node instanceof Comment) {
            return ((Comment)node).getParent();
        }
        return null;
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        NodeIterator it;
        boolean success;
        if (index == Integer.MIN_VALUE) {
            index = 0;
        }
        if ((success = this.getAbstractFactory(context).createObject(context, this, this.node, name.toString(), index)) && (it = this.childIterator(new NodeNameTest(name), false, null)) != null && it.setPosition(index + 1)) {
            return it.getNodePointer();
        }
        throw new JXPathException("Factory could not create a child node for path: " + this.asPath() + "/" + name + "[" + (index + 1) + "]");
    }

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        NodePointer ptr = this.createChild(context, name, index);
        ptr.setValue(value);
        return ptr;
    }

    public NodePointer createAttribute(JXPathContext context, QName name) {
        if (!(this.node instanceof Element)) {
            return super.createAttribute(context, name);
        }
        Element element = (Element)this.node;
        String prefix = name.getPrefix();
        if (prefix != null) {
            Namespace ns = element.getNamespace(prefix);
            if (ns == null) {
                throw new JXPathException("Unknown namespace prefix: " + prefix);
            }
            Attribute attr = element.getAttribute(name.getName(), ns);
            if (attr == null) {
                element.setAttribute(name.getName(), "", ns);
            }
        } else {
            Attribute attr = element.getAttribute(name.getName());
            if (attr == null) {
                element.setAttribute(name.getName(), "");
            }
        }
        NodeIterator it = this.attributeIterator(name);
        it.setPosition(1);
        return it.getNodePointer();
    }

    public void remove() {
        Element parent = this.nodeParent(this.node);
        if (parent == null) {
            throw new JXPathException("Cannot remove root JDOM node");
        }
        parent.getContent().remove(this.node);
    }

    public String asPath() {
        if (this.id != null) {
            return "id('" + this.escape(this.id) + "')";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
        }
        if (this.node instanceof Element) {
            if (this.parent instanceof JDOMNodePointer) {
                if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
                    buffer.append('/');
                }
                buffer.append(this.getName());
                buffer.append('[');
                buffer.append(this.getRelativePositionByName());
                buffer.append(']');
            }
        } else if (this.node instanceof Text || this.node instanceof CDATA) {
            buffer.append("/text()");
            buffer.append('[').append(this.getRelativePositionOfTextNode()).append(']');
        } else if (this.node instanceof ProcessingInstruction) {
            String target = ((ProcessingInstruction)this.node).getTarget();
            buffer.append("/processing-instruction('").append(target).append("')");
            buffer.append('[').append(this.getRelativePositionOfPI(target)).append(']');
        }
        return buffer.toString();
    }

    private String escape(String string) {
        int index = string.indexOf(39);
        while (index != -1) {
            string = string.substring(0, index) + "&apos;" + string.substring(index + 1);
            index = string.indexOf(39);
        }
        index = string.indexOf(34);
        while (index != -1) {
            string = string.substring(0, index) + "&quot;" + string.substring(index + 1);
            index = string.indexOf(34);
        }
        return string;
    }

    private int getRelativePositionByName() {
        if (this.node instanceof Element) {
            Element parent = ((Element)this.node).getParent();
            if (parent == null) {
                return 1;
            }
            List children = parent.getContent();
            int count = 0;
            String name = ((Element)this.node).getQualifiedName();
            int i = 0;
            while (i < children.size()) {
                Object child = children.get(i);
                if (child instanceof Element && ((Element)child).getQualifiedName().equals(name)) {
                    ++count;
                }
                if (child == this.node) break;
                ++i;
            }
            return count;
        }
        return 1;
    }

    private int getRelativePositionOfTextNode() {
        Element parent = this.node instanceof Text ? ((Text)this.node).getParent() : ((CDATA)this.node).getParent();
        if (parent == null) {
            return 1;
        }
        List children = parent.getContent();
        int count = 0;
        int i = 0;
        while (i < children.size()) {
            Object child = children.get(i);
            if (child instanceof Text || child instanceof CDATA) {
                ++count;
            }
            if (child == this.node) break;
            ++i;
        }
        return count;
    }

    private int getRelativePositionOfPI(String target) {
        Element parent = ((ProcessingInstruction)this.node).getParent();
        if (parent == null) {
            return 1;
        }
        List children = parent.getContent();
        int count = 0;
        int i = 0;
        while (i < children.size()) {
            Object child = children.get(i);
            if (child instanceof ProcessingInstruction && (target == null || target.equals(((ProcessingInstruction)child).getTarget()))) {
                ++count;
            }
            if (child == this.node) break;
            ++i;
        }
        return count;
    }

    public int hashCode() {
        return System.identityHashCode(this.node);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JDOMNodePointer)) {
            return false;
        }
        JDOMNodePointer other = (JDOMNodePointer)object;
        return this.node == other.node;
    }

    private AbstractFactory getAbstractFactory(JXPathContext context) {
        AbstractFactory factory = context.getFactory();
        if (factory == null) {
            throw new JXPathException("Factory is not set on the JXPathContext - cannot create path: " + this.asPath());
        }
        return factory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

