/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;

public final class ByteBuf
implements Serializable {
    static final long serialVersionUID = -786393456618166871L;
    private byte[] value;
    private int count;

    public ByteBuf() {
        this(16);
    }

    public ByteBuf(int n) {
        this.value = new byte[n];
    }

    public ByteBuf(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    public ByteBuf(byte[] byArray, int n, int n2) {
        this.value = new byte[n2];
        System.arraycopy(byArray, n, this.value, 0, n2);
        this.count = n2;
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public void ensureCapacity(int n) {
        int n2 = this.value.length;
        if (n > n2) {
            int n3 = (n2 + 1) * 2;
            if (n > n3) {
                n3 = n;
            }
            byte[] byArray = new byte[n3];
            System.arraycopy(this.value, 0, byArray, 0, this.count);
            this.value = byArray;
        }
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (this.count < n) {
            this.ensureCapacity(n);
            while (this.count < n) {
                this.value[this.count] = 0;
                ++this.count;
            }
        }
        this.count = n;
    }

    public byte byteAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < n2) {
            System.arraycopy(this.value, n, byArray, n3, n2 - n);
        }
    }

    public void setByteAt(int n, byte by) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.value[n] = by;
    }

    public ByteBuf append(Object object) {
        return this.append(String.valueOf(object));
    }

    public ByteBuf append(String string) {
        if (string == null) {
            string = String.valueOf(string);
        }
        int n = string.length();
        this.ensureCapacity(this.count + n);
        for (int i = 0; i < n; ++i) {
            this.value[this.count++] = (byte)string.charAt(i);
        }
        return this;
    }

    public ByteBuf append(byte[] byArray) {
        int n = byArray.length;
        this.ensureCapacity(this.count + n);
        System.arraycopy(byArray, 0, this.value, this.count, n);
        this.count += n;
        return this;
    }

    public ByteBuf append(byte[] byArray, int n, int n2) {
        this.ensureCapacity(this.count + n2);
        System.arraycopy(byArray, n, this.value, this.count, n2);
        this.count += n2;
        return this;
    }

    public ByteBuf append(ByteBuf byteBuf) {
        this.append(byteBuf.toBytes(), 0, byteBuf.length());
        return this;
    }

    public ByteBuf append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public ByteBuf append(byte by) {
        this.ensureCapacity(this.count + 1);
        this.value[this.count++] = by;
        return this;
    }

    public ByteBuf append(int n) {
        return this.append(String.valueOf(n));
    }

    public ByteBuf append(long l) {
        return this.append(String.valueOf(l));
    }

    public ByteBuf append(float f) {
        return this.append(String.valueOf(f));
    }

    public ByteBuf append(double d) {
        return this.append(String.valueOf(d));
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.value, 0, byArray, 0, this.count);
        return byArray;
    }

    public int read(InputStream inputStream, int n) throws IOException {
        this.ensureCapacity(this.count + n);
        int n2 = inputStream.read(this.value, this.count, n);
        if (n2 > 0) {
            this.count += n2;
        }
        return n2;
    }

    public int read(RandomAccessFile randomAccessFile, int n) throws IOException {
        this.ensureCapacity(this.count + n);
        int n2 = randomAccessFile.read(this.value, this.count, n);
        if (n2 > 0) {
            this.count += n2;
        }
        return n2;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.value, 0, this.count);
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.write(this.value, 0, this.count);
    }
}

