/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler.parser.sax;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.intabulas.sandler.parser.sax.HandlerMulticaster;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAXRecorder
implements ContentHandler {
    private HandlerMulticaster handler = new HandlerMulticaster();
    private List events = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAllEvents() {
        List list = this.events;
        synchronized (list) {
            for (int i = 0; i < this.events.size(); ++i) {
                ((Runnable)this.events.get(i)).run();
            }
        }
    }

    public Iterator eventIterator() {
        return new Iterator(){
            private Iterator events;
            {
                this.events = SAXRecorder.this.events.iterator();
            }

            public boolean hasNext() {
                return this.events != null ? this.events.hasNext() : false;
            }

            public Object next() {
                Event event = (Event)this.events.next();
                try {
                    try {
                        event.run();
                    }
                    catch (SAXException e) {
                        throw new Error("Error traversing recorded SAX event: " + e.getMessage(), e);
                    }
                    Object var4_2 = null;
                    if (!this.events.hasNext()) {
                        this.events = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    if (!this.events.hasNext()) {
                        this.events = null;
                    }
                    throw throwable;
                }
                return null;
            }

            public void remove() {
                throw new UnsupportedOperationException("Remove makes no sense in this context");
            }
        };
    }

    public void addHandler(ContentHandler handler) {
        this.handler.addHandler(handler);
    }

    public boolean removeHandler(ContentHandler handler) {
        return this.handler.removeHandler(handler);
    }

    public void clearEvents() {
        this.events.clear();
    }

    public void clearHandlers() {
        this.handler.clearHandlers();
    }

    public synchronized void reset() {
        this.clearEvents();
        this.clearHandlers();
    }

    public void setDocumentLocator(final Locator locator) {
        this.events.add(new Event(){

            public void run() {
                SAXRecorder.this.handler.setDocumentLocator(locator);
            }
        });
    }

    public void startDocument() throws SAXException {
        this.events.add(new Event(){

            public void run() throws SAXException {
                SAXRecorder.this.handler.startDocument();
            }
        });
    }

    public void endDocument() throws SAXException {
        this.events.add(new Event(){

            public void run() throws SAXException {
                SAXRecorder.this.handler.endDocument();
            }
        });
    }

    public void startPrefixMapping(final String prefix, final String uri) throws SAXException {
        this.events.add(new Event(){

            public void run() throws SAXException {
                SAXRecorder.this.handler.startPrefixMapping(prefix, uri);
            }
        });
    }

    public void endPrefixMapping(final String prefix) throws SAXException {
        this.events.add(new Event(){

            public void run() throws SAXException {
                SAXRecorder.this.handler.endPrefixMapping(prefix);
            }
        });
    }

    public void startElement(final String uri, final String localName, final String qName, Attributes atts) throws SAXException {
        final AttributesImpl att = new AttributesImpl(atts);
        this.events.add(new Event(){

            public void run() throws SAXException {
                SAXRecorder.this.handler.startElement(uri, localName, qName, att);
            }
        });
    }

    public void endElement(final String uri, final String localName, final String qName) throws SAXException {
        this.events.add(new Event(){

            public void run() throws SAXException {
                SAXRecorder.this.handler.endElement(uri, localName, qName);
            }
        });
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        final char[] chars = new char[ch.length];
        System.arraycopy(ch, 0, chars, 0, ch.length);
        this.events.add(new Event(){

            public void run() throws SAXException {
                SAXRecorder.this.handler.characters(chars, 0, chars.length);
            }
        });
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        final char[] chars = new char[ch.length];
        System.arraycopy(ch, 0, chars, 0, ch.length);
        this.events.add(new Event(){

            public void run() throws SAXException {
                SAXRecorder.this.handler.ignorableWhitespace(chars, 0, chars.length);
            }
        });
    }

    public void processingInstruction(final String target, final String data) throws SAXException {
        this.events.add(new Event(){

            public void run() throws SAXException {
                SAXRecorder.this.handler.processingInstruction(target, data);
            }
        });
    }

    public void skippedEntity(final String name) throws SAXException {
        this.events.add(new Event(){

            public void run() throws SAXException {
                SAXRecorder.this.handler.skippedEntity(name);
            }
        });
    }

    private static interface Event {
        public void run() throws SAXException;
    }
}

