/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Binding;
import groovy.lang.CompilerConfig;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.Script;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.syntax.SyntaxException;

public class GroovyShell
extends GroovyObjectSupport {
    public static final String[] EMPTY_ARGS = new String[0];
    private GroovyClassLoader loader;
    private Binding context;
    private int counter;

    public static void main(String[] args) {
        MetaClass.setUseReflection(true);
        int length = args.length;
        if (length <= 0) {
            System.out.println("Usage: Groovy groovyScript [arguments]");
            return;
        }
        String scriptName = args[0];
        String[] newArgs = new String[length - 1];
        if (length > 1) {
            System.arraycopy(args, 1, newArgs, 0, length - 1);
        }
        try {
            GroovyShell groovy = new GroovyShell();
            groovy.run(new File(scriptName), newArgs);
        }
        catch (Exception e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
        }
    }

    public GroovyShell() {
        this(null, new Binding());
    }

    public GroovyShell(Binding binding) {
        this(null, binding);
    }

    public GroovyShell(Binding binding, CompilerConfig config) {
        this(null, binding, config);
    }

    public GroovyShell(ClassLoader parent, Binding binding) {
        this(parent, binding, new CompilerConfig());
    }

    public GroovyShell(ClassLoader parent, Binding binding, CompilerConfig config) {
        if (parent == null && (parent = Thread.currentThread().getContextClassLoader()) == null) {
            parent = GroovyShell.class.getClassLoader();
        }
        this.loader = new GroovyClassLoader(parent, config);
        this.context = binding;
    }

    public GroovyShell(GroovyShell shell) {
        this.loader = new GroovyClassLoader(shell.loader);
        this.context = shell.context;
    }

    public Binding getContext() {
        return this.context;
    }

    public Object getProperty(String property) {
        Object answer = this.getVariable(property);
        if (answer == null) {
            answer = super.getProperty(property);
        }
        return answer;
    }

    public void setProperty(String property, Object newValue) {
        this.setVariable(property, newValue);
        try {
            super.setProperty(property, newValue);
        }
        catch (GroovyRuntimeException groovyRuntimeException) {
            // empty catch block
        }
    }

    public void run(File scriptFile, List list) throws ClassNotFoundException, SyntaxException, IOException {
        String[] args = new String[list.size()];
        list.toArray(args);
        this.run(scriptFile, args);
    }

    public void run(File scriptFile, String[] args) throws ClassNotFoundException, SyntaxException, IOException {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        Class scriptClass = this.loader.parseClass(scriptFile);
        InvokerHelper.invokeMethod(scriptClass, "main", new Object[]{args});
        thread.setContextClassLoader(currentClassLoader);
    }

    public void run(String scriptText, String fileName, String[] args) throws ClassNotFoundException, SyntaxException, IOException {
        this.run(new ByteArrayInputStream(scriptText.getBytes()), fileName, args);
    }

    public Object run(InputStream in, String fileName, String[] args) throws ClassNotFoundException, SyntaxException, IOException {
        Class scriptClass = this.loader.parseClass(in, fileName);
        return InvokerHelper.invokeMethod(scriptClass, "main", new Object[]{args});
    }

    public Object getVariable(String name) {
        return this.context.getVariable(name);
    }

    public void setVariable(String name, Object value) {
        this.context.setVariable(name, value);
    }

    public Object evaluate(String scriptText, String fileName) throws SyntaxException, ClassNotFoundException, IOException {
        return this.evaluate(new ByteArrayInputStream(scriptText.getBytes()), fileName);
    }

    public Object evaluate(File file) throws SyntaxException, ClassNotFoundException, IOException {
        return this.evaluate(new FileInputStream(file), file.getName());
    }

    public Object evaluate(String scriptText) throws SyntaxException, ClassNotFoundException, IOException {
        return this.evaluate(new ByteArrayInputStream(scriptText.getBytes()), this.generateScriptName());
    }

    public Object evaluate(InputStream in) throws SyntaxException, ClassNotFoundException, IOException {
        return this.evaluate(in, this.generateScriptName());
    }

    public Object evaluate(InputStream in, String fileName) throws SyntaxException, ClassNotFoundException, IOException {
        Script script = this.parse(in, fileName);
        return script.run();
    }

    public Script parse(InputStream in, String fileName) throws SyntaxException, ClassNotFoundException, IOException {
        Class scriptClass = this.loader.parseClass(in, fileName);
        return InvokerHelper.createScript(scriptClass, this.context);
    }

    public Script parse(String scriptText, String fileName) throws SyntaxException, ClassNotFoundException, IOException {
        return this.parse(new ByteArrayInputStream(scriptText.getBytes()), fileName);
    }

    public Script parse(File file) throws SyntaxException, ClassNotFoundException, IOException {
        return this.parse(new FileInputStream(file), file.getName());
    }

    public Script parse(String scriptText) throws SyntaxException, ClassNotFoundException, IOException {
        return this.parse(new ByteArrayInputStream(scriptText.getBytes()), this.generateScriptName());
    }

    public Script parse(InputStream in) throws SyntaxException, ClassNotFoundException, IOException {
        return this.parse(in, this.generateScriptName());
    }

    protected synchronized String generateScriptName() {
        return "Script" + ++this.counter + ".groovy";
    }
}

