/*
 * Decompiled with CFR 0.152.
 */
package groovy.sql;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.sql.DataSet;
import groovy.sql.GroovyResultSet;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;

public class Sql {
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private DataSource dataSource;
    private Connection useConnection;
    private boolean warned;

    public static Sql newInstance(String url) throws SQLException {
        Connection connection = DriverManager.getConnection(url);
        return new Sql(connection);
    }

    public static Sql newInstance(String url, Properties properties) throws SQLException {
        Connection connection = DriverManager.getConnection(url, properties);
        return new Sql(connection);
    }

    public static Sql newInstance(String url, Properties properties, String driverClassName) throws SQLException, ClassNotFoundException {
        Sql.loadDriver(driverClassName);
        return Sql.newInstance(url, properties);
    }

    public static Sql newInstance(String url, String user, String password) throws SQLException {
        Connection connection = DriverManager.getConnection(url, user, password);
        return new Sql(connection);
    }

    public static Sql newInstance(String url, String user, String password, String driverClassName) throws SQLException, ClassNotFoundException {
        Sql.loadDriver(driverClassName);
        return Sql.newInstance(url, user, password);
    }

    public static Sql newInstance(String url, String driverClassName) throws SQLException, ClassNotFoundException {
        Sql.loadDriver(driverClassName);
        return Sql.newInstance(url);
    }

    public static void loadDriver(String driverClassName) throws ClassNotFoundException {
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass(driverClassName);
            }
            catch (ClassNotFoundException e2) {
                try {
                    Sql.class.getClassLoader().loadClass(driverClassName);
                }
                catch (ClassNotFoundException e3) {
                    throw e;
                }
            }
        }
    }

    public Sql(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Sql(Connection connection) {
        if (connection == null) {
            throw new NullPointerException("Must specify a non-null Connection");
        }
        this.useConnection = connection;
    }

    public Sql(Sql parent) {
        this.dataSource = parent.dataSource;
        this.useConnection = parent.useConnection;
    }

    public DataSet dataSet(String table) {
        return new DataSet(this, table);
    }

    public DataSet dataSet(Class type) {
        return new DataSet(this, type);
    }

    public void query(String sql, Closure closure) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = connection.createStatement();
        ResultSet results = null;
        try {
            this.log.fine(sql);
            results = statement.executeQuery(sql);
            closure.call(results);
            this.closeResources(connection, statement, results);
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.WARNING, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, results);
                throw throwable;
            }
        }
    }

    public void query(String sql, List params, Closure closure) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        ResultSet results = null;
        try {
            this.log.fine(sql);
            statement = connection.prepareStatement(sql);
            this.setParameters(params, statement);
            results = statement.executeQuery();
            closure.call(results);
            this.closeResources(connection, statement, results);
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.WARNING, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, results);
                throw throwable;
            }
        }
    }

    public void query(GString gstring, Closure closure) throws SQLException {
        String sql = this.asSql(gstring);
        List params = this.getParameters(gstring);
        this.query(sql, params, closure);
    }

    public void queryEach(String sql, Closure closure) throws SQLException {
        this.warnDeprecated();
        this.eachRow(sql, closure);
    }

    public void eachRow(String sql, Closure closure) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = connection.createStatement();
        ResultSet results = null;
        try {
            this.log.fine(sql);
            results = statement.executeQuery(sql);
            GroovyResultSet groovyRS = new GroovyResultSet(results);
            while (groovyRS.next()) {
                closure.call(groovyRS);
            }
            this.closeResources(connection, statement, results);
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.WARNING, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, results);
                throw throwable;
            }
        }
    }

    public void queryEach(String sql, List params, Closure closure) throws SQLException {
        this.warnDeprecated();
        this.eachRow(sql, params, closure);
    }

    public void eachRow(String sql, List params, Closure closure) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        ResultSet results = null;
        try {
            this.log.fine(sql);
            statement = connection.prepareStatement(sql);
            this.setParameters(params, statement);
            results = statement.executeQuery();
            GroovyResultSet groovyRS = new GroovyResultSet(results);
            while (groovyRS.next()) {
                closure.call(groovyRS);
            }
            this.closeResources(connection, statement, results);
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.WARNING, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, results);
                throw throwable;
            }
        }
    }

    public void eachRow(GString gstring, Closure closure) throws SQLException {
        String sql = this.asSql(gstring);
        List params = this.getParameters(gstring);
        this.eachRow(sql, params, closure);
    }

    public void queryEach(GString gstring, Closure closure) throws SQLException {
        this.warnDeprecated();
        this.eachRow(gstring, closure);
    }

    public boolean execute(String sql) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = null;
        try {
            this.log.fine(sql);
            statement = connection.createStatement();
            boolean bl = statement.execute(sql);
            this.closeResources(connection, statement);
            return bl;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.WARNING, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = null;
        try {
            this.log.fine(sql);
            statement = connection.createStatement();
            int n = statement.executeUpdate(sql);
            this.closeResources(connection, statement);
            return n;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.WARNING, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public boolean execute(String sql, List params) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        try {
            this.log.fine(sql);
            statement = connection.prepareStatement(sql);
            this.setParameters(params, statement);
            boolean bl = statement.execute();
            this.closeResources(connection, statement);
            return bl;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.WARNING, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public int executeUpdate(String sql, List params) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        try {
            this.log.fine(sql);
            statement = connection.prepareStatement(sql);
            this.setParameters(params, statement);
            int n = statement.executeUpdate();
            this.closeResources(connection, statement);
            return n;
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.WARNING, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public boolean execute(GString gstring) throws SQLException {
        String sql = this.asSql(gstring);
        List params = this.getParameters(gstring);
        return this.execute(sql, params);
    }

    public int executeUpdate(GString gstring) throws SQLException {
        String sql = this.asSql(gstring);
        List params = this.getParameters(gstring);
        return this.executeUpdate(sql, params);
    }

    public int call(String sql) throws Exception {
        return this.call(sql, Collections.EMPTY_LIST);
    }

    public int call(String sql, List params) throws Exception {
        Connection connection = this.createConnection();
        CallableStatement statement = connection.prepareCall(sql);
        try {
            this.log.fine(sql);
            this.setParameters(params, statement);
            int n = statement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            this.log.log(Level.WARNING, "Failed to execute: " + sql, e);
            throw e;
        }
        finally {
            this.closeResources(connection, statement);
        }
    }

    public int call(GString gstring) throws Exception {
        String sql = this.asSql(gstring);
        List params = this.getParameters(gstring);
        return this.call(sql, params);
    }

    public void close() throws SQLException {
        if (this.useConnection != null) {
            this.useConnection.close();
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected String asSql(GString gstring) {
        boolean nulls = false;
        String[] strings = gstring.getStrings();
        if (strings.length <= 0) {
            throw new IllegalArgumentException("No SQL specified in GString: " + gstring);
        }
        Object[] values = gstring.getValues();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < strings.length; ++i) {
            buffer.append(strings[i]);
            if (i >= values.length) continue;
            if (values[i] != null) {
                buffer.append("?");
                continue;
            }
            nulls = true;
            buffer.append("?'\"?");
        }
        String sql = buffer.toString();
        if (nulls) {
            sql = this.nullify(sql);
        }
        return sql;
    }

    protected String nullify(String sql) {
        int firstWhere = this.findWhereKeyword(sql);
        if (firstWhere >= 0) {
            Pattern[] patterns = new Pattern[]{Pattern.compile("(?is)^(.{" + firstWhere + "}.*?)!=\\s{0,1}(\\s*)\\?'\"\\?(.*)"), Pattern.compile("(?is)^(.{" + firstWhere + "}.*?)<>\\s{0,1}(\\s*)\\?'\"\\?(.*)"), Pattern.compile("(?is)^(.{" + firstWhere + "}.*?[^<>])=\\s{0,1}(\\s*)\\?'\"\\?(.*)")};
            String[] replacements = new String[]{"$1 is not $2null$3", "$1 is not $2null$3", "$1 is $2null$3"};
            for (int i = 0; i < patterns.length; ++i) {
                Matcher matcher = patterns[i].matcher(sql);
                while (matcher.matches()) {
                    sql = matcher.replaceAll(replacements[i]);
                    matcher = patterns[i].matcher(sql);
                }
            }
        }
        return sql.replaceAll("\\?'\"\\?", "null");
    }

    protected int findWhereKeyword(String sql) {
        char[] chars = sql.toLowerCase().toCharArray();
        char[] whereChars = "where".toCharArray();
        boolean inString = false;
        boolean noWhere = true;
        int inWhere = 0;
        block3: for (int i = 0; i < chars.length && noWhere; ++i) {
            switch (chars[i]) {
                case '\'': {
                    if (inString) {
                        inString = false;
                        continue block3;
                    }
                    inString = true;
                    continue block3;
                }
                default: {
                    if (inString || chars[i] != whereChars[inWhere] || ++inWhere != whereChars.length) continue block3;
                    return i;
                }
            }
        }
        return -1;
    }

    protected List getParameters(GString gstring) {
        Object[] values = gstring.getValues();
        ArrayList<Object> answer = new ArrayList<Object>(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            answer.add(values[i]);
        }
        return answer;
    }

    protected void setParameters(List params, PreparedStatement statement) throws SQLException {
        int i = 1;
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            Object value = iter.next();
            this.setObject(statement, i++, value);
        }
    }

    protected void setObject(PreparedStatement statement, int i, Object value) throws SQLException {
        statement.setObject(i, value);
    }

    protected Connection createConnection() throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource.getConnection();
        }
        return this.useConnection;
    }

    protected void closeResources(Connection connection, Statement statement, ResultSet results) {
        if (results != null) {
            try {
                results.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "Caught exception closing resultSet: " + e, e);
            }
        }
        this.closeResources(connection, statement);
    }

    protected void closeResources(Connection connection, Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "Caught exception closing statement: " + e, e);
            }
        }
        if (this.dataSource != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "Caught exception closing connection: " + e, e);
            }
        }
    }

    private void warnDeprecated() {
        if (!this.warned) {
            this.warned = true;
            this.log.warning("queryEach() is deprecated, please use eachRow() instead");
        }
    }
}

