/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public class StaticMethodCallExpression
extends Expression {
    private String type;
    private String method;
    private Expression arguments;

    public StaticMethodCallExpression(String type, String method, Expression arguments) {
        this.type = type;
        this.method = method;
        this.arguments = arguments;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitStaticMethodCallExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return new StaticMethodCallExpression(this.type, this.method, transformer.transform(this.arguments));
    }

    public Expression getArguments() {
        return this.arguments;
    }

    public String getType() {
        return this.type;
    }

    public String getMethod() {
        return this.method;
    }

    public String getText() {
        return this.type + "." + this.method + this.arguments.getText();
    }

    public String toString() {
        return super.toString() + "[type: " + this.type + " method: " + this.method + " arguments: " + this.arguments + "]";
    }
}

