/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Token {
    public static final int NEWLINE = 5;
    public static final int LEFT_CURLY_BRACE = 10;
    public static final int RIGHT_CURLY_BRACE = 20;
    public static final int LEFT_SQUARE_BRACKET = 30;
    public static final int RIGHT_SQUARE_BRACKET = 40;
    public static final int LEFT_PARENTHESIS = 50;
    public static final int RIGHT_PARENTHESIS = 60;
    public static final int DOT = 70;
    public static final int DOT_DOT = 75;
    public static final int DOT_DOT_DOT = 77;
    public static final int NOT = 80;
    public static final int COMPARE_NOT_EQUAL = 90;
    public static final int EQUAL = 100;
    public static final int FIND_REGEX = 105;
    public static final int MATCH_REGEX = 106;
    public static final int PATTERN_REGEX = 107;
    public static final int COMPARE_IDENTICAL = 110;
    public static final int COMPARE_EQUAL = 115;
    public static final int COMPARE_LESS_THAN = 120;
    public static final int COMPARE_LESS_THAN_EQUAL = 130;
    public static final int COMPARE_GREATER_THAN = 140;
    public static final int COMPARE_GREATER_THAN_EQUAL = 150;
    public static final int COMPARE_TO = 155;
    public static final int NAVIGATE = 158;
    public static final int LOGICAL_OR = 160;
    public static final int LOGICAL_AND = 170;
    public static final int PLUS = 180;
    public static final int PLUS_PLUS = 190;
    public static final int PLUS_EQUAL = 200;
    public static final int MINUS = 210;
    public static final int MINUS_MINUS = 220;
    public static final int MINUS_EQUAL = 230;
    public static final int DIVIDE = 240;
    public static final int DIVIDE_EQUAL = 250;
    public static final int MOD = 260;
    public static final int MOD_EQUAL = 270;
    public static final int MULTIPLY = 280;
    public static final int MULTIPLY_EQUAL = 290;
    public static final int COMMA = 295;
    public static final int COLON = 300;
    public static final int SEMICOLON = 301;
    public static final int QUESTION = 310;
    public static final int PIPE = 315;
    public static final int LEFT_SHIFT = 317;
    public static final int RIGHT_SHIFT = 318;
    public static final int DOUBLE_QUOTE_STRING = 320;
    public static final int SINGLE_QUOTE_STRING = 330;
    public static final int IDENTIFIER = 340;
    public static final int INTEGER_NUMBER = 350;
    public static final int FLOAT_NUMBER = 351;
    public static final int KEYWORD_ABSTRACT = 501;
    public static final int KEYWORD_AS = 502;
    public static final int KEYWORD_BREAK = 503;
    public static final int KEYWORD_CASE = 504;
    public static final int KEYWORD_CATCH = 505;
    public static final int KEYWORD_CLASS = 506;
    public static final int KEYWORD_CONST = 507;
    public static final int KEYWORD_CONTINUE = 508;
    public static final int KEYWORD_DEFAULT = 509;
    public static final int KEYWORD_DO = 510;
    public static final int KEYWORD_ELSE = 511;
    public static final int KEYWORD_EXTENDS = 512;
    public static final int KEYWORD_FINAL = 513;
    public static final int KEYWORD_FINALLY = 514;
    public static final int KEYWORD_FOR = 515;
    public static final int KEYWORD_GOTO = 516;
    public static final int KEYWORD_IF = 517;
    public static final int KEYWORD_IMPLEMENTS = 518;
    public static final int KEYWORD_IMPORT = 519;
    public static final int KEYWORD_INSTANCEOF = 520;
    public static final int KEYWORD_INTERFACE = 521;
    public static final int KEYWORD_NATIVE = 522;
    public static final int KEYWORD_NEW = 523;
    public static final int KEYWORD_PACKAGE = 524;
    public static final int KEYWORD_PRIVATE = 525;
    public static final int KEYWORD_PROTECTED = 526;
    public static final int KEYWORD_PUBLIC = 527;
    public static final int KEYWORD_RETURN = 528;
    public static final int KEYWORD_STATIC = 529;
    public static final int KEYWORD_SUPER = 530;
    public static final int KEYWORD_SWITCH = 531;
    public static final int KEYWORD_SYNCHRONIZED = 532;
    public static final int KEYWORD_THIS = 533;
    public static final int KEYWORD_THROW = 534;
    public static final int KEYWORD_THROWS = 535;
    public static final int KEYWORD_TRY = 536;
    public static final int KEYWORD_WHILE = 537;
    public static final int KEYWORD_PROPERTY = 538;
    public static final int KEYWORD_TRUE = 539;
    public static final int KEYWORD_FALSE = 540;
    public static final int KEYWORD_ASSERT = 541;
    public static final int KEYWORD_NULL = 542;
    public static final int KEYWORD_VOID = 543;
    public static final int KEYWORD_INT = 544;
    public static final int KEYWORD_FLOAT = 545;
    public static final int KEYWORD_DOUBLE = 546;
    public static final int KEYWORD_CHAR = 547;
    public static final int KEYWORD_BYTE = 548;
    public static final int KEYWORD_LONG = 549;
    public static final int KEYWORD_SHORT = 550;
    public static final int KEYWORD_BOOLEAN = 551;
    public static final int KEYWORD_DEF = 560;
    public static final int KEYWORD_TRANSIENT = 570;
    public static final int KEYWORD_VOLATILE = 571;
    public static final int KEYWORD_IN = 572;
    public static final int SYNTH_METHOD = 800;
    public static final int SYNTH_PARAMETER_DECLARATION = 801;
    public static final int SYNTH_LIST = 802;
    public static final int SYNTH_MAP = 803;
    public static final int SYNTH_POSTFIX = 810;
    public static final int SYNTH_PREFIX = 811;
    public static final int SYNTH_CAST = 815;
    public static final int SYNTH_BLOCK = 816;
    public static final int SYNTH_CLOSURE = 817;
    public static final int SYNTH_LABEL = 818;
    private static final Map KEYWORDS = new HashMap();
    private static final Map TOKEN_DESCRIPTIONS;
    private int type;
    private int interpretation;
    private String text;
    private int startLine;
    private int startColumn;

    private static void addKeyword(String text, int type) {
        KEYWORDS.put(text, new Integer(type));
    }

    public static Map getKeywordMap() {
        return KEYWORDS;
    }

    private static void addTokenDescription(int type, String description) {
        Token.addTokenDescription(new Integer(type), description);
    }

    private static void addTokenDescription(Integer type, String description) {
        if (description.startsWith("<") && description.endsWith(">")) {
            TOKEN_DESCRIPTIONS.put(type, description);
        } else {
            TOKEN_DESCRIPTIONS.put(type, '\"' + description + '\"');
        }
    }

    public static Token newToken(int type, int startLine, int startColumn) {
        return new Token(type, Token.getTokenDescription(type), startLine, startColumn);
    }

    public static String getTokenDescription(int type) {
        Integer typeKey = new Integer(type);
        if (TOKEN_DESCRIPTIONS.containsKey(typeKey)) {
            return (String)TOKEN_DESCRIPTIONS.get(typeKey);
        }
        return "<unknown>";
    }

    protected Token(int type, String text, int startLine, int startColumn) {
        this.type = type;
        this.interpretation = type;
        this.text = text;
        this.startLine = startLine;
        this.startColumn = startColumn;
    }

    public int getType() {
        return this.type;
    }

    public int getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(int type) {
        this.interpretation = type;
    }

    public String getText() {
        return this.text;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public String getDescription() {
        return Token.getTokenDescription(this.getType());
    }

    public String toString() {
        return "[Token (" + this.getDescription() + "): text=" + this.text + ",type=" + this.type + ",interpretation=" + this.interpretation + "]";
    }

    public static Token newline(int startLine, int startColumn) {
        return Token.newToken(5, "<newline>", startLine, startColumn);
    }

    public static Token leftCurlyBrace(int startLine, int startColumn) {
        return Token.newToken(10, "{", startLine, startColumn);
    }

    public static Token rightCurlyBrace(int startLine, int startColumn) {
        return Token.newToken(20, "}", startLine, startColumn);
    }

    public static Token leftSquareBracket(int startLine, int startColumn) {
        return Token.newToken(30, "[", startLine, startColumn);
    }

    public static Token rightSquareBracket(int startLine, int startColumn) {
        return Token.newToken(40, "]", startLine, startColumn);
    }

    public static Token leftParenthesis(int startLine, int startColumn) {
        return Token.newToken(50, "(", startLine, startColumn);
    }

    public static Token rightParenthesis(int startLine, int startColumn) {
        return Token.newToken(60, ")", startLine, startColumn);
    }

    public static Token dot(int startLine, int startColumn) {
        return Token.newToken(70, ".", startLine, startColumn);
    }

    public static Token dotDot(int startLine, int startColumn) {
        return Token.newToken(75, "..", startLine, startColumn);
    }

    public static Token dotDotDot(int startLine, int startColumn) {
        return Token.newToken(77, "...", startLine, startColumn);
    }

    public static Token not(int startLine, int startColumn) {
        return Token.newToken(80, "!", startLine, startColumn);
    }

    public static Token compareNotEqual(int startLine, int startColumn) {
        return Token.newToken(90, "!=", startLine, startColumn);
    }

    public static Token findRegex(int startLine, int startColumn) {
        return Token.newToken(105, "~=", startLine, startColumn);
    }

    public static Token matchRegex(int startLine, int startColumn) {
        return Token.newToken(106, "~==", startLine, startColumn);
    }

    public static Token equal(int startLine, int startColumn) {
        return Token.newToken(100, "=", startLine, startColumn);
    }

    public static Token compareIdentical(int startLine, int startColumn) {
        return Token.newToken(110, "===", startLine, startColumn);
    }

    public static Token compareEqual(int startLine, int startColumn) {
        return Token.newToken(115, "==", startLine, startColumn);
    }

    public static Token compareLessThan(int startLine, int startColumn) {
        return Token.newToken(120, "<", startLine, startColumn);
    }

    public static Token compareLessThanEqual(int startLine, int startColumn) {
        return Token.newToken(130, "<=", startLine, startColumn);
    }

    public static Token compareGreaterThan(int startLine, int startColumn) {
        return Token.newToken(140, ">", startLine, startColumn);
    }

    public static Token compareGreaterThanEqual(int startLine, int startColumn) {
        return Token.newToken(150, ">=", startLine, startColumn);
    }

    public static Token compareTo(int startLine, int startColumn) {
        return Token.newToken(155, "<=>", startLine, startColumn);
    }

    public static Token navigate(int startLine, int startColumn) {
        return Token.newToken(158, "->", startLine, startColumn);
    }

    public static Token logicalOr(int startLine, int startColumn) {
        return Token.newToken(160, "||", startLine, startColumn);
    }

    public static Token logicalAnd(int startLine, int startColumn) {
        return Token.newToken(170, "&&", startLine, startColumn);
    }

    public static Token plus(int startLine, int startColumn) {
        return Token.newToken(180, "+", startLine, startColumn);
    }

    public static Token plusPlus(int startLine, int startColumn) {
        return Token.newToken(190, "++", startLine, startColumn);
    }

    public static Token plusEqual(int startLine, int startColumn) {
        return Token.newToken(200, "+=", startLine, startColumn);
    }

    public static Token minus(int startLine, int startColumn) {
        return Token.newToken(210, "-", startLine, startColumn);
    }

    public static Token minusMinus(int startLine, int startColumn) {
        return Token.newToken(220, "--", startLine, startColumn);
    }

    public static Token minusEqual(int startLine, int startColumn) {
        return Token.newToken(230, "-=", startLine, startColumn);
    }

    public static Token divide(int startLine, int startColumn) {
        return Token.newToken(240, "/", startLine, startColumn);
    }

    public static Token divideEqual(int startLine, int startColumn) {
        return Token.newToken(250, "/=", startLine, startColumn);
    }

    public static Token mod(int startLine, int startColumn) {
        return Token.newToken(260, "%", startLine, startColumn);
    }

    public static Token modEqual(int startLine, int startColumn) {
        return Token.newToken(270, "%=", startLine, startColumn);
    }

    public static Token multiply(int startLine, int startColumn) {
        return Token.newToken(280, "*", startLine, startColumn);
    }

    public static Token multiplyEqual(int startLine, int startColumn) {
        return Token.newToken(290, "*=", startLine, startColumn);
    }

    public static Token comma(int startLine, int startColumn) {
        return Token.newToken(295, ",", startLine, startColumn);
    }

    public static Token colon(int startLine, int startColumn) {
        return Token.newToken(300, ":", startLine, startColumn);
    }

    public static Token semicolon(int startLine, int startColumn) {
        return Token.newToken(301, ";", startLine, startColumn);
    }

    public static Token question(int startLine, int startColumn) {
        return Token.newToken(310, "?", startLine, startColumn);
    }

    public static Token pipe(int startLine, int startColumn) {
        return Token.newToken(315, "|", startLine, startColumn);
    }

    public static Token leftShift(int startLine, int startColumn) {
        return Token.newToken(317, "<<", startLine, startColumn);
    }

    public static Token rightShift(int startLine, int startColumn) {
        return Token.newToken(318, ">>", startLine, startColumn);
    }

    public static Token doubleQuoteString(int startLine, int startColumn, String text) {
        return Token.newToken(320, text, startLine, startColumn);
    }

    public static Token patternRegex(int startLine, int startColumn) {
        return Token.newToken(107, startLine, startColumn);
    }

    public static Token singleQuoteString(int startLine, int startColumn, String text) {
        return Token.newToken(330, text, startLine, startColumn);
    }

    public static Token identifier(int startLine, int startColumn, String text) {
        return Token.newToken(340, text, startLine, startColumn);
    }

    public static Token keyword(int startLine, int startColumn, String text) {
        if (KEYWORDS.containsKey(text)) {
            return Token.newToken((Integer)KEYWORDS.get(text), text, startLine, startColumn);
        }
        return null;
    }

    public static Token integerNumber(int startLine, int startColumn, String text) {
        return Token.newToken(350, text, startLine, startColumn);
    }

    public static Token floatNumber(int startLine, int startColumn, String text) {
        return Token.newToken(351, text, startLine, startColumn);
    }

    public static Token syntheticMethod() {
        return Token.newToken(800, "<synthetic>", -1, -1);
    }

    public static Token syntheticParameterDeclaration() {
        return Token.newToken(801, "<synthetic>", -1, -1);
    }

    public static Token syntheticMap() {
        return Token.newToken(803, "<synthetic>", -1, -1);
    }

    public static Token syntheticList() {
        return Token.newToken(802, "<synthetic>", -1, -1);
    }

    public static Token syntheticPostfix() {
        return Token.newToken(810, "<synthetic>", -1, -1);
    }

    public static Token syntheticPrefix() {
        return Token.newToken(811, "<synthetic>", -1, -1);
    }

    public static Token syntheticCast() {
        return Token.newToken(815, "<synthetic>", -1, -1);
    }

    public static Token syntheticBlock() {
        return Token.newToken(815, "<synthetic>", -1, -1);
    }

    public static Token syntheticClosure() {
        return Token.newToken(815, "<synthetic>", -1, -1);
    }

    public Token toIdentifier() {
        if (this.type == 340) {
            return this;
        }
        return Token.identifier(this.startLine, this.startColumn, this.text);
    }

    protected static Token newToken(int type, String text, int startLine, int startColumn) {
        return new Token(type, text, startLine, startColumn);
    }

    public boolean isA(int type) {
        return this.type == type;
    }

    public boolean isA(int[] types) {
        return Token.ofType(this.type, types);
    }

    public boolean isAssignmentToken() {
        return Token.isAssignmentToken(this.type);
    }

    public boolean isPrimitiveTypeKeyword(boolean evenVoid) {
        return Token.isPrimitiveTypeKeyword(this.type, evenVoid);
    }

    public boolean isIdentifierOrPrimitiveTypeKeyword() {
        return Token.isIdentifierOrPrimitiveTypeKeyword(this.type);
    }

    public boolean isValidNameReference() {
        return Token.isValidNameReference(this.type);
    }

    public boolean isModifier() {
        return Token.isModifier(this.type);
    }

    public static boolean ofType(int type, int[] types) {
        boolean ofType = false;
        for (int i = 0; i < types.length; ++i) {
            if (type != types[i]) continue;
            ofType = true;
            break;
        }
        return ofType;
    }

    public static boolean isPrimitiveTypeKeyword(int type, boolean evenVoid) {
        boolean is = false;
        switch (type) {
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: {
                is = true;
                break;
            }
            case 543: {
                if (!evenVoid) break;
                is = true;
            }
        }
        return is;
    }

    public static boolean isIdentifierOrPrimitiveTypeKeyword(int type) {
        return type == 340 || Token.isPrimitiveTypeKeyword(type, false);
    }

    public static boolean isValidNameReference(int type) {
        switch (type) {
            case 340: 
            case 506: 
            case 521: 
            case 560: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignmentToken(int type) {
        switch (type) {
            case 100: 
            case 200: 
            case 230: 
            case 250: 
            case 270: 
            case 290: {
                return true;
            }
        }
        return false;
    }

    public static boolean isModifier(int type) {
        boolean modifier = false;
        switch (type) {
            case 501: 
            case 513: 
            case 525: 
            case 526: 
            case 527: 
            case 529: 
            case 532: 
            case 570: 
            case 571: {
                modifier = true;
            }
        }
        return modifier;
    }

    static {
        Token.addKeyword("abstract", 501);
        Token.addKeyword("as", 502);
        Token.addKeyword("assert", 541);
        Token.addKeyword("break", 503);
        Token.addKeyword("case", 504);
        Token.addKeyword("catch", 505);
        Token.addKeyword("class", 506);
        Token.addKeyword("const", 507);
        Token.addKeyword("continue", 508);
        Token.addKeyword("def", 560);
        Token.addKeyword("default", 509);
        Token.addKeyword("do", 510);
        Token.addKeyword("else", 511);
        Token.addKeyword("extends", 512);
        Token.addKeyword("final", 513);
        Token.addKeyword("finally", 514);
        Token.addKeyword("for", 515);
        Token.addKeyword("goto", 516);
        Token.addKeyword("if", 517);
        Token.addKeyword("implements", 518);
        Token.addKeyword("import", 519);
        Token.addKeyword("instanceof", 520);
        Token.addKeyword("interface", 521);
        Token.addKeyword("native", 522);
        Token.addKeyword("new", 523);
        Token.addKeyword("package", 524);
        Token.addKeyword("private", 525);
        Token.addKeyword("property", 538);
        Token.addKeyword("protected", 526);
        Token.addKeyword("public", 527);
        Token.addKeyword("return", 528);
        Token.addKeyword("static", 529);
        Token.addKeyword("super", 530);
        Token.addKeyword("switch", 531);
        Token.addKeyword("synchronized", 532);
        Token.addKeyword("this", 533);
        Token.addKeyword("throw", 534);
        Token.addKeyword("throws", 535);
        Token.addKeyword("transient", 570);
        Token.addKeyword("try", 536);
        Token.addKeyword("volatile", 571);
        Token.addKeyword("while", 537);
        Token.addKeyword("true", 539);
        Token.addKeyword("false", 540);
        Token.addKeyword("null", 542);
        Token.addKeyword("void", 543);
        Token.addKeyword("int", 544);
        Token.addKeyword("float", 545);
        Token.addKeyword("double", 546);
        Token.addKeyword("short", 550);
        Token.addKeyword("boolean", 551);
        Token.addKeyword("char", 547);
        Token.addKeyword("byte", 548);
        Token.addKeyword("long", 549);
        TOKEN_DESCRIPTIONS = new HashMap();
        Iterator keywordIter = KEYWORDS.keySet().iterator();
        while (keywordIter.hasNext()) {
            String keyword = (String)keywordIter.next();
            Integer typeKey = (Integer)KEYWORDS.get(keyword);
            Token.addTokenDescription(typeKey, keyword);
        }
        Token.addTokenDescription(5, "<newline>");
        Token.addTokenDescription(10, "{");
        Token.addTokenDescription(20, "}");
        Token.addTokenDescription(30, "[");
        Token.addTokenDescription(40, "]");
        Token.addTokenDescription(50, "(");
        Token.addTokenDescription(60, ")");
        Token.addTokenDescription(70, ".");
        Token.addTokenDescription(75, "..");
        Token.addTokenDescription(80, "!");
        Token.addTokenDescription(90, "!=");
        Token.addTokenDescription(100, "=");
        Token.addTokenDescription(105, "~=");
        Token.addTokenDescription(106, "~==");
        Token.addTokenDescription(107, "~");
        Token.addTokenDescription(115, "==");
        Token.addTokenDescription(110, "===");
        Token.addTokenDescription(120, "<");
        Token.addTokenDescription(130, "<=");
        Token.addTokenDescription(140, ">");
        Token.addTokenDescription(150, ">=");
        Token.addTokenDescription(160, "||");
        Token.addTokenDescription(170, "&&");
        Token.addTokenDescription(180, "+");
        Token.addTokenDescription(190, "++");
        Token.addTokenDescription(200, "+=");
        Token.addTokenDescription(210, "-");
        Token.addTokenDescription(220, "--");
        Token.addTokenDescription(230, "-=");
        Token.addTokenDescription(240, "/");
        Token.addTokenDescription(250, "/=");
        Token.addTokenDescription(260, "%");
        Token.addTokenDescription(270, "%=");
        Token.addTokenDescription(280, "*");
        Token.addTokenDescription(290, "*=");
        Token.addTokenDescription(295, ",");
        Token.addTokenDescription(300, ":");
        Token.addTokenDescription(301, ";");
        Token.addTokenDescription(310, "?");
        Token.addTokenDescription(315, "|");
        Token.addTokenDescription(317, "<<");
        Token.addTokenDescription(318, ">>");
        Token.addTokenDescription(320, "<string literal>");
        Token.addTokenDescription(330, "<string literal>");
        Token.addTokenDescription(340, "<identifier>");
        Token.addTokenDescription(350, "<number>");
        Token.addTokenDescription(351, "<number>");
        Token.addTokenDescription(350, "<number>");
    }
}

