/**
 * Copyright (c) 2003-2005, David A. Czarnecki
 * All rights reserved.
 *
 * Portions Copyright (c) 2003-2005 by Mark Lussier
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * Neither the name of the "David A. Czarnecki" and "blojsom" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "blojsom",
 * nor may "blojsom" appear in their name, without prior written permission of
 * David A. Czarnecki.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.blojsom.plugin.comment.event;

import org.blojsom.blog.BlogComment;
import org.blojsom.blog.BlogUser;
import org.blojsom.plugin.admin.event.BlogEntryEvent;

import java.util.Date;

/**
 * Comment Event indicates an event dealing with a {@link BlogComment}.
 *
 * @author Mark Lussier
 * @version $Id: CommentEvent.java,v 1.1 2005/01/30 19:27:45 czarneckid Exp $
 * @since blojsom 2.23
 */
public class CommentEvent extends BlogEntryEvent {

    protected BlogComment _blogComment;

    /**
     * Create a new event indicating something happened with a {@link BlogComment} in the system.
     *
     * @param source      Source of the event
     * @param timestamp   Event timestamp
     * @param blogComment {@link org.blojsom.blog.BlogComment}
     * @param blogUser    {@link org.blojsom.blog.BlogUser}
     */
    public CommentEvent(Object source, Date timestamp, BlogComment blogComment, BlogUser blogUser) {
        super(source, timestamp, blogComment.getBlogEntry(), blogUser);

        _blogComment = blogComment;
    }

    /**
     * Retrieve the {@link BlogComment} associated with the event
     *
     * @return {@link BlogComment}
     */
    public BlogComment getBlogComment() {
        return _blogComment;
    }

}
