USING: alien.syntax windows.types classes.struct math alien.c-types
math.bitwise kernel locals windows.kernel32 literals ;
IN: windows.directx.d3d9types

TYPEDEF: DWORD D3DCOLOR

STRUCT: D3DVECTOR
    { x FLOAT }
    { y FLOAT }
    { z FLOAT } ;

STRUCT: D3DCOLORVALUE
    { r FLOAT }
    { g FLOAT }
    { b FLOAT }
    { a FLOAT } ;

STRUCT: D3DRECT
    { x1 LONG }
    { y1 LONG }
    { x2 LONG }
    { y2 LONG } ;

STRUCT: D3DMATRIX
    { m FLOAT[4][4] } ;

STRUCT: D3DVIEWPORT9
    { X            DWORD }
    { Y            DWORD }
    { Width        DWORD }
    { Height       DWORD }
    { MinZ         FLOAT }
    { MaxZ         FLOAT } ;

CONSTANT: D3DMAXUSERCLIPPLANES 32

CONSTANT: D3DCLIPPLANE0 1
CONSTANT: D3DCLIPPLANE1 2
CONSTANT: D3DCLIPPLANE2 4
CONSTANT: D3DCLIPPLANE3 8
CONSTANT: D3DCLIPPLANE4 16
CONSTANT: D3DCLIPPLANE5 32

CONSTANT: D3DCS_LEFT        0x00000001
CONSTANT: D3DCS_RIGHT       0x00000002
CONSTANT: D3DCS_TOP         0x00000004
CONSTANT: D3DCS_BOTTOM      0x00000008
CONSTANT: D3DCS_FRONT       0x00000010
CONSTANT: D3DCS_BACK        0x00000020
CONSTANT: D3DCS_PLANE0      0x00000040
CONSTANT: D3DCS_PLANE1      0x00000080
CONSTANT: D3DCS_PLANE2      0x00000100
CONSTANT: D3DCS_PLANE3      0x00000200
CONSTANT: D3DCS_PLANE4      0x00000400
CONSTANT: D3DCS_PLANE5      0x00000800

CONSTANT: D3DCS_ALL
    flags{
        D3DCS_LEFT
        D3DCS_RIGHT
        D3DCS_TOP
        D3DCS_BOTTOM
        D3DCS_FRONT
        D3DCS_BACK
        D3DCS_PLANE0
        D3DCS_PLANE1
        D3DCS_PLANE2
        D3DCS_PLANE3
        D3DCS_PLANE4
        D3DCS_PLANE5
    }

STRUCT: D3DCLIPSTATUS9
    { ClipUnion        DWORD }
    { ClipIntersection DWORD } ;

STRUCT: D3DMATERIAL9
    { Diffuse         D3DCOLORVALUE }
    { Ambient         D3DCOLORVALUE }
    { Specular        D3DCOLORVALUE }
    { Emissive        D3DCOLORVALUE }
    { Power           FLOAT         } ;

TYPEDEF: int D3DLIGHTTYPE
CONSTANT: D3DLIGHT_POINT          1
CONSTANT: D3DLIGHT_SPOT           2
CONSTANT: D3DLIGHT_DIRECTIONAL    3
CONSTANT: D3DLIGHT_FORCE_DWORD    0x7fffffff

STRUCT: D3DLIGHT9
    { Type                   D3DLIGHTTYPE  }
    { Diffuse                D3DCOLORVALUE }
    { Specular               D3DCOLORVALUE }
    { Ambient                D3DCOLORVALUE }
    { Position               D3DVECTOR     }
    { Direction              D3DVECTOR     }
    { Range                  FLOAT         }
    { Falloff                FLOAT         }
    { Attenuation0           FLOAT         }
    { Attenuation1           FLOAT         }
    { Attenuation2           FLOAT         }
    { Theta                  FLOAT         }
    { Phi                    FLOAT         } ;

CONSTANT: D3DCLEAR_TARGET            0x00000001
CONSTANT: D3DCLEAR_ZBUFFER           0x00000002
CONSTANT: D3DCLEAR_STENCIL           0x00000004

TYPEDEF: int D3DSHADEMODE
CONSTANT: D3DSHADE_FLAT               1
CONSTANT: D3DSHADE_GOURAUD            2
CONSTANT: D3DSHADE_PHONG              3
CONSTANT: D3DSHADE_FORCE_DWORD        0x7fffffff

TYPEDEF: int D3DFILLMODE
CONSTANT: D3DFILL_POINT               1
CONSTANT: D3DFILL_WIREFRAME           2
CONSTANT: D3DFILL_SOLID               3
CONSTANT: D3DFILL_FORCE_DWORD         0x7fffffff

TYPEDEF: int D3DBLEND
CONSTANT: D3DBLEND_ZERO               1
CONSTANT: D3DBLEND_ONE                2
CONSTANT: D3DBLEND_SRCCOLOR           3
CONSTANT: D3DBLEND_INVSRCCOLOR        4
CONSTANT: D3DBLEND_SRCALPHA           5
CONSTANT: D3DBLEND_INVSRCALPHA        6
CONSTANT: D3DBLEND_DESTALPHA          7
CONSTANT: D3DBLEND_INVDESTALPHA       8
CONSTANT: D3DBLEND_DESTCOLOR          9
CONSTANT: D3DBLEND_INVDESTCOLOR       10
CONSTANT: D3DBLEND_SRCALPHASAT        11
CONSTANT: D3DBLEND_BOTHSRCALPHA       12
CONSTANT: D3DBLEND_BOTHINVSRCALPHA    13
CONSTANT: D3DBLEND_BLENDFACTOR        14
CONSTANT: D3DBLEND_INVBLENDFACTOR     15
CONSTANT: D3DBLEND_SRCCOLOR2          16
CONSTANT: D3DBLEND_INVSRCCOLOR2       17
CONSTANT: D3DBLEND_FORCE_DWORD        0x7fffffff

TYPEDEF: int D3DBLENDOP
CONSTANT: D3DBLENDOP_ADD              1
CONSTANT: D3DBLENDOP_SUBTRACT         2
CONSTANT: D3DBLENDOP_REVSUBTRACT      3
CONSTANT: D3DBLENDOP_MIN              4
CONSTANT: D3DBLENDOP_MAX              5
CONSTANT: D3DBLENDOP_FORCE_DWORD      0x7fffffff

TYPEDEF: int D3DTEXTUREADDRESS
CONSTANT: D3DTADDRESS_WRAP            1
CONSTANT: D3DTADDRESS_MIRROR          2
CONSTANT: D3DTADDRESS_CLAMP           3
CONSTANT: D3DTADDRESS_BORDER          4
CONSTANT: D3DTADDRESS_MIRRORONCE      5
CONSTANT: D3DTADDRESS_FORCE_DWORD     0x7fffffff

TYPEDEF: int D3DCULL
CONSTANT: D3DCULL_NONE                1
CONSTANT: D3DCULL_CW                  2
CONSTANT: D3DCULL_CCW                 3
CONSTANT: D3DCULL_FORCE_DWORD         0x7fffffff

TYPEDEF: int D3DCMPFUNC
CONSTANT: D3DCMP_NEVER                1
CONSTANT: D3DCMP_LESS                 2
CONSTANT: D3DCMP_EQUAL                3
CONSTANT: D3DCMP_LESSEQUAL            4
CONSTANT: D3DCMP_GREATER              5
CONSTANT: D3DCMP_NOTEQUAL             6
CONSTANT: D3DCMP_GREATEREQUAL         7
CONSTANT: D3DCMP_ALWAYS               8
CONSTANT: D3DCMP_FORCE_DWORD          0x7fffffff

TYPEDEF: int D3DSTENCILOP
CONSTANT: D3DSTENCILOP_KEEP           1
CONSTANT: D3DSTENCILOP_ZERO           2
CONSTANT: D3DSTENCILOP_REPLACE        3
CONSTANT: D3DSTENCILOP_INCRSAT        4
CONSTANT: D3DSTENCILOP_DECRSAT        5
CONSTANT: D3DSTENCILOP_INVERT         6
CONSTANT: D3DSTENCILOP_INCR           7
CONSTANT: D3DSTENCILOP_DECR           8
CONSTANT: D3DSTENCILOP_FORCE_DWORD    0x7fffffff

TYPEDEF: int D3DFOGMODE
CONSTANT: D3DFOG_NONE                 0
CONSTANT: D3DFOG_EXP                  1
CONSTANT: D3DFOG_EXP2                 2
CONSTANT: D3DFOG_LINEAR               3
CONSTANT: D3DFOG_FORCE_DWORD          0x7fffffff

TYPEDEF: int D3DZBUFFERTYPE
CONSTANT: D3DZB_FALSE                 0
CONSTANT: D3DZB_TRUE                  1
CONSTANT: D3DZB_USEW                  2
CONSTANT: D3DZB_FORCE_DWORD           0x7fffffff

TYPEDEF: int D3DPRIMITIVETYPE
CONSTANT: D3DPT_POINTLIST             1
CONSTANT: D3DPT_LINELIST              2
CONSTANT: D3DPT_LINESTRIP             3
CONSTANT: D3DPT_TRIANGLELIST          4
CONSTANT: D3DPT_TRIANGLESTRIP         5
CONSTANT: D3DPT_TRIANGLEFAN           6
CONSTANT: D3DPT_FORCE_DWORD           0x7fffffff

TYPEDEF: int D3DTRANSFORMSTATETYPE
CONSTANT: D3DTS_VIEW          2
CONSTANT: D3DTS_PROJECTION    3
CONSTANT: D3DTS_TEXTURE0      16
CONSTANT: D3DTS_TEXTURE1      17
CONSTANT: D3DTS_TEXTURE2      18
CONSTANT: D3DTS_TEXTURE3      19
CONSTANT: D3DTS_TEXTURE4      20
CONSTANT: D3DTS_TEXTURE5      21
CONSTANT: D3DTS_TEXTURE6      22
CONSTANT: D3DTS_TEXTURE7      23
CONSTANT: D3DTS_FORCE_DWORD   0x7fffffff

TYPEDEF: int D3DRENDERSTATETYPE
CONSTANT: D3DRS_ZENABLE                   7
CONSTANT: D3DRS_FILLMODE                  8
CONSTANT: D3DRS_SHADEMODE                 9
CONSTANT: D3DRS_ZWRITEENABLE              14
CONSTANT: D3DRS_ALPHATESTENABLE           15
CONSTANT: D3DRS_LASTPIXEL                 16
CONSTANT: D3DRS_SRCBLEND                  19
CONSTANT: D3DRS_DESTBLEND                 20
CONSTANT: D3DRS_CULLMODE                  22
CONSTANT: D3DRS_ZFUNC                     23
CONSTANT: D3DRS_ALPHAREF                  24
CONSTANT: D3DRS_ALPHAFUNC                 25
CONSTANT: D3DRS_DITHERENABLE              26
CONSTANT: D3DRS_ALPHABLENDENABLE          27
CONSTANT: D3DRS_FOGENABLE                 28
CONSTANT: D3DRS_SPECULARENABLE            29
CONSTANT: D3DRS_FOGCOLOR                  34
CONSTANT: D3DRS_FOGTABLEMODE              35
CONSTANT: D3DRS_FOGSTART                  36
CONSTANT: D3DRS_FOGEND                    37
CONSTANT: D3DRS_FOGDENSITY                38
CONSTANT: D3DRS_RANGEFOGENABLE            48
CONSTANT: D3DRS_STENCILENABLE             52
CONSTANT: D3DRS_STENCILFAIL               53
CONSTANT: D3DRS_STENCILZFAIL              54
CONSTANT: D3DRS_STENCILPASS               55
CONSTANT: D3DRS_STENCILFUNC               56
CONSTANT: D3DRS_STENCILREF                57
CONSTANT: D3DRS_STENCILMASK               58
CONSTANT: D3DRS_STENCILWRITEMASK          59
CONSTANT: D3DRS_TEXTUREFACTOR             60
CONSTANT: D3DRS_WRAP0                     128
CONSTANT: D3DRS_WRAP1                     129
CONSTANT: D3DRS_WRAP2                     130
CONSTANT: D3DRS_WRAP3                     131
CONSTANT: D3DRS_WRAP4                     132
CONSTANT: D3DRS_WRAP5                     133
CONSTANT: D3DRS_WRAP6                     134
CONSTANT: D3DRS_WRAP7                     135
CONSTANT: D3DRS_CLIPPING                  136
CONSTANT: D3DRS_LIGHTING                  137
CONSTANT: D3DRS_AMBIENT                   139
CONSTANT: D3DRS_FOGVERTEXMODE             140
CONSTANT: D3DRS_COLORVERTEX               141
CONSTANT: D3DRS_LOCALVIEWER               142
CONSTANT: D3DRS_NORMALIZENORMALS          143
CONSTANT: D3DRS_DIFFUSEMATERIALSOURCE     145
CONSTANT: D3DRS_SPECULARMATERIALSOURCE    146
CONSTANT: D3DRS_AMBIENTMATERIALSOURCE     147
CONSTANT: D3DRS_EMISSIVEMATERIALSOURCE    148
CONSTANT: D3DRS_VERTEXBLEND               151
CONSTANT: D3DRS_CLIPPLANEENABLE           152
CONSTANT: D3DRS_POINTSIZE                 154
CONSTANT: D3DRS_POINTSIZE_MIN             155
CONSTANT: D3DRS_POINTSPRITEENABLE         156
CONSTANT: D3DRS_POINTSCALEENABLE          157
CONSTANT: D3DRS_POINTSCALE_A              158
CONSTANT: D3DRS_POINTSCALE_B              159
CONSTANT: D3DRS_POINTSCALE_C              160
CONSTANT: D3DRS_MULTISAMPLEANTIALIAS      161
CONSTANT: D3DRS_MULTISAMPLEMASK           162
CONSTANT: D3DRS_PATCHEDGESTYLE            163
CONSTANT: D3DRS_DEBUGMONITORTOKEN         165
CONSTANT: D3DRS_POINTSIZE_MAX             166
CONSTANT: D3DRS_INDEXEDVERTEXBLENDENABLE  167
CONSTANT: D3DRS_COLORWRITEENABLE          168
CONSTANT: D3DRS_TWEENFACTOR               170
CONSTANT: D3DRS_BLENDOP                   171
CONSTANT: D3DRS_POSITIONDEGREE            172
CONSTANT: D3DRS_NORMALDEGREE              173
CONSTANT: D3DRS_SCISSORTESTENABLE         174
CONSTANT: D3DRS_SLOPESCALEDEPTHBIAS       175
CONSTANT: D3DRS_ANTIALIASEDLINEENABLE     176
CONSTANT: D3DRS_MINTESSELLATIONLEVEL      178
CONSTANT: D3DRS_MAXTESSELLATIONLEVEL      179
CONSTANT: D3DRS_ADAPTIVETESS_X            180
CONSTANT: D3DRS_ADAPTIVETESS_Y            181
CONSTANT: D3DRS_ADAPTIVETESS_Z            182
CONSTANT: D3DRS_ADAPTIVETESS_W            183
CONSTANT: D3DRS_ENABLEADAPTIVETESSELLATION 184
CONSTANT: D3DRS_TWOSIDEDSTENCILMODE       185
CONSTANT: D3DRS_CCW_STENCILFAIL           186
CONSTANT: D3DRS_CCW_STENCILZFAIL          187
CONSTANT: D3DRS_CCW_STENCILPASS           188
CONSTANT: D3DRS_CCW_STENCILFUNC           189
CONSTANT: D3DRS_COLORWRITEENABLE1         190
CONSTANT: D3DRS_COLORWRITEENABLE2         191
CONSTANT: D3DRS_COLORWRITEENABLE3         192
CONSTANT: D3DRS_BLENDFACTOR               193
CONSTANT: D3DRS_SRGBWRITEENABLE           194
CONSTANT: D3DRS_DEPTHBIAS                 195
CONSTANT: D3DRS_WRAP8                     198
CONSTANT: D3DRS_WRAP9                     199
CONSTANT: D3DRS_WRAP10                    200
CONSTANT: D3DRS_WRAP11                    201
CONSTANT: D3DRS_WRAP12                    202
CONSTANT: D3DRS_WRAP13                    203
CONSTANT: D3DRS_WRAP14                    204
CONSTANT: D3DRS_WRAP15                    205
CONSTANT: D3DRS_SEPARATEALPHABLENDENABLE  206
CONSTANT: D3DRS_SRCBLENDALPHA             207
CONSTANT: D3DRS_DESTBLENDALPHA            208
CONSTANT: D3DRS_BLENDOPALPHA              209
CONSTANT: D3DRS_FORCE_DWORD               0x7fffffff

CONSTANT: D3D_MAX_SIMULTANEOUS_RENDERTARGETS 4

TYPEDEF: int D3DMATERIALCOLORSOURCE
CONSTANT: D3DMCS_MATERIAL         0
CONSTANT: D3DMCS_COLOR1           1
CONSTANT: D3DMCS_COLOR2           2
CONSTANT: D3DMCS_FORCE_DWORD      0x7fffffff

CONSTANT: D3DRENDERSTATE_WRAPBIAS                 128

CONSTANT: D3DWRAP_U   0x00000001
CONSTANT: D3DWRAP_V   0x00000002
CONSTANT: D3DWRAP_W   0x00000004

CONSTANT: D3DWRAPCOORD_0   0x00000001
CONSTANT: D3DWRAPCOORD_1   0x00000002
CONSTANT: D3DWRAPCOORD_2   0x00000004
CONSTANT: D3DWRAPCOORD_3   0x00000008

CONSTANT: D3DCOLORWRITEENABLE_RED     1
CONSTANT: D3DCOLORWRITEENABLE_GREEN   2
CONSTANT: D3DCOLORWRITEENABLE_BLUE    4
CONSTANT: D3DCOLORWRITEENABLE_ALPHA   8

TYPEDEF: int D3DTEXTURESTAGESTATETYPE
CONSTANT: D3DTSS_COLOROP        1
CONSTANT: D3DTSS_COLORARG1      2
CONSTANT: D3DTSS_COLORARG2      3
CONSTANT: D3DTSS_ALPHAOP        4
CONSTANT: D3DTSS_ALPHAARG1      5
CONSTANT: D3DTSS_ALPHAARG2      6
CONSTANT: D3DTSS_BUMPENVMAT00   7
CONSTANT: D3DTSS_BUMPENVMAT01   8
CONSTANT: D3DTSS_BUMPENVMAT10   9
CONSTANT: D3DTSS_BUMPENVMAT11   10
CONSTANT: D3DTSS_TEXCOORDINDEX  11
CONSTANT: D3DTSS_BUMPENVLSCALE  22
CONSTANT: D3DTSS_BUMPENVLOFFSET 23
CONSTANT: D3DTSS_TEXTURETRANSFORMFLAGS 24
CONSTANT: D3DTSS_COLORARG0      26
CONSTANT: D3DTSS_ALPHAARG0      27
CONSTANT: D3DTSS_RESULTARG      28
CONSTANT: D3DTSS_CONSTANT       32
CONSTANT: D3DTSS_FORCE_DWORD   0x7fffffff

TYPEDEF: int D3DSAMPLERSTATETYPE
CONSTANT: D3DSAMP_ADDRESSU       1
CONSTANT: D3DSAMP_ADDRESSV       2
CONSTANT: D3DSAMP_ADDRESSW       3
CONSTANT: D3DSAMP_BORDERCOLOR    4
CONSTANT: D3DSAMP_MAGFILTER      5
CONSTANT: D3DSAMP_MINFILTER      6
CONSTANT: D3DSAMP_MIPFILTER      7
CONSTANT: D3DSAMP_MIPMAPLODBIAS  8
CONSTANT: D3DSAMP_MAXMIPLEVEL    9
CONSTANT: D3DSAMP_MAXANISOTROPY  10
CONSTANT: D3DSAMP_SRGBTEXTURE    11
CONSTANT: D3DSAMP_ELEMENTINDEX   12
CONSTANT: D3DSAMP_DMAPOFFSET     13
CONSTANT: D3DSAMP_FORCE_DWORD   0x7fffffff

CONSTANT: D3DDMAPSAMPLER 256

CONSTANT: D3DVERTEXTEXTURESAMPLER0 257
CONSTANT: D3DVERTEXTEXTURESAMPLER1 258
CONSTANT: D3DVERTEXTEXTURESAMPLER2 259
CONSTANT: D3DVERTEXTEXTURESAMPLER3 260

CONSTANT: D3DTSS_TCI_PASSTHRU                             0x00000000
CONSTANT: D3DTSS_TCI_CAMERASPACENORMAL                    0x00010000
CONSTANT: D3DTSS_TCI_CAMERASPACEPOSITION                  0x00020000
CONSTANT: D3DTSS_TCI_CAMERASPACEREFLECTIONVECTOR          0x00030000
CONSTANT: D3DTSS_TCI_SPHEREMAP                            0x00040000

TYPEDEF: int D3DTEXTUREOP
CONSTANT: D3DTOP_DISABLE              1
CONSTANT: D3DTOP_SELECTARG1           2
CONSTANT: D3DTOP_SELECTARG2           3
CONSTANT: D3DTOP_MODULATE             4
CONSTANT: D3DTOP_MODULATE2X           5
CONSTANT: D3DTOP_MODULATE4X           6
CONSTANT: D3DTOP_ADD                  7
CONSTANT: D3DTOP_ADDSIGNED            8
CONSTANT: D3DTOP_ADDSIGNED2X          9
CONSTANT: D3DTOP_SUBTRACT             10
CONSTANT: D3DTOP_ADDSMOOTH            11
CONSTANT: D3DTOP_BLENDDIFFUSEALPHA    12
CONSTANT: D3DTOP_BLENDTEXTUREALPHA    13
CONSTANT: D3DTOP_BLENDFACTORALPHA     14
CONSTANT: D3DTOP_BLENDTEXTUREALPHAPM  15
CONSTANT: D3DTOP_BLENDCURRENTALPHA    16
CONSTANT: D3DTOP_PREMODULATE            17
CONSTANT: D3DTOP_MODULATEALPHA_ADDCOLOR 18
CONSTANT: D3DTOP_MODULATECOLOR_ADDALPHA 19
CONSTANT: D3DTOP_MODULATEINVALPHA_ADDCOLOR 20
CONSTANT: D3DTOP_MODULATEINVCOLOR_ADDALPHA 21
CONSTANT: D3DTOP_BUMPENVMAP           22
CONSTANT: D3DTOP_BUMPENVMAPLUMINANCE  23
CONSTANT: D3DTOP_DOTPRODUCT3          24
CONSTANT: D3DTOP_MULTIPLYADD          25
CONSTANT: D3DTOP_LERP                 26
CONSTANT: D3DTOP_FORCE_DWORD 0x7fffffff

CONSTANT: D3DTA_SELECTMASK        0x0000000f
CONSTANT: D3DTA_DIFFUSE           0x00000000
CONSTANT: D3DTA_CURRENT           0x00000001
CONSTANT: D3DTA_TEXTURE           0x00000002
CONSTANT: D3DTA_TFACTOR           0x00000003
CONSTANT: D3DTA_SPECULAR          0x00000004
CONSTANT: D3DTA_TEMP              0x00000005
CONSTANT: D3DTA_CONSTANT          0x00000006
CONSTANT: D3DTA_COMPLEMENT        0x00000010
CONSTANT: D3DTA_ALPHAREPLICATE    0x00000020

TYPEDEF: int D3DTEXTUREFILTERTYPE
CONSTANT: D3DTEXF_NONE            0
CONSTANT: D3DTEXF_POINT           1
CONSTANT: D3DTEXF_LINEAR          2
CONSTANT: D3DTEXF_ANISOTROPIC     3
CONSTANT: D3DTEXF_PYRAMIDALQUAD   6
CONSTANT: D3DTEXF_GAUSSIANQUAD    7
CONSTANT: D3DTEXF_CONVOLUTIONMONO 8
CONSTANT: D3DTEXF_FORCE_DWORD     0x7fffffff

CONSTANT: D3DPV_DONOTCOPYDATA     1

CONSTANT: D3DFVF_RESERVED0        0x001
CONSTANT: D3DFVF_POSITION_MASK    0x400E
CONSTANT: D3DFVF_XYZ              0x002
CONSTANT: D3DFVF_XYZRHW           0x004
CONSTANT: D3DFVF_XYZB1            0x006
CONSTANT: D3DFVF_XYZB2            0x008
CONSTANT: D3DFVF_XYZB3            0x00a
CONSTANT: D3DFVF_XYZB4            0x00c
CONSTANT: D3DFVF_XYZB5            0x00e
CONSTANT: D3DFVF_XYZW             0x4002

CONSTANT: D3DFVF_NORMAL           0x010
CONSTANT: D3DFVF_PSIZE            0x020
CONSTANT: D3DFVF_DIFFUSE          0x040
CONSTANT: D3DFVF_SPECULAR         0x080

CONSTANT: D3DFVF_TEXCOUNT_MASK    0xf00
CONSTANT: D3DFVF_TEXCOUNT_SHIFT   8
CONSTANT: D3DFVF_TEX0             0x000
CONSTANT: D3DFVF_TEX1             0x100
CONSTANT: D3DFVF_TEX2             0x200
CONSTANT: D3DFVF_TEX3             0x300
CONSTANT: D3DFVF_TEX4             0x400
CONSTANT: D3DFVF_TEX5             0x500
CONSTANT: D3DFVF_TEX6             0x600
CONSTANT: D3DFVF_TEX7             0x700
CONSTANT: D3DFVF_TEX8             0x800

CONSTANT: D3DFVF_LASTBETA_UBYTE4   0x1000
CONSTANT: D3DFVF_LASTBETA_D3DCOLOR 0x8000

CONSTANT: D3DFVF_RESERVED2         0x6000

TYPEDEF: int D3DDECLUSAGE
CONSTANT: D3DDECLUSAGE_POSITION     0
CONSTANT: D3DDECLUSAGE_BLENDWEIGHT  1
CONSTANT: D3DDECLUSAGE_BLENDINDICES 2
CONSTANT: D3DDECLUSAGE_NORMAL       3
CONSTANT: D3DDECLUSAGE_PSIZE        4
CONSTANT: D3DDECLUSAGE_TEXCOORD     5
CONSTANT: D3DDECLUSAGE_TANGENT      6
CONSTANT: D3DDECLUSAGE_BINORMAL     7
CONSTANT: D3DDECLUSAGE_TESSFACTOR   8
CONSTANT: D3DDECLUSAGE_POSITIONT    9
CONSTANT: D3DDECLUSAGE_COLOR        10
CONSTANT: D3DDECLUSAGE_FOG          11
CONSTANT: D3DDECLUSAGE_DEPTH        12
CONSTANT: D3DDECLUSAGE_SAMPLE       13

CONSTANT: MAXD3DDECLUSAGE         13
CONSTANT: MAXD3DDECLUSAGEINDEX    15
CONSTANT: MAXD3DDECLLENGTH        64

ENUM: D3DDECLMETHOD
    D3DDECLMETHOD_DEFAULT
    D3DDECLMETHOD_PARTIALU
    D3DDECLMETHOD_PARTIALV
    D3DDECLMETHOD_CROSSUV
    D3DDECLMETHOD_UV
    D3DDECLMETHOD_LOOKUP
    D3DDECLMETHOD_LOOKUPPRESAMPLED ;

: MAXD3DDECLMETHOD ( -- n ) D3DDECLMETHOD_LOOKUPPRESAMPLED ; inline

TYPEDEF: int D3DDECLTYPE
CONSTANT: D3DDECLTYPE_FLOAT1    0
CONSTANT: D3DDECLTYPE_FLOAT2    1
CONSTANT: D3DDECLTYPE_FLOAT3    2
CONSTANT: D3DDECLTYPE_FLOAT4    3
CONSTANT: D3DDECLTYPE_D3DCOLOR  4
CONSTANT: D3DDECLTYPE_UBYTE4    5
CONSTANT: D3DDECLTYPE_SHORT2    6
CONSTANT: D3DDECLTYPE_SHORT4    7
CONSTANT: D3DDECLTYPE_UBYTE4N   8
CONSTANT: D3DDECLTYPE_SHORT2N   9
CONSTANT: D3DDECLTYPE_SHORT4N   10
CONSTANT: D3DDECLTYPE_USHORT2N  11
CONSTANT: D3DDECLTYPE_USHORT4N  12
CONSTANT: D3DDECLTYPE_UDEC3     13
CONSTANT: D3DDECLTYPE_DEC3N     14
CONSTANT: D3DDECLTYPE_FLOAT16_2 15
CONSTANT: D3DDECLTYPE_FLOAT16_4 16
CONSTANT: D3DDECLTYPE_UNUSED    17

: MAXD3DDECLTYPE ( -- n ) D3DDECLTYPE_UNUSED ; inline

STRUCT: D3DVERTEXELEMENT9
    { Stream        WORD }
    { Offset        WORD }
    { Type          BYTE }
    { Method        BYTE }
    { Usage         BYTE }
    { UsageIndex    BYTE } ;
TYPEDEF: D3DVERTEXELEMENT9* LPD3DVERTEXELEMENT9

CONSTANT: D3DDP_MAXTEXCOORD   8

CONSTANT: D3DSTREAMSOURCE_INDEXEDDATA  0x40000000
CONSTANT: D3DSTREAMSOURCE_INSTANCEDATA 0x80000000

CONSTANT: D3DSI_OPCODE_MASK       0x0000FFFF
CONSTANT: D3DSI_INSTLENGTH_MASK   0x0F000000
CONSTANT: D3DSI_INSTLENGTH_SHIFT  24

TYPEDEF: int D3DSHADER_INSTRUCTION_OPCODE_TYPE
CONSTANT: D3DSIO_NOP          0
CONSTANT: D3DSIO_MOV          1
CONSTANT: D3DSIO_ADD          2
CONSTANT: D3DSIO_SUB          3
CONSTANT: D3DSIO_MAD          4
CONSTANT: D3DSIO_MUL          5
CONSTANT: D3DSIO_RCP          6
CONSTANT: D3DSIO_RSQ          7
CONSTANT: D3DSIO_DP3          8
CONSTANT: D3DSIO_DP4          9
CONSTANT: D3DSIO_MIN          10
CONSTANT: D3DSIO_MAX          11
CONSTANT: D3DSIO_SLT          12
CONSTANT: D3DSIO_SGE          13
CONSTANT: D3DSIO_EXP          14
CONSTANT: D3DSIO_LOG          15
CONSTANT: D3DSIO_LIT          16
CONSTANT: D3DSIO_DST          17
CONSTANT: D3DSIO_LRP          18
CONSTANT: D3DSIO_FRC          19
CONSTANT: D3DSIO_M4x4         20
CONSTANT: D3DSIO_M4x3         21
CONSTANT: D3DSIO_M3x4         22
CONSTANT: D3DSIO_M3x3         23
CONSTANT: D3DSIO_M3x2         24
CONSTANT: D3DSIO_CALL         25
CONSTANT: D3DSIO_CALLNZ       26
CONSTANT: D3DSIO_LOOP         27
CONSTANT: D3DSIO_RET          28
CONSTANT: D3DSIO_ENDLOOP      29
CONSTANT: D3DSIO_LABEL        30
CONSTANT: D3DSIO_DCL          31
CONSTANT: D3DSIO_POW          32
CONSTANT: D3DSIO_CRS          33
CONSTANT: D3DSIO_SGN          34
CONSTANT: D3DSIO_ABS          35
CONSTANT: D3DSIO_NRM          36
CONSTANT: D3DSIO_SINCOS       37
CONSTANT: D3DSIO_REP          38
CONSTANT: D3DSIO_ENDREP       39
CONSTANT: D3DSIO_IF           40
CONSTANT: D3DSIO_IFC          41
CONSTANT: D3DSIO_ELSE         42
CONSTANT: D3DSIO_ENDIF        43
CONSTANT: D3DSIO_BREAK        44
CONSTANT: D3DSIO_BREAKC       45
CONSTANT: D3DSIO_MOVA         46
CONSTANT: D3DSIO_DEFB         47
CONSTANT: D3DSIO_DEFI         48
CONSTANT: D3DSIO_TEXCOORD     64
CONSTANT: D3DSIO_TEXKILL      65
CONSTANT: D3DSIO_TEX          66
CONSTANT: D3DSIO_TEXBEM       67
CONSTANT: D3DSIO_TEXBEML      68
CONSTANT: D3DSIO_TEXREG2AR    69
CONSTANT: D3DSIO_TEXREG2GB    70
CONSTANT: D3DSIO_TEXM3x2PAD   71
CONSTANT: D3DSIO_TEXM3x2TEX   72
CONSTANT: D3DSIO_TEXM3x3PAD   73
CONSTANT: D3DSIO_TEXM3x3TEX   74
CONSTANT: D3DSIO_RESERVED0    75
CONSTANT: D3DSIO_TEXM3x3SPEC  76
CONSTANT: D3DSIO_TEXM3x3VSPEC 77
CONSTANT: D3DSIO_EXPP         78
CONSTANT: D3DSIO_LOGP         79
CONSTANT: D3DSIO_CND          80
CONSTANT: D3DSIO_DEF          81
CONSTANT: D3DSIO_TEXREG2RGB   82
CONSTANT: D3DSIO_TEXDP3TEX    83
CONSTANT: D3DSIO_TEXM3x2DEPTH 84
CONSTANT: D3DSIO_TEXDP3       85
CONSTANT: D3DSIO_TEXM3x3      86
CONSTANT: D3DSIO_TEXDEPTH     87
CONSTANT: D3DSIO_CMP          88
CONSTANT: D3DSIO_BEM          89
CONSTANT: D3DSIO_DP2ADD       90
CONSTANT: D3DSIO_DSX          91
CONSTANT: D3DSIO_DSY          92
CONSTANT: D3DSIO_TEXLDD       93
CONSTANT: D3DSIO_SETP         94
CONSTANT: D3DSIO_TEXLDL       95
CONSTANT: D3DSIO_BREAKP       96
CONSTANT: D3DSIO_PHASE        0xFFFD
CONSTANT: D3DSIO_COMMENT      0xFFFE
CONSTANT: D3DSIO_END          0xFFFF
CONSTANT: D3DSIO_FORCE_DWORD  0x7fffffff

CONSTANT: D3DSI_COISSUE           0x40000000

CONSTANT: D3DSP_OPCODESPECIFICCONTROL_MASK  0x00ff0000
CONSTANT: D3DSP_OPCODESPECIFICCONTROL_SHIFT 16

: D3DSI_TEXLD_PROJECT ( -- n ) 1 D3DSP_OPCODESPECIFICCONTROL_SHIFT shift ; inline
: D3DSI_TEXLD_BIAS    ( -- n ) 2 D3DSP_OPCODESPECIFICCONTROL_SHIFT shift ; inline

TYPEDEF: int D3DSHADER_COMPARISON
CONSTANT: D3DSPC_RESERVED0 0
CONSTANT: D3DSPC_GT        1
CONSTANT: D3DSPC_EQ        2
CONSTANT: D3DSPC_GE        3
CONSTANT: D3DSPC_LT        4
CONSTANT: D3DSPC_NE        5
CONSTANT: D3DSPC_LE        6
CONSTANT: D3DSPC_RESERVED1 7  

CONSTANT: D3DSHADER_COMPARISON_SHIFT D3DSP_OPCODESPECIFICCONTROL_SHIFT
: D3DSHADER_COMPARISON_MASK ( -- n ) 7 D3DSHADER_COMPARISON_SHIFT shift ; inline

CONSTANT: D3DSHADER_INSTRUCTION_PREDICATED    0x10000000

CONSTANT: D3DSP_DCL_USAGE_SHIFT 0
CONSTANT: D3DSP_DCL_USAGE_MASK  0x0000000f

CONSTANT: D3DSP_DCL_USAGEINDEX_SHIFT 16
CONSTANT: D3DSP_DCL_USAGEINDEX_MASK  0x000f0000

CONSTANT: D3DSP_TEXTURETYPE_SHIFT 27
CONSTANT: D3DSP_TEXTURETYPE_MASK  0x78000000

TYPEDEF: int D3DSAMPLER_TEXTURE_TYPE
: D3DSTT_UNKNOWN ( -- n ) 0 D3DSP_TEXTURETYPE_SHIFT shift ; inline
: D3DSTT_2D      ( -- n ) 2 D3DSP_TEXTURETYPE_SHIFT shift ; inline
: D3DSTT_CUBE    ( -- n ) 3 D3DSP_TEXTURETYPE_SHIFT shift ; inline
: D3DSTT_VOLUME  ( -- n ) 4 D3DSP_TEXTURETYPE_SHIFT shift ; inline
CONSTANT: D3DSTT_FORCE_DWORD 0x7fffffff

CONSTANT: D3DSP_REGNUM_MASK       0x000007FF

CONSTANT: D3DSP_WRITEMASK_0       0x00010000
CONSTANT: D3DSP_WRITEMASK_1       0x00020000
CONSTANT: D3DSP_WRITEMASK_2       0x00040000
CONSTANT: D3DSP_WRITEMASK_3       0x00080000
CONSTANT: D3DSP_WRITEMASK_ALL     0x000F0000

CONSTANT: D3DSP_DSTMOD_SHIFT      20
CONSTANT: D3DSP_DSTMOD_MASK       0x00F00000

: D3DSPDM_NONE             ( -- n ) 0 D3DSP_DSTMOD_SHIFT shift ; inline
: D3DSPDM_SATURATE         ( -- n ) 1 D3DSP_DSTMOD_SHIFT shift ; inline
: D3DSPDM_PARTIALPRECISION ( -- n ) 2 D3DSP_DSTMOD_SHIFT shift ; inline
: D3DSPDM_MSAMPCENTROID    ( -- n ) 4 D3DSP_DSTMOD_SHIFT shift ; inline

CONSTANT: D3DSP_DSTSHIFT_SHIFT    24
CONSTANT: D3DSP_DSTSHIFT_MASK     0x0F000000

CONSTANT: D3DSP_REGTYPE_SHIFT     28
CONSTANT: D3DSP_REGTYPE_SHIFT2    8
CONSTANT: D3DSP_REGTYPE_MASK      0x70000000
CONSTANT: D3DSP_REGTYPE_MASK2     0x00001800

TYPEDEF: int D3DSHADER_PARAM_REGISTER_TYPE
CONSTANT: D3DSPR_TEMP           0
CONSTANT: D3DSPR_INPUT          1
CONSTANT: D3DSPR_CONST          2
CONSTANT: D3DSPR_ADDR           3
CONSTANT: D3DSPR_TEXTURE        3
CONSTANT: D3DSPR_RASTOUT        4
CONSTANT: D3DSPR_ATTROUT        5
CONSTANT: D3DSPR_TEXCRDOUT      6
CONSTANT: D3DSPR_OUTPUT         6
CONSTANT: D3DSPR_CONSTINT       7
CONSTANT: D3DSPR_COLOROUT       8
CONSTANT: D3DSPR_DEPTHOUT       9
CONSTANT: D3DSPR_SAMPLER        10
CONSTANT: D3DSPR_CONST2         11
CONSTANT: D3DSPR_CONST3         12
CONSTANT: D3DSPR_CONST4         13
CONSTANT: D3DSPR_CONSTBOOL      14
CONSTANT: D3DSPR_LOOP           15
CONSTANT: D3DSPR_TEMPFLOAT16    16
CONSTANT: D3DSPR_MISCTYPE       17
CONSTANT: D3DSPR_LABEL          18
CONSTANT: D3DSPR_PREDICATE      19
CONSTANT: D3DSPR_FORCE_DWORD  0x7fffffff

TYPEDEF: int D3DSHADER_MISCTYPE_OFFSETS
CONSTANT: D3DSMO_POSITION   0
CONSTANT: D3DSMO_FACE       1

TYPEDEF: int D3DVS_RASTOUT_OFFSETS
CONSTANT: D3DSRO_POSITION   0
CONSTANT: D3DSRO_FOG        1
CONSTANT: D3DSRO_POINT_SIZE 2
CONSTANT: D3DSRO_FORCE_DWORD 0x7fffffff

CONSTANT: D3DVS_ADDRESSMODE_SHIFT 13
: D3DVS_ADDRESSMODE_MASK ( -- n ) 1 D3DVS_ADDRESSMODE_SHIFT shift ; inline

TYPEDEF: int D3DVS_ADDRESSMODE_TYPE
: D3DVS_ADDRMODE_ABSOLUTE ( -- n ) 0 D3DVS_ADDRESSMODE_SHIFT shift ; inline
: D3DVS_ADDRMODE_RELATIVE ( -- n ) 1 D3DVS_ADDRESSMODE_SHIFT shift ; inline
CONSTANT: D3DVS_ADDRMODE_FORCE_DWORD 0x7fffffff

CONSTANT: D3DSHADER_ADDRESSMODE_SHIFT 13
: D3DSHADER_ADDRESSMODE_MASK ( -- n ) 1 D3DSHADER_ADDRESSMODE_SHIFT shift ; inline

TYPEDEF: int D3DSHADER_ADDRESSMODE_TYPE
: D3DSHADER_ADDRMODE_ABSOLUTE ( -- n ) 0 D3DSHADER_ADDRESSMODE_SHIFT shift ; inline
: D3DSHADER_ADDRMODE_RELATIVE ( -- n ) 1 D3DSHADER_ADDRESSMODE_SHIFT shift ; inline
CONSTANT: D3DSHADER_ADDRMODE_FORCE_DWORD 0x7fffffff

CONSTANT: D3DVS_SWIZZLE_SHIFT     16
CONSTANT: D3DVS_SWIZZLE_MASK      0x00FF0000

CONSTANT: D3DVS_X_X $[ 0 16 shift ]
CONSTANT: D3DVS_X_Y $[ 1 16 shift ]
CONSTANT: D3DVS_X_Z $[ 2 16 shift ]
CONSTANT: D3DVS_X_W $[ 3 16 shift ]

CONSTANT: D3DVS_Y_X $[ 0 16 2 + shift ]
CONSTANT: D3DVS_Y_Y $[ 1 16 2 + shift ]
CONSTANT: D3DVS_Y_Z $[ 2 16 2 + shift ]
CONSTANT: D3DVS_Y_W $[ 3 16 2 + shift ]

CONSTANT: D3DVS_Z_X $[ 0 16 4 + shift ]
CONSTANT: D3DVS_Z_Y $[ 1 16 4 + shift ]
CONSTANT: D3DVS_Z_Z $[ 2 16 4 + shift ]
CONSTANT: D3DVS_Z_W $[ 3 16 4 + shift ]

CONSTANT: D3DVS_W_X $[ 0 16 6 + shift ]
CONSTANT: D3DVS_W_Y $[ 1 16 6 + shift ]
CONSTANT: D3DVS_W_Z $[ 2 16 6 + shift ]
CONSTANT: D3DVS_W_W $[ 3 16 6 + shift ]

CONSTANT: D3DVS_NOSWIZZLE flags{ D3DVS_X_X D3DVS_Y_Y D3DVS_Z_Z D3DVS_W_W }

CONSTANT: D3DSP_SWIZZLE_SHIFT     16
CONSTANT: D3DSP_SWIZZLE_MASK      0x00FF0000
CONSTANT: D3DSP_SRCMOD_SHIFT      24
CONSTANT: D3DSP_SRCMOD_MASK       0x0F000000

TYPEDEF: int D3DSHADER_PARAM_SRCMOD_TYPE
CONSTANT: D3DSPSM_NONE    $[ 0 24 shift ]
CONSTANT: D3DSPSM_NEG     $[ 1 24 shift ]
CONSTANT: D3DSPSM_BIAS    $[ 2 24 shift ]
CONSTANT: D3DSPSM_BIASNEG $[ 3 24 shift ]
CONSTANT: D3DSPSM_SIGN    $[ 4 24 shift ]
CONSTANT: D3DSPSM_SIGNNEG $[ 5 24 shift ]
CONSTANT: D3DSPSM_COMP    $[ 6 24 shift ]
CONSTANT: D3DSPSM_X2      $[ 7 24 shift ]
CONSTANT: D3DSPSM_X2NEG   $[ 8 24 shift ]
CONSTANT: D3DSPSM_DZ      $[ 9 24 shift ]
CONSTANT: D3DSPSM_DW      $[ 10 24 shift ]
CONSTANT: D3DSPSM_ABS     $[ 11 24 shift ]
CONSTANT: D3DSPSM_ABSNEG  $[ 12 24 shift ]
CONSTANT: D3DSPSM_NOT     $[ 13 24 shift ]
CONSTANT: D3DSPSM_FORCE_DWORD 0x7fffffff

: D3DPS_VERSION ( major minor -- n )
    swap 8 shift bitor 0xFFFF0000 bitor ; inline
: D3DVS_VERSION ( major minor -- n )
    swap 8 shift bitor 0xFFFF0000 bitor ; inline

: D3DSHADER_VERSION_MAJOR ( version -- n )
    -8 shift 0xFF bitand ; inline
: D3DSHADER_VERSION_MINOR ( version -- n )
    0xFF bitand ; inline

CONSTANT: D3DSI_COMMENTSIZE_SHIFT 16
CONSTANT: D3DSI_COMMENTSIZE_MASK  0x7FFF0000

CONSTANT: D3DPS_END()  0x0000FFFF
CONSTANT: D3DVS_END()  0x0000FFFF

TYPEDEF: int D3DBASISTYPE
CONSTANT: D3DBASIS_BEZIER      0
CONSTANT: D3DBASIS_BSPLINE     1
CONSTANT: D3DBASIS_CATMULL_ROM 2
CONSTANT: D3DBASIS_FORCE_DWORD 0x7fffffff

TYPEDEF: int D3DDEGREETYPE
CONSTANT: D3DDEGREE_LINEAR      1
CONSTANT: D3DDEGREE_QUADRATIC   2
CONSTANT: D3DDEGREE_CUBIC       3
CONSTANT: D3DDEGREE_QUINTIC     5
CONSTANT: D3DDEGREE_FORCE_DWORD 0x7fffffff

TYPEDEF: int D3DPATCHEDGESTYLE
CONSTANT: D3DPATCHEDGE_DISCRETE    0
CONSTANT: D3DPATCHEDGE_CONTINUOUS  1
CONSTANT: D3DPATCHEDGE_FORCE_DWORD 0x7fffffff

TYPEDEF: int D3DSTATEBLOCKTYPE
CONSTANT: D3DSBT_ALL           1
CONSTANT: D3DSBT_PIXELSTATE    2
CONSTANT: D3DSBT_VERTEXSTATE   3
CONSTANT: D3DSBT_FORCE_DWORD   0x7fffffff

TYPEDEF: int D3DVERTEXBLENDFLAGS
CONSTANT: D3DVBF_DISABLE  0
CONSTANT: D3DVBF_1WEIGHTS 1
CONSTANT: D3DVBF_2WEIGHTS 2
CONSTANT: D3DVBF_3WEIGHTS 3
CONSTANT: D3DVBF_TWEENING 255
CONSTANT: D3DVBF_0WEIGHTS 256
CONSTANT: D3DVBF_FORCE_DWORD 0x7fffffff

TYPEDEF: int D3DTEXTURETRANSFORMFLAGS
CONSTANT: D3DTTFF_DISABLE         0
CONSTANT: D3DTTFF_COUNT1          1
CONSTANT: D3DTTFF_COUNT2          2
CONSTANT: D3DTTFF_COUNT3          3
CONSTANT: D3DTTFF_COUNT4          4
CONSTANT: D3DTTFF_PROJECTED       256
CONSTANT: D3DTTFF_FORCE_DWORD     0x7fffffff

CONSTANT: D3DFVF_TEXTUREFORMAT2 0
CONSTANT: D3DFVF_TEXTUREFORMAT1 3
CONSTANT: D3DFVF_TEXTUREFORMAT3 1
CONSTANT: D3DFVF_TEXTUREFORMAT4 2

: D3DFVF_TEXCOORDSIZE3 ( CoordIndex -- n )
    2 * 16 + D3DFVF_TEXTUREFORMAT3 swap shift ; inline
: D3DFVF_TEXCOORDSIZE2 ( CoordIndex -- n )
    drop D3DFVF_TEXTUREFORMAT2 ; inline
: D3DFVF_TEXCOORDSIZE4 ( CoordIndex -- n )
    2 * 16 + D3DFVF_TEXTUREFORMAT4 swap shift ; inline
: D3DFVF_TEXCOORDSIZE1 ( CoordIndex -- n )
    2 * 16 + D3DFVF_TEXTUREFORMAT1 swap shift ; inline

TYPEDEF: int D3DDEVTYPE
CONSTANT: D3DDEVTYPE_HAL         1
CONSTANT: D3DDEVTYPE_REF         2
CONSTANT: D3DDEVTYPE_SW          3
CONSTANT: D3DDEVTYPE_NULLREF     4
CONSTANT: D3DDEVTYPE_FORCE_DWORD  0x7fffffff

TYPEDEF: int D3DMULTISAMPLE_TYPE
CONSTANT: D3DMULTISAMPLE_NONE            0
CONSTANT: D3DMULTISAMPLE_NONMASKABLE     1
CONSTANT: D3DMULTISAMPLE_2_SAMPLES       2
CONSTANT: D3DMULTISAMPLE_3_SAMPLES       3
CONSTANT: D3DMULTISAMPLE_4_SAMPLES       4
CONSTANT: D3DMULTISAMPLE_5_SAMPLES       5
CONSTANT: D3DMULTISAMPLE_6_SAMPLES       6
CONSTANT: D3DMULTISAMPLE_7_SAMPLES       7
CONSTANT: D3DMULTISAMPLE_8_SAMPLES       8
CONSTANT: D3DMULTISAMPLE_9_SAMPLES       9
CONSTANT: D3DMULTISAMPLE_10_SAMPLES      10
CONSTANT: D3DMULTISAMPLE_11_SAMPLES      11
CONSTANT: D3DMULTISAMPLE_12_SAMPLES      12
CONSTANT: D3DMULTISAMPLE_13_SAMPLES      13
CONSTANT: D3DMULTISAMPLE_14_SAMPLES      14
CONSTANT: D3DMULTISAMPLE_15_SAMPLES      15
CONSTANT: D3DMULTISAMPLE_16_SAMPLES      16
CONSTANT: D3DMULTISAMPLE_FORCE_DWORD     0x7fffffff
                                                                  
TYPEDEF: int D3DFORMAT
CONSTANT: D3DFMT_UNKNOWN              0
CONSTANT: D3DFMT_R8G8B8               20
CONSTANT: D3DFMT_A8R8G8B8             21
CONSTANT: D3DFMT_X8R8G8B8             22
CONSTANT: D3DFMT_R5G6B5               23
CONSTANT: D3DFMT_X1R5G5B5             24
CONSTANT: D3DFMT_A1R5G5B5             25
CONSTANT: D3DFMT_A4R4G4B4             26
CONSTANT: D3DFMT_R3G3B2               27
CONSTANT: D3DFMT_A8                   28
CONSTANT: D3DFMT_A8R3G3B2             29
CONSTANT: D3DFMT_X4R4G4B4             30
CONSTANT: D3DFMT_A2B10G10R10          31
CONSTANT: D3DFMT_A8B8G8R8             32
CONSTANT: D3DFMT_X8B8G8R8             33
CONSTANT: D3DFMT_G16R16               34
CONSTANT: D3DFMT_A2R10G10B10          35
CONSTANT: D3DFMT_A16B16G16R16         36
CONSTANT: D3DFMT_A8P8                 40
CONSTANT: D3DFMT_P8                   41
CONSTANT: D3DFMT_L8                   50
CONSTANT: D3DFMT_A8L8                 51
CONSTANT: D3DFMT_A4L4                 52
CONSTANT: D3DFMT_V8U8                 60
CONSTANT: D3DFMT_L6V5U5               61
CONSTANT: D3DFMT_X8L8V8U8             62
CONSTANT: D3DFMT_Q8W8V8U8             63
CONSTANT: D3DFMT_V16U16               64
CONSTANT: D3DFMT_A2W10V10U10          67
CONSTANT: D3DFMT_UYVY                 0x55595659
CONSTANT: D3DFMT_R8G8_B8G8            0x52474247
CONSTANT: D3DFMT_YUY2                 0x59555932
CONSTANT: D3DFMT_G8R8_G8B8            0x47524742
CONSTANT: D3DFMT_DXT1                 0x44585431
CONSTANT: D3DFMT_DXT2                 0x44585432
CONSTANT: D3DFMT_DXT3                 0x44585433
CONSTANT: D3DFMT_DXT4                 0x44585434
CONSTANT: D3DFMT_DXT5                 0x44585435
CONSTANT: D3DFMT_D16_LOCKABLE         70
CONSTANT: D3DFMT_D32                  71
CONSTANT: D3DFMT_D15S1                73
CONSTANT: D3DFMT_D24S8                75
CONSTANT: D3DFMT_D24X8                77
CONSTANT: D3DFMT_D24X4S4              79
CONSTANT: D3DFMT_D16                  80
CONSTANT: D3DFMT_D32F_LOCKABLE        82
CONSTANT: D3DFMT_D24FS8               83
CONSTANT: D3DFMT_D32_LOCKABLE         84
CONSTANT: D3DFMT_S8_LOCKABLE          85
CONSTANT: D3DFMT_L16                  81
CONSTANT: D3DFMT_VERTEXDATA           100
CONSTANT: D3DFMT_INDEX16              101
CONSTANT: D3DFMT_INDEX32              102
CONSTANT: D3DFMT_Q16W16V16U16         110
CONSTANT: D3DFMT_MULTI2_ARGB8         0x4d455431
CONSTANT: D3DFMT_R16F                 111
CONSTANT: D3DFMT_G16R16F              112
CONSTANT: D3DFMT_A16B16G16R16F        113
CONSTANT: D3DFMT_R32F                 114
CONSTANT: D3DFMT_G32R32F              115
CONSTANT: D3DFMT_A32B32G32R32F        116
CONSTANT: D3DFMT_CxV8U8               117
CONSTANT: D3DFMT_A1                   118
CONSTANT: D3DFMT_A2B10G10R10_XR_BIAS  119
CONSTANT: D3DFMT_BINARYBUFFER         199
CONSTANT: D3DFMT_FORCE_DWORD          0x7fffffff

STRUCT: D3DDISPLAYMODE
    { Width                  UINT      }
    { Height                 UINT      }
    { RefreshRate            UINT      }
    { Format                 D3DFORMAT } ;

STRUCT: D3DDEVICE_CREATION_PARAMETERS
    { AdapterOrdinal            UINT       }
    { DeviceType                D3DDEVTYPE }
    { hFocusWindow              HWND       }
    { BehaviorFlags             DWORD      } ;

TYPEDEF: int D3DSWAPEFFECT
CONSTANT: D3DSWAPEFFECT_DISCARD           1
CONSTANT: D3DSWAPEFFECT_FLIP              2
CONSTANT: D3DSWAPEFFECT_COPY              3
CONSTANT: D3DSWAPEFFECT_OVERLAY           4
CONSTANT: D3DSWAPEFFECT_FLIPEX            5
CONSTANT: D3DSWAPEFFECT_FORCE_DWORD       0x7fffffff

TYPEDEF: int D3DPOOL
CONSTANT: D3DPOOL_DEFAULT                 0
CONSTANT: D3DPOOL_MANAGED                 1
CONSTANT: D3DPOOL_SYSTEMMEM               2
CONSTANT: D3DPOOL_SCRATCH                 3
CONSTANT: D3DPOOL_FORCE_DWORD             0x7fffffff

CONSTANT: D3DPRESENT_RATE_DEFAULT         0x00000000

STRUCT: D3DPRESENT_PARAMETERS
    { BackBufferWidth             UINT                }
    { BackBufferHeight            UINT                }
    { BackBufferFormat            D3DFORMAT           }
    { BackBufferCount             UINT                }
    { MultiSampleType             D3DMULTISAMPLE_TYPE }
    { MultiSampleQuality          DWORD               }
    { SwapEffect                  D3DSWAPEFFECT       }
    { hDeviceWindow               HWND                }
    { Windowed                    BOOL                }
    { EnableAutoDepthStencil      BOOL                }
    { AutoDepthStencilFormat      D3DFORMAT           }
    { Flags                       DWORD               }
    { FullScreen_RefreshRateInHz  UINT                }
    { PresentationInterval        UINT                } ;

CONSTANT: D3DPRESENTFLAG_LOCKABLE_BACKBUFFER      0x00000001
CONSTANT: D3DPRESENTFLAG_DISCARD_DEPTHSTENCIL     0x00000002
CONSTANT: D3DPRESENTFLAG_DEVICECLIP               0x00000004
CONSTANT: D3DPRESENTFLAG_VIDEO                    0x00000010

CONSTANT: D3DPRESENTFLAG_NOAUTOROTATE                    0x00000020
CONSTANT: D3DPRESENTFLAG_UNPRUNEDMODE                    0x00000040
CONSTANT: D3DPRESENTFLAG_OVERLAY_LIMITEDRGB              0x00000080
CONSTANT: D3DPRESENTFLAG_OVERLAY_YCbCr_BT709             0x00000100
CONSTANT: D3DPRESENTFLAG_OVERLAY_YCbCr_xvYCC             0x00000200
CONSTANT: D3DPRESENTFLAG_RESTRICTED_CONTENT              0x00000400
CONSTANT: D3DPRESENTFLAG_RESTRICT_SHARED_RESOURCE_DRIVER 0x00000800

STRUCT: D3DGAMMARAMP
    { red   WORD[256] }
    { green WORD[256] }
    { blue  WORD[256] } ;

TYPEDEF: int D3DBACKBUFFER_TYPE
CONSTANT: D3DBACKBUFFER_TYPE_MONO         0
CONSTANT: D3DBACKBUFFER_TYPE_LEFT         1
CONSTANT: D3DBACKBUFFER_TYPE_RIGHT        2
CONSTANT: D3DBACKBUFFER_TYPE_FORCE_DWORD  0x7fffffff

TYPEDEF: int D3DRESOURCETYPE
CONSTANT: D3DRTYPE_SURFACE                1
CONSTANT: D3DRTYPE_VOLUME                 2
CONSTANT: D3DRTYPE_TEXTURE                3
CONSTANT: D3DRTYPE_VOLUMETEXTURE          4
CONSTANT: D3DRTYPE_CUBETEXTURE            5
CONSTANT: D3DRTYPE_VERTEXBUFFER           6
CONSTANT: D3DRTYPE_INDEXBUFFER            7
CONSTANT: D3DRTYPE_FORCE_DWORD            0x7fffffff

CONSTANT: D3DUSAGE_RENDERTARGET       0x00000001
CONSTANT: D3DUSAGE_DEPTHSTENCIL       0x00000002
CONSTANT: D3DUSAGE_DYNAMIC            0x00000200

CONSTANT: D3DUSAGE_NONSECURE          0x00800000

CONSTANT: D3DUSAGE_AUTOGENMIPMAP      0x00000400
CONSTANT: D3DUSAGE_DMAP               0x00004000

CONSTANT: D3DUSAGE_QUERY_LEGACYBUMPMAP            0x00008000
CONSTANT: D3DUSAGE_QUERY_SRGBREAD                 0x00010000
CONSTANT: D3DUSAGE_QUERY_FILTER                   0x00020000
CONSTANT: D3DUSAGE_QUERY_SRGBWRITE                0x00040000
CONSTANT: D3DUSAGE_QUERY_POSTPIXELSHADER_BLENDING 0x00080000
CONSTANT: D3DUSAGE_QUERY_VERTEXTEXTURE            0x00100000
CONSTANT: D3DUSAGE_QUERY_WRAPANDMIP             0x00200000

CONSTANT: D3DUSAGE_WRITEONLY          0x00000008
CONSTANT: D3DUSAGE_SOFTWAREPROCESSING 0x00000010
CONSTANT: D3DUSAGE_DONOTCLIP          0x00000020
CONSTANT: D3DUSAGE_POINTS             0x00000040
CONSTANT: D3DUSAGE_RTPATCHES          0x00000080
CONSTANT: D3DUSAGE_NPATCHES           0x00000100

CONSTANT: D3DUSAGE_TEXTAPI                         0x10000000
CONSTANT: D3DUSAGE_RESTRICTED_CONTENT              0x00000800
CONSTANT: D3DUSAGE_RESTRICT_SHARED_RESOURCE        0x00002000
CONSTANT: D3DUSAGE_RESTRICT_SHARED_RESOURCE_DRIVER 0x00001000

TYPEDEF: int D3DCUBEMAP_FACES
CONSTANT: D3DCUBEMAP_FACE_POSITIVE_X     0
CONSTANT: D3DCUBEMAP_FACE_NEGATIVE_X     1
CONSTANT: D3DCUBEMAP_FACE_POSITIVE_Y     2
CONSTANT: D3DCUBEMAP_FACE_NEGATIVE_Y     3
CONSTANT: D3DCUBEMAP_FACE_POSITIVE_Z     4
CONSTANT: D3DCUBEMAP_FACE_NEGATIVE_Z     5
CONSTANT: D3DCUBEMAP_FACE_FORCE_DWORD    0x7fffffff

CONSTANT: D3DLOCK_READONLY           0x00000010
CONSTANT: D3DLOCK_DISCARD            0x00002000
CONSTANT: D3DLOCK_NOOVERWRITE        0x00001000
CONSTANT: D3DLOCK_NOSYSLOCK          0x00000800
CONSTANT: D3DLOCK_DONOTWAIT          0x00004000

CONSTANT: D3DLOCK_NO_DIRTY_UPDATE     0x00008000

STRUCT: D3DVERTEXBUFFER_DESC
    { Format              D3DFORMAT       }
    { Type                D3DRESOURCETYPE }
    { Usage               DWORD           }
    { Pool                D3DPOOL         }
    { Size                UINT            }
    { FVF                 DWORD           } ;

STRUCT: D3DINDEXBUFFER_DESC
    { Format              D3DFORMAT       }
    { Type                D3DRESOURCETYPE }
    { Usage               DWORD           }
    { Pool                D3DPOOL         }
    { Size                UINT            } ;

STRUCT: D3DSURFACE_DESC
    { Format              D3DFORMAT           }
    { Type                D3DRESOURCETYPE     }
    { Usage               DWORD               }
    { Pool                D3DPOOL             }
    { MultiSampleType     D3DMULTISAMPLE_TYPE }
    { MultiSampleQuality  DWORD               }
    { Width               UINT                }
    { Height              UINT                } ;

STRUCT: D3DVOLUME_DESC

    { Format              D3DFORMAT       }
    { Type                D3DRESOURCETYPE }
    { Usage               DWORD           }
    { Pool                D3DPOOL         }
    { Width               UINT            }
    { Height              UINT            }
    { Depth               UINT            } ;

STRUCT: D3DLOCKED_RECT
    { Pitch               INT   }
    { pBits               void* } ;

STRUCT: D3DBOX
    { Left                  UINT }
    { Top                   UINT }
    { Right                 UINT }
    { Bottom                UINT }
    { Front                 UINT }
    { Back                  UINT } ;

STRUCT: D3DLOCKED_BOX
    { RowPitch             INT   }
    { SlicePitch           INT   }
    { pBits                void* } ;

STRUCT: D3DRANGE
    { Offset                UINT }
    { Size                  UINT } ;

STRUCT: D3DRECTPATCH_INFO
    { StartVertexOffsetWidth  UINT          }
    { StartVertexOffsetHeight UINT          }
    { Width                   UINT          }
    { Height                  UINT          }
    { Stride                  UINT          }
    { Basis                   D3DBASISTYPE  }
    { Degree                  D3DDEGREETYPE } ;

STRUCT: D3DTRIPATCH_INFO
    { StartVertexOffset       UINT          }
    { NumVertices             UINT          }
    { Basis                   D3DBASISTYPE  }
    { Degree                  D3DDEGREETYPE } ;

CONSTANT: MAX_DEVICE_IDENTIFIER_STRING        512

STRUCT: D3DADAPTER_IDENTIFIER9
    { Driver                      char[512]     }
    { Description                 char[512]     }
    { DeviceName                  char[32]      }
    { DriverVersion               LARGE_INTEGER }
    { VendorId                    DWORD         }
    { DeviceId                    DWORD         }
    { SubSysId                    DWORD         }
    { Revision                    DWORD         }
    { DeviceIdentifier            GUID          }
    { WHQLLevel                   DWORD         } ;

STRUCT: D3DRASTER_STATUS
    { InVBlank            BOOL }
    { ScanLine            UINT } ;

TYPEDEF: int D3DDEBUGMONITORTOKENS
CONSTANT: D3DDMT_ENABLE            0
CONSTANT: D3DDMT_DISABLE           1
CONSTANT: D3DDMT_FORCE_DWORD     0x7fffffff

TYPEDEF: int D3DQUERYTYPE
CONSTANT: D3DQUERYTYPE_VCACHE                 4
CONSTANT: D3DQUERYTYPE_RESOURCEMANAGER        5
CONSTANT: D3DQUERYTYPE_VERTEXSTATS            6
CONSTANT: D3DQUERYTYPE_EVENT                  8
CONSTANT: D3DQUERYTYPE_OCCLUSION              9
CONSTANT: D3DQUERYTYPE_TIMESTAMP              10
CONSTANT: D3DQUERYTYPE_TIMESTAMPDISJOINT      11
CONSTANT: D3DQUERYTYPE_TIMESTAMPFREQ          12
CONSTANT: D3DQUERYTYPE_PIPELINETIMINGS        13
CONSTANT: D3DQUERYTYPE_INTERFACETIMINGS       14
CONSTANT: D3DQUERYTYPE_VERTEXTIMINGS          15
CONSTANT: D3DQUERYTYPE_PIXELTIMINGS           16
CONSTANT: D3DQUERYTYPE_BANDWIDTHTIMINGS       17
CONSTANT: D3DQUERYTYPE_CACHEUTILIZATION       18
CONSTANT: D3DQUERYTYPE_MEMORYPRESSURE         19

CONSTANT: D3DISSUE_END   1
CONSTANT: D3DISSUE_BEGIN 2

CONSTANT: D3DGETDATA_FLUSH 1

STRUCT: D3DRESOURCESTATS
    { bThrashing              BOOL  }
    { ApproxBytesDownloaded   DWORD }
    { NumEvicts               DWORD }
    { NumVidCreates           DWORD }
    { LastPri                 DWORD }
    { NumUsed                 DWORD }
    { NumUsedInVidMem         DWORD }
    { WorkingSet              DWORD }
    { WorkingSetBytes         DWORD }
    { TotalManaged            DWORD }
    { TotalBytes              DWORD } ;

CONSTANT: D3DRTYPECOUNT 8

STRUCT: D3DDEVINFO_RESOURCEMANAGER
    { stats D3DRESOURCESTATS[8] } ;
TYPEDEF: D3DDEVINFO_RESOURCEMANAGER* LPD3DDEVINFO_RESOURCEMANAGER

STRUCT: D3DDEVINFO_D3DVERTEXSTATS
    { NumRenderedTriangles        DWORD }
    { NumExtraClippingTriangles   DWORD } ;
TYPEDEF: D3DDEVINFO_D3DVERTEXSTATS* LPD3DDEVINFO_D3DVERTEXSTATS

STRUCT: D3DDEVINFO_VCACHE
    { Pattern       DWORD }
    { OptMethod     DWORD }
    { CacheSize     DWORD }
    { MagicNumber   DWORD } ;
TYPEDEF: D3DDEVINFO_VCACHE* LPD3DDEVINFO_VCACHE

STRUCT: D3DDEVINFO_D3D9PIPELINETIMINGS
    { VertexProcessingTimePercent   FLOAT }
    { PixelProcessingTimePercent    FLOAT }
    { OtherGPUProcessingTimePercent FLOAT }
    { GPUIdleTimePercent            FLOAT } ;

STRUCT: D3DDEVINFO_D3D9INTERFACETIMINGS
    { WaitingForGPUToUseApplicationResourceTimePercent FLOAT }
    { WaitingForGPUToAcceptMoreCommandsTimePercent     FLOAT }
    { WaitingForGPUToStayWithinLatencyTimePercent      FLOAT }
    { WaitingForGPUExclusiveResourceTimePercent        FLOAT }
    { WaitingForGPUOtherTimePercent                    FLOAT } ;

STRUCT: D3DDEVINFO_D3D9STAGETIMINGS
    { MemoryProcessingPercent      FLOAT }
    { ComputationProcessingPercent FLOAT } ;

STRUCT: D3DDEVINFO_D3D9BANDWIDTHTIMINGS
    { MaxBandwidthUtilized                FLOAT }
    { FrontEndUploadMemoryUtilizedPercent FLOAT }
    { VertexRateUtilizedPercent           FLOAT }
    { TriangleSetupRateUtilizedPercent    FLOAT }
    { FillRateUtilizedPercent             FLOAT } ;

STRUCT: D3DDEVINFO_D3D9CACHEUTILIZATION
    { TextureCacheHitRate             FLOAT }
    { PostTransformVertexCacheHitRate FLOAT } ;

STRUCT: D3DMEMORYPRESSURE
    { BytesEvictedFromProcess      UINT64 }
    { SizeOfInefficientAllocation  UINT64 }
    { LevelOfEfficiency            DWORD  } ;

TYPEDEF: int D3DCOMPOSERECTSOP
CONSTANT: D3DCOMPOSERECTS_COPY     1
CONSTANT: D3DCOMPOSERECTS_OR       2
CONSTANT: D3DCOMPOSERECTS_AND      3
CONSTANT: D3DCOMPOSERECTS_NEG      4
CONSTANT: D3DCOMPOSERECTS_FORCE_DWORD    0x7fffffff

STRUCT: D3DCOMPOSERECTDESC
    { X       USHORT }
    { Y       USHORT }
    { Width   USHORT }
    { Height  USHORT } ;

STRUCT: D3DCOMPOSERECTDESTINATION
    { SrcRectIndex USHORT }
    { Reserved     USHORT }
    { X            SHORT  }
    { Y            SHORT  } ;

CONSTANT: D3DCOMPOSERECTS_MAXNUMRECTS 0xFFFF
CONSTANT: D3DCONVOLUTIONMONO_MAXWIDTH  7
: D3DCONVOLUTIONMONO_MAXHEIGHT ( -- n ) D3DCONVOLUTIONMONO_MAXWIDTH ; inline
CONSTANT: D3DFMT_A1_SURFACE_MAXWIDTH  8192
CONSTANT: D3DFMT_A1_SURFACE_MAXHEIGHT 2048

STRUCT: D3DPRESENTSTATS
    { PresentCount        UINT          }
    { PresentRefreshCount UINT          }
    { SyncRefreshCount    UINT          }
    { SyncQPCTime         LARGE_INTEGER }
    { SyncGPUTime         LARGE_INTEGER } ;

TYPEDEF: int D3DSCANLINEORDERING
CONSTANT: D3DSCANLINEORDERING_UNKNOWN                    0
CONSTANT: D3DSCANLINEORDERING_PROGRESSIVE                1
CONSTANT: D3DSCANLINEORDERING_INTERLACED                 2

STRUCT: D3DDISPLAYMODEEX
    { Size                UINT                }
    { Width               UINT                }
    { Height              UINT                }
    { RefreshRate         UINT                }
    { Format              D3DFORMAT           }
    { ScanLineOrdering    D3DSCANLINEORDERING } ;

STRUCT: D3DDISPLAYMODEFILTER
    { Size                 UINT                }
    { Format               D3DFORMAT           }
    { ScanLineOrdering     D3DSCANLINEORDERING } ;

TYPEDEF: int D3DDISPLAYROTATION
CONSTANT: D3DDISPLAYROTATION_IDENTITY 1
CONSTANT: D3DDISPLAYROTATION_90       2
CONSTANT: D3DDISPLAYROTATION_180      3
CONSTANT: D3DDISPLAYROTATION_270      4  

CONSTANT: D3D9_RESOURCE_PRIORITY_MINIMUM       0x28000000
CONSTANT: D3D9_RESOURCE_PRIORITY_LOW           0x50000000
CONSTANT: D3D9_RESOURCE_PRIORITY_NORMAL        0x78000000
CONSTANT: D3D9_RESOURCE_PRIORITY_HIGH          0xa0000000
CONSTANT: D3D9_RESOURCE_PRIORITY_MAXIMUM       0xc8000000

CONSTANT: D3D_OMAC_SIZE    16

STRUCT: D3D_OMAC
    { Omac BYTE[D3D_OMAC_SIZE] } ;

TYPEDEF: int D3DAUTHENTICATEDCHANNELTYPE
CONSTANT: D3DAUTHENTICATEDCHANNEL_D3D9            1
CONSTANT: D3DAUTHENTICATEDCHANNEL_DRIVER_SOFTWARE 2
CONSTANT: D3DAUTHENTICATEDCHANNEL_DRIVER_HARDWARE 3

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERY_INPUT
    { QueryType        GUID   }
    { hChannel         HANDLE }
    { SequenceNumber   UINT   } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERY_OUTPUT
    { omac                D3D_OMAC }
    { QueryType           GUID     }
    { hChannel            HANDLE   }
    { SequenceNumber      UINT     }
    { ReturnCode          HRESULT  } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_PROTECTION_FLAGS
    { Value  UINT } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYPROTECTION_OUTPUT
    { Output          D3DAUTHENTICATEDCHANNEL_QUERY_OUTPUT     }
    { ProtectionFlags D3DAUTHENTICATEDCHANNEL_PROTECTION_FLAGS } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYCHANNELTYPE_OUTPUT
    { Output      D3DAUTHENTICATEDCHANNEL_QUERY_OUTPUT }
    { ChannelType D3DAUTHENTICATEDCHANNELTYPE          } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYDEVICEHANDLE_OUTPUT
    { Output         D3DAUTHENTICATEDCHANNEL_QUERY_OUTPUT }
    { DeviceHandle   HANDLE                               } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYCRYPTOSESSION_INPUT
    { Input               D3DAUTHENTICATEDCHANNEL_QUERY_INPUT }
    { DXVA2DecodeHandle   HANDLE                              } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYCRYPTOSESSION_OUTPUT
    { Output                D3DAUTHENTICATEDCHANNEL_QUERY_OUTPUT }
    { DXVA2DecodeHandle     HANDLE                               }
    { CryptoSessionHandle   HANDLE                               }
    { DeviceHandle          HANDLE                               } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYRESTRICTEDSHAREDRESOURCEPROCESSCOUNT_OUTPUT
    { Output                                 D3DAUTHENTICATEDCHANNEL_QUERY_OUTPUT }
    { NumRestrictedSharedResourceProcesses   UINT                                 } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYRESTRICTEDSHAREDRESOURCEPROCESS_INPUT
    { Input            D3DAUTHENTICATEDCHANNEL_QUERY_INPUT }
    { ProcessIndex     UINT                                } ;

TYPEDEF: int D3DAUTHENTICATEDCHANNEL_PROCESSIDENTIFIERTYPE
CONSTANT: PROCESSIDTYPE_UNKNOWN  0
CONSTANT: PROCESSIDTYPE_DWM      1
CONSTANT: PROCESSIDTYPE_HANDLE   2

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYRESTRICTEDSHAREDRESOURCEPROCESS_OUTPUT
    { Output           D3DAUTHENTICATEDCHANNEL_QUERY_OUTPUT          }
    { ProcessIndex     UINT                                          }
    { ProcessIdentifer D3DAUTHENTICATEDCHANNEL_PROCESSIDENTIFIERTYPE }
    { ProcessHandle    HANDLE                                        } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYUNRESTRICTEDPROTECTEDSHAREDRESOURCECOUNT_OUTPUT
    { Output                                    D3DAUTHENTICATEDCHANNEL_QUERY_OUTPUT }
    { NumUnrestrictedProtectedSharedResources   UINT                                 } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYOUTPUTIDCOUNT_INPUT
    { Input                D3DAUTHENTICATEDCHANNEL_QUERY_INPUT }
    { DeviceHandle         HANDLE                              }
    { CryptoSessionHandle  HANDLE                              } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYOUTPUTIDCOUNT_OUTPUT
    { Output               D3DAUTHENTICATEDCHANNEL_QUERY_OUTPUT }
    { DeviceHandle         HANDLE                               }
    { CryptoSessionHandle  HANDLE                               }
    { NumOutputIDs         UINT                                 } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYOUTPUTID_INPUT
    { Input                D3DAUTHENTICATEDCHANNEL_QUERY_INPUT }
    { DeviceHandle         HANDLE                              }
    { CryptoSessionHandle  HANDLE                              }
    { OutputIDIndex        UINT                                } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYOUTPUTID_OUTPUT
    { Output               D3DAUTHENTICATEDCHANNEL_QUERY_OUTPUT }
    { DeviceHandle         HANDLE                               }
    { CryptoSessionHandle  HANDLE                               }
    { OutputIDIndex        UINT                                 }
    { OutputID             UINT64                               } ;

TYPEDEF: int D3DBUSTYPE
CONSTANT: D3DBUSTYPE_OTHER                                     0x00000000
CONSTANT: D3DBUSTYPE_PCI                                       0x00000001
CONSTANT: D3DBUSTYPE_PCIX                                      0x00000002
CONSTANT: D3DBUSTYPE_PCIEXPRESS                                0x00000003
CONSTANT: D3DBUSTYPE_AGP                                       0x00000004
CONSTANT: D3DBUSIMPL_MODIFIER_INSIDE_OF_CHIPSET                0x00010000
CONSTANT: D3DBUSIMPL_MODIFIER_TRACKS_ON_MOTHER_BOARD_TO_CHIP   0x00020000
CONSTANT: D3DBUSIMPL_MODIFIER_TRACKS_ON_MOTHER_BOARD_TO_SOCKET 0x00030000
CONSTANT: D3DBUSIMPL_MODIFIER_DAUGHTER_BOARD_CONNECTOR         0x00040000
CONSTANT: D3DBUSIMPL_MODIFIER_DAUGHTER_BOARD_CONNECTOR_INSIDE_OF_NUAE 0x00050000
CONSTANT: D3DBUSIMPL_MODIFIER_NON_STANDARD                     0x80000000

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYINFOBUSTYPE_OUTPUT
    { Output                           D3DAUTHENTICATEDCHANNEL_QUERY_OUTPUT }
    { BusType                          D3DBUSTYPE                           }
    { bAccessibleInContiguousBlocks    BOOL                                 }
    { bAccessibleInNonContiguousBlocks BOOL                                 } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYEVICTIONENCRYPTIONGUIDCOUNT_OUTPUT
    { Output               D3DAUTHENTICATEDCHANNEL_QUERY_OUTPUT }
    { NumEncryptionGuids   UINT                                 } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYEVICTIONENCRYPTIONGUID_INPUT
    { Input               D3DAUTHENTICATEDCHANNEL_QUERY_INPUT }
    { EncryptionGuidIndex UINT                                } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYEVICTIONENCRYPTIONGUID_OUTPUT
    { Output                    D3DAUTHENTICATEDCHANNEL_QUERY_OUTPUT }
    { EncryptionGuidIndex       UINT                                 }
    { EncryptionGuid            GUID                                 } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_QUERYUNCOMPRESSEDENCRYPTIONLEVEL_OUTPUT
    { Output               D3DAUTHENTICATEDCHANNEL_QUERY_OUTPUT }
    { EncryptionGuid       GUID                                 } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_CONFIGURE_INPUT
    { omac                          D3D_OMAC }
    { ConfigureType                 GUID     }
    { hChannel                      HANDLE   }
    { SequenceNumber                UINT     } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_CONFIGURE_OUTPUT
    { omac                          D3D_OMAC }
    { ConfigureType                 GUID     }
    { hChannel                      HANDLE   }
    { SequenceNumber                UINT     }
    { ReturnCode                    HRESULT  } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_CONFIGUREINITIALIZE
    { Parameters               D3DAUTHENTICATEDCHANNEL_CONFIGURE_INPUT }
    { StartSequenceQuery       UINT                                    }
    { StartSequenceConfigure   UINT                                    } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_CONFIGUREPROTECTION
    { Parameters   D3DAUTHENTICATEDCHANNEL_CONFIGURE_INPUT  }
    { Protections  D3DAUTHENTICATEDCHANNEL_PROTECTION_FLAGS } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_CONFIGURECRYPTOSESSION
    { Parameters               D3DAUTHENTICATEDCHANNEL_CONFIGURE_INPUT }
    { DXVA2DecodeHandle        HANDLE                                  }
    { CryptoSessionHandle      HANDLE                                  }
    { DeviceHandle             HANDLE                                  } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_CONFIGURESHAREDRESOURCE
    { Parameters           D3DAUTHENTICATEDCHANNEL_CONFIGURE_INPUT       }
    { ProcessIdentiferType D3DAUTHENTICATEDCHANNEL_PROCESSIDENTIFIERTYPE }
    { ProcessHandle        HANDLE                                        }
    { AllowAccess          BOOL                                          } ;

STRUCT: D3DAUTHENTICATEDCHANNEL_CONFIGUREUNCOMPRESSEDENCRYPTION
    { Parameters      D3DAUTHENTICATEDCHANNEL_CONFIGURE_INPUT }
    { EncryptionGuid  GUID                                    } ;

STRUCT: D3DENCRYPTED_BLOCK_INFO
    { NumEncryptedBytesAtBeginning UINT }
    { NumBytesInSkipPattern        UINT }
    { NumBytesInEncryptPattern     UINT } ;

STRUCT: D3DAES_CTR_IV
    { IV      UINT64 }
    { Count   UINT64 } ;
