/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.FanObj;
import fan.sys.FanStr;
import fan.sys.List;
import fan.sys.ParseErr;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.Version;
import java.util.ArrayList;

public final class Depend
extends FanObj {
    private final String name;
    private final Constraint[] constraints;
    private String str;

    public static Depend fromStr(String string) {
        return Depend.fromStr(string, true);
    }

    public static Depend fromStr(String string, boolean bl) {
        try {
            return new Parser(string).parse();
        }
        catch (Throwable throwable) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("Depend", string);
        }
    }

    private Depend(String string, Constraint[] constraintArray) {
        this.name = string;
        this.constraints = constraintArray;
    }

    public boolean equals(Object object) {
        if (object instanceof Depend) {
            return this.toStr().equals(Depend.toStr(object));
        }
        return false;
    }

    public int hashCode() {
        return this.toStr().hashCode();
    }

    public long hash() {
        return FanStr.hash(this.toStr());
    }

    public Type typeof() {
        return Sys.DependType;
    }

    public String toStr() {
        if (this.str == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.name).append(' ');
            for (int i = 0; i < this.constraints.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                Constraint constraint = this.constraints[i];
                stringBuilder.append(constraint.version);
                if (constraint.isPlus) {
                    stringBuilder.append('+');
                }
                if (constraint.endVersion == null) continue;
                stringBuilder.append('-').append(constraint.endVersion);
            }
            this.str = stringBuilder.toString();
        }
        return this.str;
    }

    public final String name() {
        return this.name;
    }

    public final long size() {
        return this.constraints.length;
    }

    public final Version version() {
        return this.version(0L);
    }

    public final Version version(long l) {
        return this.constraints[(int)l].version;
    }

    public final boolean isPlus() {
        return this.isPlus(0L);
    }

    public final boolean isPlus(long l) {
        return this.constraints[(int)l].isPlus;
    }

    public final boolean isRange() {
        return this.isRange(0L);
    }

    public final boolean isRange(long l) {
        return this.constraints[(int)l].endVersion != null;
    }

    public final Version endVersion() {
        return this.endVersion(0L);
    }

    public final Version endVersion(long l) {
        return this.constraints[(int)l].endVersion;
    }

    public final boolean match(Version version) {
        for (int i = 0; i < this.constraints.length; ++i) {
            Constraint constraint = this.constraints[i];
            if (!(constraint.isPlus ? constraint.version.compare(version) <= 0L : (constraint.endVersion != null ? constraint.version.compare(version) <= 0L && (constraint.endVersion.compare(version) >= 0L || Depend.doMatch(constraint.endVersion, version)) : Depend.doMatch(constraint.version, version)))) continue;
            return true;
        }
        return false;
    }

    private static boolean doMatch(Version version, Version version2) {
        if (version.segments().sz() > version2.segments().sz()) {
            return false;
        }
        for (int i = 0; i < version.segments().sz(); ++i) {
            if (version.segment(i) == version2.segment(i)) continue;
            return false;
        }
        return true;
    }

    static class Constraint {
        Version version;
        boolean isPlus;
        Version endVersion;

        Constraint() {
        }
    }

    static class Parser {
        int cur;
        int pos;
        int len;
        String str;
        String name;
        ArrayList constraints = new ArrayList(4);

        Parser(String string) {
            this.str = string;
            this.len = string.length();
            this.consume();
        }

        Depend parse() {
            this.name = this.name();
            this.constraints.add(this.constraint());
            while (this.cur == 44) {
                this.consume();
                this.consumeSpaces();
                this.constraints.add(this.constraint());
            }
            if (this.pos <= this.len) {
                throw new RuntimeException();
            }
            return new Depend(this.name, this.constraints.toArray(new Constraint[this.constraints.size()]));
        }

        private String name() {
            StringBuilder stringBuilder = new StringBuilder();
            while (this.cur != 32) {
                if (this.cur < 0) {
                    throw new RuntimeException();
                }
                stringBuilder.append((char)this.cur);
                this.consume();
            }
            this.consumeSpaces();
            if (stringBuilder.length() == 0) {
                throw new RuntimeException();
            }
            return stringBuilder.toString();
        }

        private Constraint constraint() {
            Constraint constraint = new Constraint();
            constraint.version = this.version();
            this.consumeSpaces();
            if (this.cur == 43) {
                constraint.isPlus = true;
                this.consume();
                this.consumeSpaces();
            } else if (this.cur == 45) {
                this.consume();
                this.consumeSpaces();
                constraint.endVersion = this.version();
                this.consumeSpaces();
            }
            return constraint;
        }

        private Version version() {
            List list = new List(Sys.IntType, 4);
            int n = this.consumeDigit();
            while (true) {
                if (48 <= this.cur && this.cur <= 57) {
                    n = n * 10 + this.consumeDigit();
                    continue;
                }
                list.add(n);
                n = 0;
                if (this.cur != 46) break;
                this.consume();
            }
            return new Version(list);
        }

        private int consumeDigit() {
            if (48 <= this.cur && this.cur <= 57) {
                int n = this.cur - 48;
                this.consume();
                return n;
            }
            throw new RuntimeException();
        }

        private void consumeSpaces() {
            while (this.cur == 32) {
                this.consume();
            }
        }

        private void consume() {
            if (this.pos < this.len) {
                this.cur = this.str.charAt(this.pos++);
            } else {
                this.cur = -1;
                this.pos = this.len + 1;
            }
        }
    }
}

