/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.DateTime;
import fan.sys.Duration;
import fan.sys.Env;
import fan.sys.Err;
import fan.sys.FanFloat;
import fan.sys.FanNum;
import fan.sys.FanStr;
import fan.sys.Func;
import fan.sys.Locale;
import fan.sys.NumDigits;
import fan.sys.NumPattern;
import fan.sys.ParseErr;
import fan.sys.Range;
import fan.sys.Sys;
import fan.sys.TimeZone;
import fan.sys.Type;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.text.DecimalFormatSymbols;
import java.util.Random;

public final class FanInt {
    static final Random random = new SecureRandom();
    static final byte[] charMap = new byte[128];
    static final int SPACE = 1;
    static final int UPPER = 2;
    static final int LOWER = 4;
    static final int DIGIT = 8;
    static final int HEX = 16;
    static final int ALPHA = 6;
    static final int ALPHANUM = 14;
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    public static final long maxVal = Long.MAX_VALUE;
    public static final long minVal = Long.MIN_VALUE;
    public static final long defVal = 0L;
    public static final Long Chunk;
    static final Long[] pos;

    public static Long fromStr(String string) {
        return FanInt.fromStr(string, 10L, true);
    }

    public static Long fromStr(String string, long l) {
        return FanInt.fromStr(string, l, true);
    }

    public static Long fromStr(String string, long l, boolean bl) {
        try {
            if (l == 16L) {
                return FanInt.parseHex(string);
            }
            if (l == 10L) {
                return Long.valueOf(string);
            }
            if (string.charAt(0) == '-') {
                throw new NumberFormatException();
            }
            return Long.valueOf(string, (int)l);
        }
        catch (NumberFormatException numberFormatException) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("Int", string);
        }
    }

    private static Long parseHex(String string) {
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            int n;
            char c = string.charAt(i);
            if ('0' <= c && c <= '9') {
                n = c - 48;
            } else if ('a' <= c && c <= 'f') {
                n = 10 + c - 97;
            } else if ('A' <= c && c <= 'F') {
                n = 10 + c - 65;
            } else {
                throw new NumberFormatException();
            }
            l = l << 4 | (long)n;
        }
        return l;
    }

    public static long random() {
        return FanInt.random(null);
    }

    public static long random(Range range) {
        long l = random.nextLong();
        if (range == null) {
            return l;
        }
        if (l < 0L) {
            l = -l;
        }
        long l2 = range.start();
        long l3 = range.end();
        if (range.inclusive()) {
            ++l3;
        }
        if (l3 <= l2) {
            throw ArgErr.make("Range end < start: " + range);
        }
        return l2 + l % (l3 - l2);
    }

    public static boolean equals(long l, Object object) {
        if (object instanceof Long) {
            return l == (Long)object;
        }
        return false;
    }

    public static long compare(long l, Object object) {
        long l2 = (Long)object;
        if (l < l2) {
            return -1L;
        }
        return l == l2 ? 0L : 1L;
    }

    public static long hash(long l) {
        return l;
    }

    public static Type typeof(long l) {
        return Sys.IntType;
    }

    public static long negate(long l) {
        return -l;
    }

    public static long increment(long l) {
        return l + 1L;
    }

    public static long decrement(long l) {
        return l - 1L;
    }

    public static long mult(long l, long l2) {
        return l * l2;
    }

    public static double multFloat(long l, double d) {
        return (double)l * d;
    }

    public static BigDecimal multDecimal(long l, BigDecimal bigDecimal) {
        return BigDecimal.valueOf(l).multiply(bigDecimal);
    }

    public static long div(long l, long l2) {
        return l / l2;
    }

    public static double divFloat(long l, double d) {
        return (double)l / d;
    }

    public static BigDecimal divDecimal(long l, BigDecimal bigDecimal) {
        return BigDecimal.valueOf(l).divide(bigDecimal);
    }

    public static long mod(long l, long l2) {
        return l % l2;
    }

    public static double modFloat(long l, double d) {
        return (double)l % d;
    }

    public static BigDecimal modDecimal(long l, BigDecimal bigDecimal) {
        return BigDecimal.valueOf(l).remainder(bigDecimal);
    }

    public static long plus(long l, long l2) {
        return l + l2;
    }

    public static double plusFloat(long l, double d) {
        return (double)l + d;
    }

    public static BigDecimal plusDecimal(long l, BigDecimal bigDecimal) {
        return BigDecimal.valueOf(l).add(bigDecimal);
    }

    public static long minus(long l, long l2) {
        return l - l2;
    }

    public static double minusFloat(long l, double d) {
        return (double)l - d;
    }

    public static BigDecimal minusDecimal(long l, BigDecimal bigDecimal) {
        return BigDecimal.valueOf(l).subtract(bigDecimal);
    }

    public static long not(long l) {
        return l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long and(long l, long l2) {
        return l & l2;
    }

    public static long or(long l, long l2) {
        return l | l2;
    }

    public static long xor(long l, long l2) {
        return l ^ l2;
    }

    public static long shiftl(long l, long l2) {
        return l << (int)l2;
    }

    public static long shiftr(long l, long l2) {
        return l >>> (int)l2;
    }

    public static long abs(long l) {
        if (l >= 0L) {
            return l;
        }
        return -l;
    }

    public static long min(long l, long l2) {
        if (l <= l2) {
            return l;
        }
        return l2;
    }

    public static long max(long l, long l2) {
        if (l >= l2) {
            return l;
        }
        return l2;
    }

    public static long pow(long l, long l2) {
        if (l2 < 0L) {
            throw ArgErr.make("pow < 0");
        }
        long l3 = 1L;
        while (l2 > 0L) {
            if ((l2 & 1L) == 1L) {
                l3 *= l;
            }
            l *= l;
            l2 >>= 1;
        }
        return l3;
    }

    public static boolean isEven(long l) {
        return l % 2L == 0L;
    }

    public static boolean isOdd(long l) {
        return l % 2L != 0L;
    }

    public static boolean isSpace(long l) {
        try {
            return l < 128L && (charMap[(int)l] & 1) != 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public static boolean isAlpha(long l) {
        try {
            return l < 128L && (charMap[(int)l] & 6) != 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public static boolean isAlphaNum(long l) {
        try {
            return l < 128L && (charMap[(int)l] & 0xE) != 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public static boolean isUpper(long l) {
        return 65L <= l && l <= 90L;
    }

    public static boolean isLower(long l) {
        return 97L <= l && l <= 122L;
    }

    public static long upper(long l) {
        if (97L <= l && l <= 122L) {
            return l & 0xFFFFFFFFFFFFFFDFL;
        }
        return l;
    }

    public static long lower(long l) {
        if (65L <= l && l <= 90L) {
            return l | 0x20L;
        }
        return l;
    }

    public static boolean isDigit(long l) {
        return 48L <= l && l <= 57L;
    }

    public static boolean isDigit(long l, long l2) {
        if (l < 0L || l >= 128L) {
            return false;
        }
        int n = (int)l;
        int n2 = (int)l2;
        if (n2 == 10) {
            return (charMap[n] & 8) != 0;
        }
        if (n2 == 16) {
            return (charMap[n] & 0x10) != 0;
        }
        if (n2 <= 10) {
            return 48 <= n && n <= 48 + n2;
        }
        if ((charMap[n] & 8) != 0) {
            return true;
        }
        int n3 = n2 - 10;
        if (97 <= n && n < 97 + n3) {
            return true;
        }
        return 65 <= n && n < 65 + n3;
    }

    public static Long toDigit(long l) {
        if (0L <= l && l <= 9L) {
            return pos[(int)l + 48];
        }
        return null;
    }

    public static Long toDigit(long l, long l2) {
        if (l < 0L || l >= l2) {
            return null;
        }
        if (l < 10L) {
            return pos[(int)l + 48];
        }
        return pos[(int)l - 10 + 97];
    }

    public static Long fromDigit(long l) {
        if (48L <= l && l <= 57L) {
            return pos[(int)l - 48];
        }
        return null;
    }

    public static Long fromDigit(long l, long l2) {
        int n;
        if (l < 0L || l >= 128L) {
            return null;
        }
        int n2 = (int)l;
        int n3 = (int)l2;
        int n4 = n = n3 < 10 ? n3 : 10;
        if (48 <= n2 && n2 < 48 + n) {
            return pos[n2 - 48];
        }
        if (n3 > 10) {
            int n5 = n3 - 10;
            if (97 <= n2 && n2 < 97 + n5) {
                return pos[n2 + 10 - 97];
            }
            if (65 <= n2 && n2 < 65 + n5) {
                return pos[n2 + 10 - 65];
            }
        }
        return null;
    }

    public static boolean equalsIgnoreCase(long l, long l2) {
        if (65L <= l && l <= 90L) {
            l |= 0x20L;
        }
        if (65L <= l2 && l2 <= 90L) {
            l2 |= 0x20L;
        }
        return l == l2;
    }

    public static String toLocale(long l) {
        return FanInt.toLocale(l, null);
    }

    public static String toLocale(long l, String string) {
        if (string != null && string.length() == 1 && string.charAt(0) == 'B') {
            return FanInt.toLocaleBytes(l);
        }
        Locale locale = Locale.cur();
        DecimalFormatSymbols decimalFormatSymbols = locale.decimal();
        if (string == null) {
            string = Env.cur().locale(Sys.sysPod, "int", "#,###");
        }
        NumPattern numPattern = NumPattern.parse(string);
        NumDigits numDigits = new NumDigits(l);
        return FanNum.toLocale(numPattern, numDigits, decimalFormatSymbols);
    }

    static String toLocaleBytes(long l) {
        if (l < 1024L) {
            return l + "B";
        }
        if (l < 10240L) {
            return FanFloat.toLocale((double)l / 1024.0, "#.#") + "KB";
        }
        if (l < 0x100000L) {
            return Math.round((double)l / 1024.0) + "KB";
        }
        if (l < 0xA00000L) {
            return FanFloat.toLocale((double)l / 1048576.0, "#.#") + "MB";
        }
        if (l < 0x40000000L) {
            return Math.round((double)l / 1048576.0) + "MB";
        }
        if (l < 0x280000000L) {
            return FanFloat.toLocale((double)l / 1.073741824E9, "#.#") + "GB";
        }
        return Math.round((double)l / 1.073741824E9) + "GB";
    }

    public static boolean localeIsUpper(long l) {
        return Character.isUpperCase((int)l);
    }

    public static boolean localeIsLower(long l) {
        return Character.isLowerCase((int)l);
    }

    public static long localeUpper(long l) {
        return Character.toString((char)l).toUpperCase(Locale.cur().java()).charAt(0);
    }

    public static long localeLower(long l) {
        return Character.toString((char)l).toLowerCase(Locale.cur().java()).charAt(0);
    }

    public static String toChar(long l) {
        if (l < 0L || l > 65535L) {
            throw Err.make("Invalid unicode char: " + l);
        }
        if (l < (long)FanStr.ascii.length) {
            return FanStr.ascii[(int)l];
        }
        return String.valueOf((char)l);
    }

    public static String toHex(long l) {
        return FanInt.toHex(l, null);
    }

    public static String toHex(long l, Long l2) {
        String string = Long.toHexString(l);
        if (l2 != null && string.length() < l2.intValue()) {
            StringBuilder stringBuilder = new StringBuilder(l2.intValue());
            int n = l2.intValue() - string.length();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
            string = stringBuilder.toString();
        }
        return string;
    }

    public static String toStr(long l) {
        return String.valueOf(l);
    }

    public static String toCode(long l) {
        return String.valueOf(l);
    }

    public static String toCode(long l, long l2) {
        if (l2 == 10L) {
            return String.valueOf(l);
        }
        if (l2 == 16L) {
            return "0x" + Long.toHexString(l);
        }
        throw ArgErr.make("Invalid base " + l2);
    }

    public static Duration toDuration(long l) {
        return Duration.make(l);
    }

    public static DateTime toDateTime(long l) {
        return DateTime.makeTicks(l);
    }

    public static DateTime toDateTime(long l, TimeZone timeZone) {
        return DateTime.makeTicks(l, timeZone);
    }

    public static void times(long l, Func func) {
        if (func.arity() == 0L) {
            for (long i = 0L; i < l; ++i) {
                func.call();
            }
        } else {
            for (long i = 0L; i < l; ++i) {
                func.call(i);
            }
        }
    }

    static {
        charMap[32] = (byte)(charMap[32] | 1);
        charMap[10] = (byte)(charMap[10] | 1);
        charMap[13] = (byte)(charMap[13] | 1);
        charMap[9] = (byte)(charMap[9] | 1);
        charMap[12] = (byte)(charMap[12] | 1);
        int n = 97;
        while (n <= 122) {
            int n2 = n++;
            charMap[n2] = (byte)(charMap[n2] | 4);
        }
        n = 65;
        while (n <= 90) {
            int n3 = n++;
            charMap[n3] = (byte)(charMap[n3] | 2);
        }
        n = 48;
        while (n <= 57) {
            int n4 = n++;
            charMap[n4] = (byte)(charMap[n4] | 8);
        }
        n = 48;
        while (n <= 57) {
            int n5 = n++;
            charMap[n5] = (byte)(charMap[n5] | 0x10);
        }
        n = 97;
        while (n <= 102) {
            int n6 = n++;
            charMap[n6] = (byte)(charMap[n6] | 0x10);
        }
        n = 65;
        while (n <= 70) {
            int n7 = n++;
            charMap[n7] = (byte)(charMap[n7] | 0x10);
        }
        Chunk = 4096L;
        pos = new Long[256];
        for (n = 0; n < pos.length; ++n) {
            FanInt.pos[n] = n;
        }
    }
}

