/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.Buf;
import fan.sys.Charset;
import fan.sys.Endian;
import fan.sys.FanDecimal;
import fan.sys.FanInt;
import fan.sys.FanObj;
import fan.sys.FanStr;
import fan.sys.Func;
import fan.sys.IOErr;
import fan.sys.List;
import fan.sys.Map;
import fan.sys.OutStream;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.UnsupportedErr;
import fanx.serial.ObjDecoder;
import java.math.BigDecimal;

public class InStream
extends FanObj {
    InStream in;
    boolean bigEndian = true;
    Charset charset = Charset.utf8();
    Charset.Decoder charsetDecoder = this.charset.newDecoder();
    Charset.Encoder charsetEncoder = this.charset.newEncoder();

    public static InStream make(InStream inStream) {
        InStream inStream2 = new InStream();
        InStream.make$(inStream2, inStream);
        return inStream2;
    }

    public static void make$(InStream inStream, InStream inStream2) {
        inStream.in = inStream2;
    }

    public Type typeof() {
        return Sys.InStreamType;
    }

    public int r() {
        Long l = this.read();
        if (l == null) {
            return -1;
        }
        return l.intValue();
    }

    public InStream unread(int n) {
        return this.unread((long)n);
    }

    public int rChar() {
        if (this.in != null) {
            return this.in.rChar();
        }
        return this.charsetDecoder.decode(this);
    }

    public InStream unreadChar(int n) {
        return this.unreadChar((long)n);
    }

    public Long read() {
        try {
            return this.in.read();
        }
        catch (NullPointerException nullPointerException) {
            if (this.in == null) {
                throw UnsupportedErr.make(this.typeof().qname() + " wraps null InStream");
            }
            throw nullPointerException;
        }
    }

    public Long readBuf(Buf buf, long l) {
        try {
            return this.in.readBuf(buf, l);
        }
        catch (NullPointerException nullPointerException) {
            if (this.in == null) {
                throw UnsupportedErr.make(this.typeof().qname() + " wraps null InStream");
            }
            throw nullPointerException;
        }
    }

    public InStream unread(long l) {
        try {
            this.in.unread(l);
            return this;
        }
        catch (NullPointerException nullPointerException) {
            if (this.in == null) {
                throw UnsupportedErr.make(this.typeof().qname() + " wraps null InStream");
            }
            throw nullPointerException;
        }
    }

    public long skip(long l) {
        if (this.in != null) {
            return this.in.skip(l);
        }
        long l2 = l;
        int n = 0;
        while ((long)n < l2) {
            if (this.r() < 0) {
                return n;
            }
            ++n;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buf readAllBuf() {
        try {
            long l = FanInt.Chunk;
            Buf buf = Buf.make(l);
            while (this.readBuf(buf, l) != null) {
            }
            buf.flip();
            Buf buf2 = buf;
            return buf2;
        }
        finally {
            try {
                this.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Buf readBufFully(Buf buf, long l) {
        Long l2;
        if (buf == null) {
            buf = Buf.make(l);
        }
        long l3 = l;
        for (long i = 0L; i < l3; i += l2.longValue()) {
            l2 = this.readBuf(buf, l3 - i);
            if (l2 != null && l2 != 0L) continue;
            throw IOErr.make("Unexpected end of stream");
        }
        buf.flip();
        return buf;
    }

    public Endian endian() {
        return this.bigEndian ? Endian.big : Endian.little;
    }

    public void endian(Endian endian) {
        this.bigEndian = endian == Endian.big;
    }

    public Long peek() {
        Long l = this.read();
        if (l != null) {
            this.unread(l);
        }
        return l;
    }

    public long readU1() {
        int n = this.r();
        if (n < 0) {
            throw IOErr.make("Unexpected end of stream");
        }
        return n;
    }

    public long readS1() {
        int n = this.r();
        if (n < 0) {
            throw IOErr.make("Unexpected end of stream");
        }
        return (byte)n;
    }

    public long readU2() {
        int n;
        int n2 = this.r();
        if ((n2 | (n = this.r())) < 0) {
            throw IOErr.make("Unexpected end of stream");
        }
        if (this.bigEndian) {
            return n2 << 8 | n;
        }
        return n << 8 | n2;
    }

    public long readS2() {
        int n;
        int n2 = this.r();
        if ((n2 | (n = this.r())) < 0) {
            throw IOErr.make("Unexpected end of stream");
        }
        if (this.bigEndian) {
            return (short)(n2 << 8 | n);
        }
        return (short)(n << 8 | n2);
    }

    public long readU4() {
        long l;
        long l2;
        long l3;
        long l4 = this.r();
        if ((l4 | (l3 = (long)this.r()) | (l2 = (long)this.r()) | (l = (long)this.r())) < 0L) {
            throw IOErr.make("Unexpected end of stream");
        }
        if (this.bigEndian) {
            return (l4 << 24) + (l3 << 16) + (l2 << 8) + l;
        }
        return (l << 24) + (l2 << 16) + (l3 << 8) + l4;
    }

    public long readS4() {
        int n;
        int n2;
        int n3;
        int n4 = this.r();
        if ((n4 | (n3 = this.r()) | (n2 = this.r()) | (n = this.r())) < 0) {
            throw IOErr.make("Unexpected end of stream");
        }
        if (this.bigEndian) {
            return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    public long readS8() {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8 = this.r();
        if ((l8 | (l7 = (long)this.r()) | (l6 = (long)this.r()) | (l5 = (long)this.r()) | (l4 = (long)this.r()) | (l3 = (long)this.r()) | (l2 = (long)this.r()) | (l = (long)this.r())) < 0L) {
            throw IOErr.make("Unexpected end of stream");
        }
        if (this.bigEndian) {
            return (l8 << 56) + (l7 << 48) + (l6 << 40) + (l5 << 32) + (l4 << 24) + (l3 << 16) + (l2 << 8) + l;
        }
        return (l << 56) + (l2 << 48) + (l3 << 40) + (l4 << 32) + (l5 << 24) + (l6 << 16) + (l7 << 8) + l8;
    }

    public double readF4() {
        return Float.intBitsToFloat((int)this.readS4());
    }

    public double readF8() {
        return Double.longBitsToDouble(this.readS8());
    }

    public BigDecimal readDecimal() {
        return FanDecimal.fromStr(this.readUtf(), true);
    }

    public boolean readBool() {
        int n = this.r();
        if (n < 0) {
            throw IOErr.make("Unexpected end of stream");
        }
        return n != 0;
    }

    public String readUtf() {
        int n;
        int n2 = this.r();
        if ((n2 | (n = this.r())) < 0) {
            throw IOErr.make("Unexpected end of stream");
        }
        int n3 = n2 << 8 | n;
        char[] cArray = new char[n3];
        int n4 = 0;
        int n5 = 0;
        block5: while (n4 < n3) {
            int n6 = this.r();
            ++n4;
            if (n6 < 0) {
                throw IOErr.make("Unexpected end of stream");
            }
            switch (n6 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n5++] = (char)n6;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if (n4 >= n3) {
                        throw IOErr.make("UTF encoding error");
                    }
                    int n7 = this.r();
                    ++n4;
                    if (n7 < 0) {
                        throw IOErr.make("Unexpected end of stream");
                    }
                    if ((n7 & 0xC0) != 128) {
                        throw IOErr.make("UTF encoding error");
                    }
                    cArray[n5++] = (char)((n6 & 0x1F) << 6 | n7 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if (n4 + 1 >= n3) {
                        throw IOErr.make("UTF encoding error");
                    }
                    int n7 = this.r();
                    ++n4;
                    int n8 = this.r();
                    ++n4;
                    if ((n7 | n8) < 0) {
                        throw IOErr.make("Unexpected end of stream");
                    }
                    if ((n7 & 0xC0) != 128 || (n8 & 0xC0) != 128) {
                        throw IOErr.make("UTF encoding error");
                    }
                    cArray[n5++] = (char)((n6 & 0xF) << 12 | (n7 & 0x3F) << 6 | (n8 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw IOErr.make("UTF encoding error");
        }
        return new String(cArray, 0, n5);
    }

    public Charset charset() {
        return this.charset;
    }

    public void charset(Charset charset) {
        this.charsetDecoder = charset.newDecoder();
        this.charsetEncoder = charset.newEncoder();
        this.charset = charset;
    }

    public Long readChar() {
        if (this.in != null) {
            return this.in.readChar();
        }
        int n = this.charsetDecoder.decode(this);
        return n < 0 ? null : Long.valueOf(n);
    }

    public InStream unreadChar(long l) {
        if (this.in != null) {
            this.in.unreadChar(l);
        } else {
            this.charsetEncoder.encode((char)l, this);
        }
        return this;
    }

    public Long peekChar() {
        Long l = this.readChar();
        if (l != null) {
            this.unreadChar(l);
        }
        return l;
    }

    public String readChars(long l) {
        if (l < 0L) {
            throw ArgErr.make("readChars n < 0: " + l);
        }
        if (l == 0L) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        for (int i = (int)l; i > 0; --i) {
            int n = this.rChar();
            if (n < 0) {
                throw IOErr.make("Unexpected end of stream");
            }
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    public String readLine() {
        return this.readLine(FanInt.Chunk);
    }

    public String readLine(Long l) {
        int n;
        int n2 = Integer.MAX_VALUE;
        if (l != null) {
            long l2 = l;
            if (l2 == 0L) {
                return "";
            }
            if (l2 < 0L) {
                throw ArgErr.make("Invalid max: " + l);
            }
            if (l2 < Integer.MAX_VALUE) {
                n2 = (int)l2;
            }
        }
        if ((n = this.rChar()) < 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        while (n != 10) {
            if (n == 13) {
                n = this.rChar();
                if (n < 0 || n == 10) break;
                this.unreadChar(n);
                break;
            }
            stringBuilder.append((char)n);
            if (stringBuilder.length() < n2 && (n = this.rChar()) >= 0) continue;
            break;
        }
        return stringBuilder.toString();
    }

    public String readStrToken() {
        return this.readStrToken(FanInt.Chunk, null);
    }

    public String readStrToken(Long l) {
        return this.readStrToken(l, null);
    }

    public String readStrToken(Long l, Func func) {
        int n;
        int n2 = n = l != null ? l.intValue() : Integer.MAX_VALUE;
        if (n <= 0) {
            return "";
        }
        int n3 = this.rChar();
        if (n3 < 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        do {
            boolean bl;
            if (bl = func == null ? FanInt.isSpace(n3) : (Boolean)func.call(n3)) {
                this.unreadChar(n3);
                break;
            }
            stringBuilder.append((char)n3);
        } while (stringBuilder.length() < n && (n3 = this.rChar()) >= 0);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List readAllLines() {
        try {
            String string;
            List list = new List(Sys.StrType);
            while ((string = this.readLine()) != null) {
                list.add(string);
            }
            List list2 = list;
            return list2;
        }
        finally {
            try {
                this.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eachLine(Func func) {
        try {
            String string;
            while ((string = this.readLine()) != null) {
                func.call(string);
            }
        }
        finally {
            try {
                this.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String readAllStr() {
        return this.readAllStr(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readAllStr(boolean bl) {
        try {
            int n;
            char[] cArray = new char[4096];
            int n2 = 0;
            boolean bl2 = bl;
            int n3 = -1;
            while ((n = this.rChar()) >= 0) {
                if (n2 >= cArray.length) {
                    char[] cArray2 = new char[cArray.length * 2];
                    System.arraycopy(cArray, 0, cArray2, 0, n2);
                    cArray = cArray2;
                }
                if (bl2) {
                    if (n == 13) {
                        cArray[n2++] = 10;
                    } else if (n3 != 13 || n != 10) {
                        cArray[n2++] = (char)n;
                    }
                    n3 = n;
                    continue;
                }
                cArray[n2++] = (char)n;
            }
            String string = new String(cArray, 0, n2);
            return string;
        }
        finally {
            try {
                this.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Object readObj() {
        return this.readObj(null);
    }

    public Object readObj(Map map) {
        return new ObjDecoder(this, map).readObj();
    }

    public Map readProps() {
        return this.readProps(false);
    }

    public Map readPropsListVals() {
        return this.readProps(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map readProps(boolean bl) {
        Charset charset = this.charset();
        this.charset(Charset.utf8());
        try {
            Map map = new Map(Sys.StrType, bl ? Sys.StrType.toListOf() : Sys.StrType);
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = null;
            int n = 0;
            boolean bl2 = false;
            int n2 = 32;
            int n3 = 32;
            int n4 = 1;
            while (true) {
                n3 = n2;
                n2 = this.rChar();
                if (n2 < 0) break;
                if (n2 == 10 || n2 == 13) {
                    bl2 = false;
                    if (n3 == 13 && n2 == 10) continue;
                    String string = FanStr.makeTrim(stringBuilder);
                    if (stringBuilder2 != null) {
                        InStream.addProp(map, string, FanStr.makeTrim(stringBuilder2), bl);
                        stringBuilder = new StringBuilder();
                        stringBuilder2 = null;
                    } else if (string.length() > 0) {
                        throw IOErr.make("Invalid name/value pair [Line " + n4 + "]");
                    }
                    ++n4;
                    continue;
                }
                if (bl2) continue;
                if (n > 0) {
                    if (n3 == 47 && n2 == 42) {
                        ++n;
                    }
                    if (n3 != 42 || n2 != 47) continue;
                    --n;
                    continue;
                }
                if (n2 == 61 && stringBuilder2 == null) {
                    stringBuilder2 = new StringBuilder();
                    continue;
                }
                if (n2 == 47 && FanInt.isSpace(n3)) {
                    int n5 = this.rChar();
                    if (n5 < 0) break;
                    if (n5 == 47) {
                        bl2 = true;
                        continue;
                    }
                    if (n5 == 42) {
                        ++n;
                        continue;
                    }
                    this.unreadChar(n5);
                }
                if (n2 == 92) {
                    int n6 = this.rChar();
                    if (n6 < 0) break;
                    if (n6 == 110) {
                        n2 = 10;
                    } else if (n6 == 114) {
                        n2 = 13;
                    } else if (n6 == 116) {
                        n2 = 9;
                    } else if (n6 == 92) {
                        n2 = 92;
                    } else {
                        if (n6 == 13 || n6 == 10) {
                            ++n4;
                            if (n6 == 13 && (n6 = this.rChar()) != 10) {
                                this.unreadChar(n6);
                            }
                            while ((n6 = this.rChar()) == 32 || n6 == 9) {
                            }
                            this.unreadChar(n6);
                            continue;
                        }
                        if (n6 == 117) {
                            int n7 = InStream.hex(this.rChar());
                            int n8 = InStream.hex(this.rChar());
                            int n9 = InStream.hex(this.rChar());
                            int n10 = InStream.hex(this.rChar());
                            if (n7 < 0 || n8 < 0 || n9 < 0 || n10 < 0) {
                                throw IOErr.make("Invalid hex value for \\uxxxx [Line " + n4 + "]");
                            }
                            n2 = n7 << 12 | n8 << 8 | n9 << 4 | n10;
                        } else {
                            throw IOErr.make("Invalid escape sequence [Line " + n4 + "]");
                        }
                    }
                }
                if (stringBuilder2 == null) {
                    stringBuilder.append((char)n2);
                    continue;
                }
                stringBuilder2.append((char)n2);
            }
            String string = FanStr.makeTrim(stringBuilder);
            if (stringBuilder2 != null) {
                InStream.addProp(map, string, FanStr.makeTrim(stringBuilder2), bl);
            } else if (string.length() > 0) {
                throw IOErr.make("Invalid name/value pair [Line " + n4 + "]");
            }
            Map map2 = map;
            return map2;
        }
        finally {
            try {
                this.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.charset(charset);
        }
    }

    static void addProp(Map map, String string, String string2, boolean bl) {
        if (bl) {
            List list = (List)map.get(string);
            if (list == null) {
                list = new List(Sys.StrType);
                map.add(string, list);
            }
            list.add(string2);
        } else {
            map.add(string, string2);
        }
    }

    static int hex(int n) {
        if (48 <= n && n <= 57) {
            return n - 48;
        }
        if (97 <= n && n <= 102) {
            return n - 97 + 10;
        }
        if (65 <= n && n <= 70) {
            return n - 65 + 10;
        }
        return -1;
    }

    public long pipe(OutStream outStream) {
        return this.pipe(outStream, null, true);
    }

    public long pipe(OutStream outStream, Long l) {
        return this.pipe(outStream, l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long pipe(OutStream outStream, Long l, boolean bl) {
        try {
            long l2;
            long l3 = FanInt.Chunk;
            Buf buf = Buf.make(l3);
            if (l == null) {
                Long l4;
                while ((l4 = this.readBuf(buf.clear(), l3)) != null) {
                    outStream.writeBuf(buf.flip(), buf.remaining());
                    l2 += l4.longValue();
                }
            } else {
                Long l5;
                long l6 = l;
                for (l2 = 0L; l2 < l6; l2 += l5.longValue()) {
                    if (l6 - l2 < l3) {
                        l3 = l6 - l2;
                    }
                    if ((l5 = this.readBuf(buf.clear(), l3)) == null) {
                        throw IOErr.make("Unexpected end of stream");
                    }
                    outStream.writeBuf(buf.flip(), buf.remaining());
                }
            }
            long l7 = l2;
            return l7;
        }
        finally {
            if (bl) {
                this.close();
            }
        }
    }

    public boolean close() {
        if (this.in != null) {
            return this.in.close();
        }
        return true;
    }
}

