/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ClassType;
import fan.sys.Duration;
import fan.sys.Env;
import fan.sys.File;
import fan.sys.InStream;
import fan.sys.List;
import fan.sys.Map;
import fan.sys.Pod;
import fan.sys.Sys;
import fan.sys.SysInStream;
import fan.sys.Type;
import fan.sys.UnresolvedErr;
import fan.sys.Uri;
import java.io.InputStream;
import java.util.HashMap;

public class JarDistEnv
extends Env {
    private HashMap propsCache = new HashMap();

    public static JarDistEnv make() {
        return new JarDistEnv(Env.cur());
    }

    public JarDistEnv(Env env) {
        super(env);
    }

    public Type typeof() {
        return Sys.JarDistEnvType;
    }

    public Map props(Pod pod, Uri uri, Duration duration) {
        String string = "res/" + pod.name() + "/" + uri;
        Map map = (Map)this.propsCache.get(string);
        if (map == null) {
            InputStream inputStream = JarDistEnv.class.getClassLoader().getResourceAsStream(string);
            if (inputStream != null) {
                SysInStream sysInStream = new SysInStream(inputStream);
                map = sysInStream.readProps();
                ((InStream)sysInStream).close();
            }
            map = map == null ? Sys.emptyStrStrMap : (Map)map.toImmutable();
            this.propsCache.put(string, map);
        }
        return map;
    }

    public File findFile(Uri uri, boolean bl) {
        System.out.println("WARN: JarDistEnv.findFile not implemented: " + uri);
        if (!bl) {
            return null;
        }
        throw UnresolvedErr.make("File not found in Env: " + uri);
    }

    public List findAllFiles(Uri uri) {
        File file = this.findFile(uri, false);
        if (file == null) {
            return Sys.FileType.emptyList();
        }
        return new List(Sys.FileType, new File[]{file});
    }

    public Class loadPodClass(Pod pod) {
        try {
            String string = "fan." + pod.name() + ".$Pod";
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
            pod.precompiled(clazz);
            return clazz;
        }
        catch (Exception exception) {
            return super.loadPodClass(pod);
        }
    }

    public Class[] loadTypeClasses(ClassType classType) {
        try {
            String string = "fan." + classType.pod().name() + "." + classType.name();
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
            classType.precompiled(clazz);
            return new Class[]{clazz};
        }
        catch (Exception exception) {
            return super.loadTypeClasses(classType);
        }
    }
}

