/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.FanObj;
import fan.sys.FanStr;
import fan.sys.Func;
import fan.sys.Month;
import fan.sys.NullErr;
import fan.sys.ParseErr;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.Uri;
import java.text.Collator;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;

public class Locale
extends FanObj {
    static final ThreadLocal cur;
    static final Locale defaultLocale;
    public static final Locale en;
    final String str;
    final String lang;
    final String country;
    public final Uri strProps;
    public final Uri langProps;
    java.util.Locale javaLocale;
    Collator javaCollator;
    DecimalFormatSymbols javaDecimal;
    HashMap monthsByName;

    public static Locale fromStr(String string) {
        return Locale.fromStr(string, true);
    }

    public static Locale fromStr(String string, boolean bl) {
        int n = string.length();
        try {
            if (n == 2 && FanStr.isLower(string)) {
                return new Locale(string, string, null);
            }
            if (n == 5) {
                String string2 = string.substring(0, 2);
                String string3 = string.substring(3, 5);
                if (FanStr.isLower(string2) && FanStr.isUpper(string3) && string.charAt(2) == '-') {
                    return new Locale(string, string2, string3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            return null;
        }
        throw ParseErr.make("Locale", string);
    }

    private Locale(String string, String string2, String string3) {
        this.str = string;
        this.lang = string2;
        this.country = string3;
        this.strProps = Uri.fromStr("locale/" + string + ".props");
        this.langProps = Uri.fromStr("locale/" + string2 + ".props");
    }

    public static Locale cur() {
        return (Locale)cur.get();
    }

    public static void setCur(Locale locale) {
        if (locale == null) {
            throw NullErr.make();
        }
        cur.set(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale use(Func func) {
        Locale locale = Locale.cur();
        try {
            Locale.setCur(this);
            func.call(this);
        }
        finally {
            Locale.setCur(locale);
        }
        return this;
    }

    public String lang() {
        return this.lang;
    }

    public String country() {
        return this.country;
    }

    public Type typeof() {
        return Sys.LocaleType;
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    public long hash() {
        return FanStr.hash(this.str);
    }

    public boolean equals(Object object) {
        if (object instanceof Locale) {
            return ((Locale)object).str.equals(this.str);
        }
        return false;
    }

    public String toStr() {
        return this.str;
    }

    public java.util.Locale java() {
        if (this.javaLocale == null) {
            this.javaLocale = new java.util.Locale(this.lang, this.country == null ? "" : this.country);
        }
        return this.javaLocale;
    }

    public Collator collator() {
        if (this.javaCollator == null) {
            this.javaCollator = Collator.getInstance(this.java());
            this.javaCollator.setStrength(0);
        }
        return this.javaCollator;
    }

    public DecimalFormatSymbols decimal() {
        if (this.javaDecimal == null) {
            this.javaDecimal = new DecimalFormatSymbols(this.java());
        }
        return this.javaDecimal;
    }

    Month monthByName(String string) {
        if (this.monthsByName == null) {
            HashMap<String, Month> hashMap = new HashMap<String, Month>(31);
            for (int i = 0; i < Month.array.length; ++i) {
                Month month = Month.array[i];
                hashMap.put(FanStr.lower(month.abbr(this)), month);
                hashMap.put(FanStr.lower(month.full(this)), month);
            }
            this.monthsByName = hashMap;
        }
        return (Month)this.monthsByName.get(string);
    }

    static {
        Locale locale;
        cur = new ThreadLocal(){

            protected Object initialValue() {
                return defaultLocale;
            }
        };
        try {
            String string = java.util.Locale.getDefault().getLanguage();
            String string2 = java.util.Locale.getDefault().getCountry();
            locale = string2 == null && string2.length() == 0 ? Locale.fromStr(string) : Locale.fromStr(string + "-" + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            locale = Locale.fromStr("en");
        }
        defaultLocale = locale;
        en = Locale.fromStr("en");
    }
}

