/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Err;
import fan.sys.Facet;
import fan.sys.Facets;
import fan.sys.FanObj;
import fan.sys.Field;
import fan.sys.Func;
import fan.sys.List;
import fan.sys.Method;
import fan.sys.Sys;
import fan.sys.Type;
import fanx.serial.Literal;
import fanx.serial.ObjEncoder;

public abstract class Slot
extends FanObj
implements Literal {
    final int flags;
    final String name;
    final String qname;
    Type parent;
    final Facets facets;
    public String doc;
    public final int lineNum;

    public static Method findMethod(String string) {
        return (Method)Slot.find(string, true);
    }

    public static Method findMethod(String string, boolean bl) {
        return (Method)Slot.find(string, bl);
    }

    public static Field findField(String string) {
        return (Field)Slot.find(string, true);
    }

    public static Field findField(String string, boolean bl) {
        return (Field)Slot.find(string, bl);
    }

    public static Slot find(String string) {
        return Slot.find(string, true);
    }

    public static Slot find(String string, boolean bl) {
        String string2;
        String string3;
        try {
            int n = string.lastIndexOf(46);
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        catch (Exception exception) {
            throw Err.make("Invalid slot qname \"" + string + "\", use <pod>::<type>.<slot>");
        }
        Type type = Type.find(string3, bl);
        if (type == null) {
            return null;
        }
        return type.slot(string2, bl);
    }

    public static Func findFunc(String string) {
        return Slot.findFunc(string, true);
    }

    public static Func findFunc(String string, boolean bl) {
        Method method = (Method)Slot.find(string, bl);
        if (method == null) {
            return null;
        }
        return method.func;
    }

    public Slot(Type type, String string, int n, Facets facets, int n2) {
        this.parent = type;
        this.name = string;
        this.qname = type == null ? string : type.qname() + "." + string;
        this.flags = n;
        this.facets = facets;
        this.lineNum = n2;
    }

    public Type typeof() {
        return Sys.SlotType;
    }

    public Type parent() {
        return this.parent;
    }

    public String name() {
        return this.name;
    }

    public String qname() {
        return this.qname;
    }

    public boolean isField() {
        return this instanceof Field;
    }

    public boolean isMethod() {
        return this instanceof Method;
    }

    public abstract String signature();

    public final int flags() {
        return this.flags;
    }

    public final boolean isAbstract() {
        return (this.flags & 1) != 0;
    }

    public boolean isConst() {
        return (this.flags & 2) != 0;
    }

    public final boolean isCtor() {
        return (this.flags & 4) != 0;
    }

    public final boolean isInternal() {
        return (this.flags & 0x80) != 0;
    }

    public final boolean isNative() {
        return (this.flags & 0x200) != 0;
    }

    public final boolean isOverride() {
        return (this.flags & 0x400) != 0;
    }

    public final boolean isPrivate() {
        return (this.flags & 0x800) != 0;
    }

    public final boolean isProtected() {
        return (this.flags & 0x1000) != 0;
    }

    public final boolean isPublic() {
        return (this.flags & 0x2000) != 0;
    }

    public final boolean isStatic() {
        return (this.flags & 0x8000) != 0;
    }

    public final boolean isSynthetic() {
        return (this.flags & 0x20000) != 0;
    }

    public final boolean isVirtual() {
        return (this.flags & 0x40000) != 0;
    }

    public Object trap(String string, List list) {
        if (string.equals("flags")) {
            return (long)this.flags;
        }
        if (string.equals("lineNumber")) {
            return (long)this.lineNum;
        }
        return super.trap(string, list);
    }

    public List facets() {
        return this.facets.list();
    }

    public Facet facet(Type type) {
        return this.facets.get(type, true);
    }

    public Facet facet(Type type, boolean bl) {
        return this.facets.get(type, bl);
    }

    public final boolean hasFacet(Type type) {
        return this.facet(type, false) != null;
    }

    public String doc() {
        this.parent.doc();
        return this.doc;
    }

    public String toStr() {
        return this.qname;
    }

    public void encode(ObjEncoder objEncoder) {
        this.parent.encode(objEncoder);
        objEncoder.w(this.name);
    }
}

