/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.Date;
import fan.sys.DateTime;
import fan.sys.DateTimeStr;
import fan.sys.Duration;
import fan.sys.Env;
import fan.sys.FanObj;
import fan.sys.Locale;
import fan.sys.ParseErr;
import fan.sys.Sys;
import fan.sys.TimeZone;
import fan.sys.Type;

public final class Time
extends FanObj {
    private static final String localeKey = "time";
    public static final Time defVal = new Time(0, 0, 0, 0);
    final byte hour;
    final byte min;
    final byte sec;
    final int ns;

    public static Time now() {
        return DateTime.now().time();
    }

    public static Time now(TimeZone timeZone) {
        return DateTime.makeTicks(DateTime.nowTicks(), timeZone).time();
    }

    public static Time make(long l, long l2) {
        return Time.make(l, l2, 0L, 0L);
    }

    public static Time make(long l, long l2, long l3) {
        return Time.make(l, l2, l3, 0L);
    }

    public static Time make(long l, long l2, long l3, long l4) {
        return new Time((int)l, (int)l2, (int)l3, (int)l4);
    }

    Time(int n, int n2, int n3, int n4) {
        if (n < 0 || n > 23) {
            throw ArgErr.make("hour " + n);
        }
        if (n2 < 0 || n2 > 59) {
            throw ArgErr.make("min " + n2);
        }
        if (n3 < 0 || n3 > 59) {
            throw ArgErr.make("sec " + n3);
        }
        if (n4 < 0 || n4 > 999999999) {
            throw ArgErr.make("ns " + n4);
        }
        this.hour = (byte)n;
        this.min = (byte)n2;
        this.sec = (byte)n3;
        this.ns = n4;
    }

    public static Time fromStr(String string) {
        return Time.fromStr(string, true);
    }

    public static Time fromStr(String string, boolean bl) {
        try {
            int n = Time.num(string, 0) * 10 + Time.num(string, 1);
            int n2 = Time.num(string, 3) * 10 + Time.num(string, 4);
            int n3 = Time.num(string, 6) * 10 + Time.num(string, 7);
            if (string.charAt(2) != ':' || string.charAt(5) != ':') {
                throw new Exception();
            }
            int n4 = 8;
            int n5 = 0;
            int n6 = 100000000;
            int n7 = string.length();
            if (n4 < n7 && string.charAt(n4) == '.') {
                char c;
                ++n4;
                while (n4 < n7 && (c = string.charAt(n4)) >= '0' && c <= '9') {
                    n5 += (c - 48) * n6;
                    n6 /= 10;
                    ++n4;
                }
            }
            if (n4 < string.length()) {
                throw new Exception();
            }
            return new Time(n, n2, n3, n5);
        }
        catch (Exception exception) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("Time", string);
        }
    }

    static int num(String string, int n) {
        return string.charAt(n) - 48;
    }

    public final boolean equals(Object object) {
        if (object instanceof Time) {
            Time time = (Time)object;
            return this.hour == time.hour && this.min == time.min && this.sec == time.sec && this.ns == time.ns;
        }
        return false;
    }

    public long compare(Object object) {
        Time time = (Time)object;
        if (this.hour == time.hour) {
            if (this.min == time.min) {
                if (this.sec == time.sec) {
                    if (this.ns == time.ns) {
                        return 0L;
                    }
                    return this.ns < time.ns ? -1L : 1L;
                }
                return this.sec < time.sec ? -1L : 1L;
            }
            return this.min < time.min ? -1L : 1L;
        }
        return this.hour < time.hour ? -1L : 1L;
    }

    public int hashCode() {
        return this.hour << 24 ^ this.min << 20 ^ this.sec << 16 ^ this.ns;
    }

    public long hash() {
        return this.hour << 24 ^ this.min << 20 ^ this.sec << 16 ^ this.ns;
    }

    public final String toStr() {
        return this.toLocale("hh:mm:ss.FFFFFFFFF");
    }

    public Type typeof() {
        return Sys.TimeType;
    }

    public final long hour() {
        return this.hour;
    }

    public final int getHour() {
        return this.hour;
    }

    public final long min() {
        return this.min;
    }

    public final int getMin() {
        return this.min;
    }

    public final long sec() {
        return this.sec;
    }

    public final int getSec() {
        return this.sec;
    }

    public final long nanoSec() {
        return this.ns;
    }

    public final int getNanoSec() {
        return this.ns;
    }

    public String toLocale() {
        return this.toLocale(null);
    }

    public String toLocale(String string) {
        Locale locale = null;
        if (string == null) {
            if (locale == null) {
                locale = Locale.cur();
            }
            string = Env.cur().locale(Sys.sysPod, localeKey, "hh:mm:ss", locale);
        }
        return new DateTimeStr(string, locale, this).format();
    }

    public static Time fromLocale(String string, String string2) {
        return Time.fromLocale(string, string2, true);
    }

    public static Time fromLocale(String string, String string2, boolean bl) {
        return new DateTimeStr(string2, null).parseTime(string, bl);
    }

    public String toIso() {
        return this.toStr();
    }

    public static Time fromIso(String string) {
        return Time.fromStr(string, true);
    }

    public static Time fromIso(String string, boolean bl) {
        return Time.fromStr(string, bl);
    }

    public static Time fromDuration(Duration duration) {
        long l = duration.ticks;
        if (l == 0L) {
            return defVal;
        }
        if (l < 0L || l > 86400000000000L) {
            throw ArgErr.make("Duration out of range: " + duration);
        }
        int n = (int)(l / 3600000000000L);
        int n2 = (int)((l %= 3600000000000L) / 60000000000L);
        int n3 = (int)((l %= 60000000000L) / 1000000000L);
        int n4 = (int)(l %= 1000000000L);
        return new Time(n, n2, n3, n4);
    }

    public Duration toDuration() {
        return Duration.make((long)this.hour * 3600000000000L + (long)this.min * 60000000000L + (long)this.sec * 1000000000L + (long)this.ns);
    }

    public DateTime toDateTime(Date date) {
        return DateTime.makeDT(date, this);
    }

    public DateTime toDateTime(Date date, TimeZone timeZone) {
        return DateTime.makeDT(date, this, timeZone);
    }

    public String toCode() {
        if (this.equals(defVal)) {
            return "Time.defVal";
        }
        return "Time(\"" + this.toString() + "\")";
    }

    public boolean isMidnight() {
        return this.equals(defVal);
    }
}

