/*
 * Decompiled with CFR 0.152.
 */
package fanx.fcode;

import fan.sys.Depend;
import fan.sys.Map;
import fan.sys.SysInStream;
import fan.sys.UnknownTypeErr;
import fanx.fcode.FConst;
import fanx.fcode.FFieldRef;
import fanx.fcode.FLiterals;
import fanx.fcode.FMethodRef;
import fanx.fcode.FStore;
import fanx.fcode.FTable;
import fanx.fcode.FType;
import fanx.fcode.FTypeRef;
import java.io.IOException;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class FPod
implements FConst {
    public String podName;
    public String podVersion;
    public Depend[] depends;
    public String fcodeVersion;
    public Map meta;
    public FStore store;
    public FType[] types;
    public FTable names;
    public FTable typeRefs;
    public FTable fieldRefs;
    public FTable methodRefs;
    public FLiterals literals;

    public FPod(String string, FStore fStore) {
        if (fStore != null) {
            fStore.fpod = this;
        }
        this.podName = string;
        this.store = fStore;
        this.names = new FTable.Names(this);
        this.typeRefs = new FTable.TypeRefs(this);
        this.fieldRefs = new FTable.FieldRefs(this);
        this.methodRefs = new FTable.MethodRefs(this);
    }

    public FType type(String string) {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.typeRef((int)this.types[i].self).typeName.equals(string)) continue;
            return this.types[i];
        }
        throw UnknownTypeErr.make(string);
    }

    public final String name(int n) {
        return (String)this.names.get(n);
    }

    public final FTypeRef typeRef(int n) {
        return (FTypeRef)this.typeRefs.get(n);
    }

    public final FFieldRef fieldRef(int n) {
        return (FFieldRef)this.fieldRefs.get(n);
    }

    public final FMethodRef methodRef(int n) {
        return (FMethodRef)this.methodRefs.get(n);
    }

    public void read() throws IOException {
        this.readPodMeta(this.store.read("meta.props", true));
        this.names.read(this.store.read("fcode/names.def"));
        this.typeRefs.read(this.store.read("fcode/typeRefs.def"));
        this.fieldRefs.read(this.store.read("fcode/fieldRefs.def"));
        this.methodRefs.read(this.store.read("fcode/methodRefs.def"));
        this.readTypeMeta(this.store.read("fcode/types.def", true));
    }

    public FLiterals readLiterals() throws IOException {
        if (this.literals == null) {
            this.literals = new FLiterals(this).read();
        }
        return this.literals;
    }

    public void readFully() throws IOException {
        this.read();
        for (int i = 0; i < this.types.length; ++i) {
            this.types[i].read();
        }
    }

    public void readFully(final ZipInputStream zipInputStream) throws IOException {
        ZipEntry zipEntry;
        FStore.Input input = new FStore.Input(this, zipInputStream){

            public void close() throws IOException {
                zipInputStream.closeEntry();
            }
        };
        this.literals = new FLiterals(this);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (string.equals("meta.props")) {
                this.readPodMeta(input);
                continue;
            }
            if (string.startsWith("fcode/") && string.endsWith(".fcode")) {
                this.readType(string, input);
                continue;
            }
            if (string.equals("fcode/names.def")) {
                this.names.read(input);
                continue;
            }
            if (string.equals("fcode/typeRefs.def")) {
                this.typeRefs.read(input);
                continue;
            }
            if (string.equals("fcode/fieldRefs.def")) {
                this.fieldRefs.read(input);
                continue;
            }
            if (string.equals("fcode/methodRefs.def")) {
                this.methodRefs.read(input);
                continue;
            }
            if (string.equals("fcode/types.def")) {
                this.readTypeMeta(input);
                continue;
            }
            if (string.equals("fcode/ints.def")) {
                this.literals.ints.read(input);
                continue;
            }
            if (string.equals("fcode/floats.def")) {
                this.literals.floats.read(input);
                continue;
            }
            if (string.equals("fcode/decimals.def")) {
                this.literals.decimals.read(input);
                continue;
            }
            if (string.equals("fcode/strs.def")) {
                this.literals.strs.read(input);
                continue;
            }
            if (string.equals("fcode/durations.def")) {
                this.literals.durations.read(input);
                continue;
            }
            if (string.equals("fcode/uris.def")) {
                this.literals.uris.read(input);
                continue;
            }
            System.out.println("WARNING: unexpected file in pod: " + string);
        }
    }

    private void readPodMeta(FStore.Input input) throws IOException {
        if ("sys".equals(this.podName)) {
            Properties properties = new Properties();
            properties.load(input);
            input.close();
            String string = properties.getProperty("pod.name");
            this.podVersion = properties.getProperty("pod.version");
            this.fcodeVersion = properties.getProperty("fcode.version");
            this.depends = new Depend[0];
            return;
        }
        SysInStream sysInStream = new SysInStream(input);
        this.meta = (Map)sysInStream.readProps().toImmutable();
        sysInStream.close();
        String string = this.meta("pod.name");
        this.podVersion = this.meta("pod.version");
        this.fcodeVersion = this.meta("fcode.version");
        String string2 = this.meta("pod.depends").trim();
        if (string2.length() == 0) {
            this.depends = new Depend[0];
        } else {
            String[] stringArray = string2.split(";");
            this.depends = new Depend[stringArray.length];
            for (int i = 0; i < this.depends.length; ++i) {
                this.depends[i] = Depend.fromStr(stringArray[i].trim());
            }
        }
        if (this.podName == null) {
            this.podName = string;
        }
        if (!this.podName.equals(string)) {
            throw new IOException("Pod name mismatch " + this.podName + " != " + string);
        }
        if (!"1.0.51".equals(this.fcodeVersion)) {
            throw new IOException("Invalid fcode version " + this.fcodeVersion);
        }
    }

    private String meta(String string) throws IOException {
        String string2 = (String)this.meta.get(string);
        if (string2 == null) {
            throw new IOException("meta.prop missing " + string);
        }
        return string2;
    }

    private void readTypeMeta(FStore.Input input) throws IOException {
        this.types = new FType[input.u2()];
        for (int i = 0; i < this.types.length; ++i) {
            this.types[i] = new FType(this).readMeta(input);
            this.types[i].hollow = true;
        }
        input.close();
    }

    private void readType(String string, FStore.Input input) throws IOException {
        if (this.types == null || this.types.length == 0) {
            throw new IOException("types.def must be defined first");
        }
        String string2 = string.substring(6, string.length() - ".fcode".length());
        for (int i = 0; i < this.types.length; ++i) {
            String string3 = this.typeRef((int)this.types[i].self).typeName;
            if (!string3.equals(string2)) continue;
            this.types[i].read(input);
            return;
        }
        throw new IOException("Unexpected fcode file: " + string);
    }
}

