/*
 * Decompiled with CFR 0.152.
 */
package fanx.fcode;

import fanx.fcode.FAttrs;
import fanx.fcode.FBuf;
import fanx.fcode.FCodePrinter;
import fanx.fcode.FConst;
import fanx.fcode.FField;
import fanx.fcode.FMethod;
import fanx.fcode.FMethodVar;
import fanx.fcode.FPod;
import fanx.fcode.FSlot;
import fanx.fcode.FType;
import fanx.util.StrUtil;
import java.io.OutputStream;
import java.io.PrintWriter;

public class FPrinter
extends PrintWriter
implements FConst {
    public final FPod pod;
    public boolean showIndex = false;
    public boolean showCode = true;
    public boolean showLines = false;

    public FPrinter(FPod fPod, OutputStream outputStream) {
        super(outputStream);
        this.pod = fPod;
    }

    public FPrinter(FPod fPod) {
        this(fPod, System.out);
    }

    public void all() {
        this.tables();
        this.types();
        this.flush();
    }

    public void tables() {
        this.println("##### Tables #####");
        this.println("--- names ---");
        this.pod.names.dump(this.pod, this);
        this.println("--- typeRefs ---");
        this.pod.typeRefs.dump(this.pod, this);
        this.println("--- fieldRefs ---");
        this.pod.fieldRefs.dump(this.pod, this);
        this.println("--- methodRefs ---");
        this.pod.methodRefs.dump(this.pod, this);
        this.println("--- ints ---");
        this.pod.literals.ints.dump(this.pod, this);
        this.println("--- floats ---");
        this.pod.literals.floats.dump(this.pod, this);
        this.println("--- strs ---");
        this.pod.literals.strs.dump(this.pod, this);
        this.println("--- durations ---");
        this.pod.literals.durations.dump(this.pod, this);
        this.println("--- uris ---");
        this.pod.literals.uris.dump(this.pod, this);
        this.flush();
    }

    public void types() {
        this.println("##### Types #####");
        for (int i = 0; i < this.pod.types.length; ++i) {
            this.type(this.pod.types[i]);
        }
        this.flush();
    }

    public void type(FType fType) {
        int n;
        this.println("--" + this.typeRef(fType.self) + " extends " + this.typeRef(fType.base) + "--");
        if (fType.mixins.length > 0) {
            this.print("  mixin ");
            for (n = 0; n < fType.mixins.length; ++n) {
                if (n > 0) {
                    this.print(", ");
                }
                this.print(this.typeRef(fType.mixins[n]));
            }
            this.println();
        }
        this.attrs(fType.attrs);
        this.println();
        for (n = 0; n < fType.fields.length; ++n) {
            this.field(fType.fields[n]);
        }
        for (n = 0; n < fType.methods.length; ++n) {
            this.method(fType.methods[n]);
        }
        this.flush();
    }

    public void slot(FSlot fSlot) {
        if (fSlot instanceof FField) {
            this.field((FField)fSlot);
        } else {
            this.method((FMethod)fSlot);
        }
        this.flush();
    }

    public void field(FField fField) {
        this.println("  " + this.typeRef(fField.type) + " " + fField.name + " [" + StrUtil.flagsToString(fField.flags).trim() + "]");
        this.attrs(fField.attrs);
        this.println();
    }

    public void method(FMethod fMethod) {
        FMethodVar fMethodVar;
        int n;
        this.print("  " + this.typeRef(fMethod.ret) + " " + fMethod.name + "(");
        FMethodVar[] fMethodVarArray = fMethod.params();
        for (n = 0; n < fMethodVarArray.length; ++n) {
            fMethodVar = fMethodVarArray[n];
            if (n > 0) {
                this.print(", ");
            }
            this.print(this.typeRef(fMethodVar.type) + " " + fMethodVar.name);
        }
        this.println(") [" + StrUtil.flagsToString(fMethod.flags).trim() + "]");
        for (n = 0; n < fMethod.vars.length; ++n) {
            fMethodVar = fMethod.vars[n];
            String string = fMethodVar.isParam() ? "Param" : "Local";
            int n2 = n + ((fMethod.flags & 0x8000) != 0 ? 0 : 1);
            this.println("    [" + string + " " + n2 + "] " + fMethodVar.name + ": " + this.typeRef(fMethodVar.type));
            if (fMethodVar.def == null) continue;
            this.code(fMethodVar.def);
        }
        if (fMethod.code != null) {
            this.println("    [Code]");
            this.code(fMethod.code);
        }
        this.attrs(fMethod.attrs);
        this.println();
    }

    public void code(FBuf fBuf) {
        if (!this.showCode) {
            return;
        }
        this.flush();
        new FCodePrinter(this.pod, this.out).code(fBuf);
    }

    public void attrs(FAttrs fAttrs) {
    }

    private String typeRef(int n) {
        if (n == 65535) {
            return "null";
        }
        return this.pod.typeRefs.toString(n) + this.showIndex(n);
    }

    private String name(int n) {
        return this.pod.name(n) + this.showIndex(n);
    }

    private String showIndex(int n) {
        if (this.showIndex) {
            return "[" + n + "]";
        }
        return "";
    }
}

