/*
 * Decompiled with CFR 0.152.
 */
package fanx.test;

import fan.sys.Charset;
import fan.sys.MemBuf;
import fan.sys.OutStream;
import fan.sys.SysInStream;
import fan.sys.SysOutStream;
import fanx.test.Test;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class CharsetTest
extends Test {
    public void run() throws Exception {
        this.verifyFactory();
        this.verifyUnicode();
        this.verifyISO_8859();
    }

    public void verifyFactory() {
        this.verify(Charset.fromStr("UTF-8", true) == Charset.utf8());
        this.verify(Charset.fromStr("Utf-8", true) == Charset.utf8());
        this.verify(Charset.fromStr("utf-8", true) == Charset.utf8());
        this.verify(Charset.fromStr("utf8", true) == Charset.utf8());
        this.verify(Charset.fromStr("UTF-16BE", true) == Charset.utf16BE());
        this.verify(Charset.fromStr("Utf-16BE", true) == Charset.utf16BE());
        this.verify(Charset.fromStr("utf-16be", true) == Charset.utf16BE());
        this.verify(Charset.fromStr("UTF-16LE", true) == Charset.utf16LE());
        this.verify(Charset.fromStr("Utf-16LE", true) == Charset.utf16LE());
        this.verify(Charset.fromStr("utf-16le", true) == Charset.utf16LE());
    }

    public void verifyUnicode() throws Exception {
        String[] stringArray = new String[]{"a", "ab", "abc", "\u0080", "\u00fe", "\uabcd", "x\u00fe", "x\uabcd", "\uabcd-\u00fe"};
        Charset[] charsetArray = new Charset[]{Charset.utf8(), Charset.utf16BE(), Charset.utf16LE()};
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < charsetArray.length; ++j) {
                this.verifyCoders(stringArray[i], charsetArray[j]);
            }
        }
    }

    public void verifyISO_8859() throws Exception {
        String string = "ab\u00c0\u00fd\u00fe";
        this.verifyCoders(string, Charset.fromStr("ISO-8859-1", true));
        this.verifyCoders(string, Charset.fromStr("8859_1", true));
        this.verifyCoders(string, Charset.fromStr("cp819", true));
        this.verifyCoders(string, Charset.fromStr("latin1", true));
        string = "ab\u0107\u00f7\u02d9";
        this.verifyCoders(string, Charset.fromStr("ISO-8859-2", true));
        string = "ab\u0440\u2116\u045f";
        this.verifyCoders(string, Charset.fromStr("ISO-8859-5", true));
        string = "ab\u05d0\u05e0\u200f";
        this.verifyCoders(string, Charset.fromStr("ISO-8859-8", true));
    }

    public void verifyCoders(String string, Charset charset) throws Exception {
        Long l;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, charset.name());
        outputStreamWriter.write(string);
        outputStreamWriter.flush();
        MemBuf memBuf = new MemBuf(1024);
        memBuf.charset(charset);
        for (int i = 0; i < string.length(); ++i) {
            memBuf.writeChar(string.charAt(i));
        }
        this.verify(byteArrayOutputStream.toByteArray(), memBuf.bytes());
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        SysOutStream sysOutStream = new SysOutStream(byteArrayOutputStream2);
        sysOutStream.charset(charset);
        for (int i = 0; i < string.length(); ++i) {
            ((OutStream)sysOutStream).writeChar((long)string.charAt(i));
        }
        ((OutStream)sysOutStream).flush();
        this.verify(byteArrayOutputStream.toByteArray(), byteArrayOutputStream2.toByteArray());
        String string2 = "";
        memBuf.flip();
        while (memBuf.more()) {
            string2 = string2 + (char)memBuf.readChar().longValue();
        }
        this.verify(memBuf.readChar() == null);
        this.verify(string2.equals(string));
        String string3 = "";
        SysInStream sysInStream = new SysInStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        sysInStream.charset(charset);
        while ((l = sysInStream.readChar()) != null) {
            string3 = string3 + (char)l.longValue();
        }
        this.verify(string3.equals(string));
    }

    private void verify(byte[] byArray, byte[] byArray2) {
        this.verify(byArray.length == byArray2.length);
        for (int i = 0; i < byArray.length; ++i) {
            this.verify(byArray[i] == byArray2[i]);
        }
    }
}

