//
// Copyright (c) 2008, Brian Frank and Andy Frank
// Licensed under the Academic Free License version 3.0
//
// History:
//   11 Jul 08  Brian Frank  Creation
//

**
** PenTest
**
@Js
class PenTest : Test
{

  Void testMake()
  {
    verifyPen(Pen.defVal, 1, Pen.capSquare, Pen.joinMiter, "1")
    verifyPen(Pen#.make, 1, Pen.capSquare, Pen.joinMiter, "1")
    verifyPen(Pen {}, 1, Pen.capSquare, Pen.joinMiter, "1")
    verifyPen(Pen { width=3 }, 3, Pen.capSquare, Pen.joinMiter, "3")
    verifyPen(Pen { cap=Pen.capSquare }, 1, Pen.capSquare, Pen.joinMiter, "1")
    verifyPen(Pen { cap=Pen.capButt }, 1, Pen.capButt, Pen.joinMiter, "1 capButt")
    verifyPen(Pen { cap=Pen.capRound }, 1, Pen.capRound, Pen.joinMiter, "1 capRound")
    verifyPen(Pen { join=Pen.joinMiter }, 1, Pen.capSquare, Pen.joinMiter, "1")
    verifyPen(Pen { join=Pen.joinBevel }, 1, Pen.capSquare, Pen.joinBevel, "1 joinBevel")
    verifyPen(Pen { join=Pen.joinRound }, 1, Pen.capSquare, Pen.joinRound, "1 joinRound")
    verifyPen(Pen { width=3; cap=Pen.capRound; join=Pen.joinRound }, 3, Pen.capRound, Pen.joinRound, "3 capRound joinRound")

    verifyEq(Pen.fromStr("capRound 4"), Pen { width=4; cap=Pen.capRound })
    verifyEq(Pen.fromStr("foo", false), null)
    verifyErr(ParseErr#) { Pen.fromStr("foo") }
    verifyErr(ParseErr#) { Pen.fromStr("", true) }
  }

  Void testDash()
  {
    p := Pen { dash=[1,2] }
    verifyEq(p.width, 1)
    verifyEq(p.dash, [1,2])
    verify(p.dash.isImmutable)
    verifyEq(p.toStr, "1 [1,2]")
    verifyEq(p, Buf().writeObj(p).flip.readObj)
    verifyEq(Pen.fromStr("2 capButt [3, 4, 5]"), Pen { width=2; cap=Pen.capButt; dash=[3,4,5] })
    verify(Pen.fromStr("2 capButt [3, 4, 5]").dash.isImmutable)
  }

  Void verifyPen(Pen p, Int w, Int c, Int j, Str str)
  {
    verifyEq(p.width, w)
    verifyEq(p.cap,   c)
    verifyEq(p.join,  j)
    verifyEq(p.toStr, str)

    capStrs := [Pen.capButt:"butt", Pen.capRound:"round", Pen.capSquare:"square"]
    verifyEq(p.capToStr, capStrs[c])

    joinStrs := [Pen.joinRound:"round", Pen.joinBevel:"bevel", Pen.joinMiter:"miter"]
    verifyEq(p.joinToStr, joinStrs[j])

    verifyEq(p, Pen { width = w; cap = c; join = j })
    verifyNotEq(p, Pen { width = w+1; cap = c; join = j })
    verifyNotEq(p, Pen { width = w; cap = (c+1)%3; join = j })
    verifyNotEq(p, Pen { width = w; cap = c; join = (j+1)%3 })

    verifyEq(p, Pen.fromStr(p.toStr))
    verifyEq(p, Buf().writeObj(p).flip.readObj)
  }

}