// (c) Microsoft Corporation 2005-2007.

#light 

namespace Microsoft.FSharp.Core

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module UInt16 = 

    let compare (x:uint16) y = compare x y

    let zero = 0us
    let one = 1us
    let add (x:uint16) (y:uint16) = x + y
    let sub (x:uint16) (y:uint16) = x - y
    let mul (x:uint16) (y:uint16) = x * y
    let div (x:uint16) (y:uint16) = x / y
    let rem (x:uint16) (y:uint16) = x % y
    let succ (x:uint16) = x + 1us
    let pred (x:uint16) = x - 1us
    let max_int = 0xFFFFus
    let min_int = 0us
    let logand (x:uint16) (y:uint16) = x &&& y
    let logor (x:uint16) (y:uint16) = x ||| y
    let logxor (x:uint16) (y:uint16) = x ^^^ y
    let lognot (x:uint16) = ~~~ x
    let shift_left (x:uint16) (n:int) =  x <<< n
    let shift_right (x:uint16) (n:int) =  x >>> n

    let of_int (n:int)    = (# "conv.u2" n : uint16 #)
    let to_int (x:uint16) = (# "conv.i4" x : int #)

    let of_int16 (n:int16)  = (# "conv.u2" n : uint16 #)
    let to_int16 (x:uint16) = (# "conv.i2" x : int16 #)

    let of_int32 (n:int32)  = (# "conv.u2" n : uint16 #)
    let to_int32 (x:uint16) = (# "conv.i4" x : int32 #)

    let of_uint32 (n:uint32) = (# "conv.u2" n : uint16 #)
    let to_uint32 (x:uint16) = (# "conv.u4" x : uint32 #)

    let of_uint8 (n:uint8) = (# "conv.u2" n : uint16 #)
    let to_uint8 (x:uint16) = (# "conv.u1" x : uint8 #)
