//==========================================================================
// (c) Microsoft Corporation 2005-2007.  
//==========================================================================

#light

namespace Microsoft.FSharp.Compatibility.OCaml

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core.Operators

/// Unicode characters, i.e. the [[System.Char]] type.  see also the operations
/// in [[System.Char]] and the [[System.Text.Encoding]] interfaces if necessary.
[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Char = 

    /// Converts the value of the specified 32-bit signed integer to its equivalent Unicode character
    val chr: i:int -> char
    /// Converts the value of the specified Unicode character to the equivalent 32-bit signed integer
    val code: c:char -> int
    /// Compares a and b and returns 1 if a &gt; b, -1 if b &lt; a and 0 if a = b
    val compare: a:char -> b:char -> int
    /// Converts the value of a Unicode character to its lowercase equivalent
    val lowercase: char -> char
    /// Converts the value of a Unicode character to its uppercase equivalent
    val uppercase: char -> char 