//==========================================================================
// (c) Microsoft Corporation 2005-2007.  
//==========================================================================

#light

namespace Microsoft.FSharp.Core

open Microsoft.FSharp.Core
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Byte= 

    let compare (x:byte) y = compare x y

    let zero = 0uy
    let one = 1uy
    let add (x:byte) (y:byte) = x + y
    let sub (x:byte) (y:byte) = x - y
    let mul (x:byte) (y:byte) = x * y
    let div (x:byte) (y:byte) = x / y
    let rem (x:byte) (y:byte) = x % y
    let succ (x:byte) = x + 1uy
    let pred (x:byte) = x - 1uy
    let max_int = 0xFFuy
    let min_int = 0uy
    let logand (x:byte) (y:byte) = x &&& y
    let logor (x:byte) (y:byte) = x ||| y
    let logxor (x:byte) (y:byte) = x ^^^ y
    let lognot (x:byte) = ~~~x
    let shift_left (x:byte) (n:int) =  x <<< n
    let shift_right (x:byte) (n:int) =  x >>> n
    let of_int (n:int) =  (# "conv.u1" n : byte #)
    let to_int (x:byte) = (# "" x : int #)
    let of_char (n:char) =  (# "conv.u1" n : byte #)
    let to_char (x:byte) = (# "" x : char #)
    let of_string (s:string) = 
        try System.Byte.Parse(s,System.Globalization.CultureInfo.InvariantCulture) 
        with :? System.FormatException -> failwith "Byte.of_string"
      
    let to_string (x:byte) =  (box x).ToString()

    let of_int32 (n:int32) = (# "conv.u1" n : uint8 #)
    let to_int32 (x:uint8) = (# "conv.i4" x : int32 #)

    let of_uint16 (n:uint16) = (# "conv.u1" n : uint8 #)
    let to_uint16 (x:uint8)  = (# "conv.u2" x : uint16 #)

    let of_uint32 (n:uint32) = (# "conv.u1" n : uint8 #)
    let to_uint32 (x:uint8)  = (# "conv.u4" x : uint32 #)
